/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;

public final class Lister {
    private static final ArchiveStreamFactory factory = new ArchiveStreamFactory();

    public static void main(String[] args) throws Exception {
        ArchiveEntry ae;
        if (args.length == 0) {
            Lister.usage();
            return;
        }
        String string = String.valueOf(args[0]);
        System.out.println(string.length() != 0 ? "Analysing ".concat(string) : new String("Analysing "));
        File f = new File(args[0]);
        if (!f.isFile()) {
            String string2 = String.valueOf(f);
            System.err.println(new StringBuilder(32 + String.valueOf(string2).length()).append(string2).append(" doesn't exist or is a directory").toString());
        }
        BufferedInputStream fis = new BufferedInputStream(new FileInputStream(f));
        ArchiveInputStream ais = args.length > 1 ? factory.createArchiveInputStream(args[1], fis) : factory.createArchiveInputStream(fis);
        String string3 = String.valueOf(ais.toString());
        System.out.println(string3.length() != 0 ? "Created ".concat(string3) : new String("Created "));
        while ((ae = ais.getNextEntry()) != null) {
            System.out.println(ae.getName());
        }
        ais.close();
        ((InputStream)fis).close();
    }

    private static void usage() {
        System.out.println("Parameters: archive-name [archive-type]");
    }
}

