/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.sevenz;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZFile;
import org.apache.commons.compress.archivers.sevenz.SevenZMethodConfiguration;

public class CLI {
    private static final byte[] BUF = new byte[8192];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            CLI.usage();
            return;
        }
        Mode mode = CLI.grabMode(args);
        String string = mode.getMessage();
        String string2 = args[0];
        System.out.println(new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(" ").append(string2).toString());
        File f = new File(args[0]);
        if (!f.isFile()) {
            string2 = String.valueOf(f);
            System.err.println(new StringBuilder(32 + String.valueOf(string2).length()).append(string2).append(" doesn't exist or is a directory").toString());
        }
        try (SevenZFile archive = new SevenZFile(f);){
            SevenZArchiveEntry ae;
            while ((ae = archive.getNextEntry()) != null) {
                mode.takeAction(archive, ae);
            }
        }
    }

    private static void usage() {
        System.out.println("Parameters: archive-name [list|extract]");
    }

    private static Mode grabMode(String[] args) {
        if (args.length < 2) {
            return Mode.LIST;
        }
        return Enum.valueOf(Mode.class, args[1].toUpperCase());
    }

    private static enum Mode {
        LIST("Analysing"){

            @Override
            public void takeAction(SevenZFile archive, SevenZArchiveEntry entry) {
                System.out.print(entry.getName());
                if (entry.isDirectory()) {
                    System.out.print(" dir");
                } else {
                    long l = entry.getCompressedSize();
                    long l2 = entry.getSize();
                    System.out.print(new StringBuilder(42).append(" ").append(l).append("/").append(l2).toString());
                }
                if (entry.getHasLastModifiedDate()) {
                    String string = String.valueOf(entry.getLastModifiedDate());
                    System.out.print(new StringBuilder(1 + String.valueOf(string).length()).append(" ").append(string).toString());
                } else {
                    System.out.print(" no last modified date");
                }
                if (!entry.isDirectory()) {
                    String string = String.valueOf(this.getContentMethods(entry));
                    System.out.println(string.length() != 0 ? " ".concat(string) : new String(" "));
                } else {
                    System.out.println("");
                }
            }

            private String getContentMethods(SevenZArchiveEntry entry) {
                StringBuilder sb = new StringBuilder();
                boolean first = true;
                for (SevenZMethodConfiguration sevenZMethodConfiguration : entry.getContentMethods()) {
                    if (!first) {
                        sb.append(", ");
                    }
                    first = false;
                    sb.append((Object)sevenZMethodConfiguration.getMethod());
                    if (sevenZMethodConfiguration.getOptions() == null) continue;
                    sb.append("(").append(sevenZMethodConfiguration.getOptions()).append(")");
                }
                return sb.toString();
            }
        }
        ,
        EXTRACT("Extracting"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void takeAction(SevenZFile archive, SevenZArchiveEntry entry) throws IOException {
                File outFile = new File(entry.getName());
                if (entry.isDirectory()) {
                    if (!outFile.isDirectory() && !outFile.mkdirs()) {
                        String string = String.valueOf(outFile);
                        throw new IOException(new StringBuilder(24 + String.valueOf(string).length()).append("Cannot create directory ").append(string).toString());
                    }
                    String string = String.valueOf(outFile);
                    System.out.println(new StringBuilder(18 + String.valueOf(string).length()).append("created directory ").append(string).toString());
                    return;
                }
                String string = String.valueOf(outFile);
                System.out.println(new StringBuilder(14 + String.valueOf(string).length()).append("extracting to ").append(string).toString());
                File parent = outFile.getParentFile();
                if (parent != null && !parent.exists() && !parent.mkdirs()) {
                    String string2 = String.valueOf(parent);
                    throw new IOException(new StringBuilder(14 + String.valueOf(string2).length()).append("Cannot create ").append(string2).toString());
                }
                try (FileOutputStream fos = new FileOutputStream(outFile);){
                    int bytesRead;
                    long total = entry.getSize();
                    for (long off = 0L; off < total; off += (long)bytesRead) {
                        int toRead = (int)Math.min(total - off, (long)BUF.length);
                        bytesRead = archive.read(BUF, 0, toRead);
                        if (bytesRead < 1) {
                            String string3 = entry.getName();
                            long l = off;
                            throw new IOException(new StringBuilder(85 + String.valueOf(string3).length()).append("reached end of entry ").append(string3).append(" after ").append(l).append(" bytes, expected ").append(total).toString());
                        }
                        fos.write(BUF, 0, bytesRead);
                    }
                }
            }
        };

        private final String message;

        private Mode(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }

        public abstract void takeAction(SevenZFile var1, SevenZArchiveEntry var2) throws IOException;
    }
}

