/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.tar;

import org.apache.commons.compress.archivers.tar.TarConstants;
import org.apache.commons.compress.archivers.tar.TarUtils;

public class SparseHeader
implements TarConstants {
    private long offset;
    private long numBytes;

    public SparseHeader(long offset, long numBytes) {
        this.offset = offset;
        this.numBytes = numBytes;
    }

    public long getOffset() {
        return this.offset;
    }

    public long getNumBytes() {
        return this.numBytes;
    }

    public static SparseHeader parseSparseHeader(byte[] header, int offset) {
        long blockOffset = TarUtils.parseOctalOrBinary(header, offset, 12);
        long numBytes = TarUtils.parseOctalOrBinary(header, offset += 12, 12);
        offset += 12;
        if (numBytes > 0L || blockOffset > 0L) {
            return new SparseHeader(blockOffset, numBytes);
        }
        return null;
    }

    public int writeSparseHeader(byte[] outbuf, int bufOffset, boolean starMode) {
        bufOffset = TarUtils.writeEntryHeaderField(this.offset, outbuf, bufOffset, 12, starMode);
        bufOffset = TarUtils.writeEntryHeaderField(this.numBytes, outbuf, bufOffset, 12, starMode);
        return bufOffset;
    }
}

