/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.tar;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.compress.archivers.tar.SparseHeader;
import org.apache.commons.compress.archivers.tar.TarConstants;
import org.apache.commons.compress.archivers.tar.TarUtils;
import org.apache.commons.compress.archivers.zip.ZipEncoding;

public class TarArchiveSparseEntry
implements TarConstants {
    private final boolean isExtended;
    private List<SparseHeader> sparseHeaders;

    public TarArchiveSparseEntry(List<SparseHeader> sparseHeaders, boolean isExtended) {
        if (sparseHeaders == null || sparseHeaders.size() < 1 || sparseHeaders.size() > 21) {
            throw new IllegalArgumentException("sparseHeaders");
        }
        this.sparseHeaders = new ArrayList<SparseHeader>();
        this.sparseHeaders.addAll(sparseHeaders);
        this.isExtended = isExtended;
    }

    public TarArchiveSparseEntry(byte[] headerBuf) throws IOException {
        int offset = 0;
        this.sparseHeaders = new ArrayList<SparseHeader>();
        this.parseSparseHeaders(headerBuf);
        this.isExtended = TarUtils.parseBoolean(headerBuf, offset += 504);
    }

    public boolean isExtended() {
        return this.isExtended;
    }

    public List<SparseHeader> getSparseHeaders() {
        ArrayList<SparseHeader> returnValue = new ArrayList<SparseHeader>();
        returnValue.addAll(this.sparseHeaders);
        return returnValue;
    }

    public void writeEntryHeader(byte[] outbuf, ZipEncoding encoding, boolean starMode) {
        int offset = 0;
        for (SparseHeader header : this.sparseHeaders) {
            offset = header.writeSparseHeader(outbuf, offset, starMode);
        }
        while (offset < 504) {
            outbuf[offset++] = 0;
        }
        outbuf[offset++] = (byte)(this.isExtended ? 1 : 0);
        while (offset < outbuf.length) {
            outbuf[offset++] = 0;
        }
    }

    private void parseSparseHeaders(byte[] headerBuf) {
        for (int offset = 0; offset < 504; offset += 24) {
            SparseHeader sparseHeader = SparseHeader.parseSparseHeader(headerBuf, offset);
            if (sparseHeader == null) continue;
            this.sparseHeaders.add(sparseHeader);
        }
    }
}

