/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.ext;

import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import javax.swing.tree.MutableTreeNode;
import org.jgraph.event.GraphModelEvent;
import org.jgraph.event.GraphModelListener;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.ConnectionSet;
import org.jgraph.graph.DefaultEdge;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.DefaultPort;
import org.jgraph.graph.Edge;
import org.jgraph.graph.GraphCell;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.Port;
import org.jgrapht.DirectedGraph;
import org.jgrapht.Graph;
import org.jgrapht.ListenableGraph;
import org.jgrapht.event.GraphEdgeChangeEvent;
import org.jgrapht.event.GraphListener;
import org.jgrapht.event.GraphVertexChangeEvent;

public class JGraphModelAdapter<V, E>
extends DefaultGraphModel {
    private static final long serialVersionUID = 3256722883706302515L;
    final Set<GraphCell> jCellsBeingAdded = new HashSet<GraphCell>();
    final Set<GraphCell> jCellsBeingRemoved = new HashSet<GraphCell>();
    final Set<Object> jtElementsBeingAdded = new HashSet<Object>();
    final Set<Object> jtElementsBeingRemoved = new HashSet<Object>();
    private final CellFactory<V, E> cellFactory;
    private final Map<Edge, E> cellToEdge = new HashMap<Edge, E>();
    private final Map<GraphCell, V> cellToVertex = new HashMap<GraphCell, V>();
    private AttributeMap defaultEdgeAttributes;
    private AttributeMap defaultVertexAttributes;
    private final Map<E, Edge> edgeToCell = new HashMap<E, Edge>();
    private final Map<V, GraphCell> vertexToCell = new HashMap<V, GraphCell>();
    private final ShieldedGraph jtGraph;

    public JGraphModelAdapter(Graph<V, E> jGraphTGraph) {
        this(jGraphTGraph, JGraphModelAdapter.createDefaultVertexAttributes(), JGraphModelAdapter.createDefaultEdgeAttributes(jGraphTGraph));
    }

    public JGraphModelAdapter(Graph<V, E> jGraphTGraph, AttributeMap defaultVertexAttributes, AttributeMap defaultEdgeAttributes) {
        this(jGraphTGraph, defaultVertexAttributes, defaultEdgeAttributes, new DefaultCellFactory());
    }

    public JGraphModelAdapter(Graph<V, E> jGraphTGraph, AttributeMap defaultVertexAttributes, AttributeMap defaultEdgeAttributes, CellFactory<V, E> cellFactory) {
        if (jGraphTGraph == null || defaultVertexAttributes == null || defaultEdgeAttributes == null || cellFactory == null) {
            throw new IllegalArgumentException("null is NOT permitted");
        }
        this.jtGraph = new ShieldedGraph(jGraphTGraph);
        this.setDefaultVertexAttributes(defaultVertexAttributes);
        this.setDefaultEdgeAttributes(defaultEdgeAttributes);
        this.cellFactory = cellFactory;
        if (jGraphTGraph instanceof ListenableGraph) {
            ListenableGraph g = (ListenableGraph)jGraphTGraph;
            g.addGraphListener(new JGraphTListener());
        }
        Iterator<Object> i = jGraphTGraph.vertexSet().iterator();
        while (i.hasNext()) {
            this.handleJGraphTAddedVertex(i.next());
        }
        i = jGraphTGraph.edgeSet().iterator();
        while (i.hasNext()) {
            this.handleJGraphTAddedEdge(i.next());
        }
        this.addGraphModelListener(new JGraphListener());
    }

    public static <V, E> AttributeMap createDefaultEdgeAttributes(Graph<V, E> jGraphTGraph) {
        AttributeMap map = new AttributeMap();
        if (jGraphTGraph instanceof DirectedGraph) {
            GraphConstants.setLineEnd((Map)map, (int)2);
            GraphConstants.setEndFill((Map)map, (boolean)true);
            GraphConstants.setEndSize((Map)map, (int)10);
        }
        GraphConstants.setForeground((Map)map, (Color)Color.decode("#25507C"));
        GraphConstants.setFont((Map)map, (Font)GraphConstants.DEFAULTFONT.deriveFont(1, 12.0f));
        GraphConstants.setLineColor((Map)map, (Color)Color.decode("#7AA1E6"));
        return map;
    }

    public static AttributeMap createDefaultVertexAttributes() {
        AttributeMap map = new AttributeMap();
        Color c = Color.decode("#FF9900");
        GraphConstants.setBounds((Map)map, (Rectangle2D)new Rectangle2D.Double(50.0, 50.0, 90.0, 30.0));
        GraphConstants.setBorder((Map)map, (Border)BorderFactory.createRaisedBevelBorder());
        GraphConstants.setBackground((Map)map, (Color)c);
        GraphConstants.setForeground((Map)map, (Color)Color.white);
        GraphConstants.setFont((Map)map, (Font)GraphConstants.DEFAULTFONT.deriveFont(1, 12.0f));
        GraphConstants.setOpaque((Map)map, (boolean)true);
        return map;
    }

    public CellFactory<V, E> getCellFactory() {
        return this.cellFactory;
    }

    public void setDefaultEdgeAttributes(AttributeMap defaultEdgeAttributes) {
        this.defaultEdgeAttributes = defaultEdgeAttributes;
    }

    public AttributeMap getDefaultEdgeAttributes() {
        return this.defaultEdgeAttributes;
    }

    public void setDefaultVertexAttributes(AttributeMap defaultVertexAttributes) {
        this.defaultVertexAttributes = defaultVertexAttributes;
    }

    public AttributeMap getDefaultVertexAttributes() {
        return this.defaultVertexAttributes;
    }

    public DefaultEdge getEdgeCell(E jGraphTEdge) {
        return (DefaultEdge)this.edgeToCell.get(jGraphTEdge);
    }

    public DefaultGraphCell getVertexCell(Object jGraphTVertex) {
        return (DefaultGraphCell)this.vertexToCell.get(jGraphTVertex);
    }

    public DefaultPort getVertexPort(Object jGraphTVertex) {
        DefaultGraphCell vertexCell = this.getVertexCell(jGraphTVertex);
        if (vertexCell == null) {
            return null;
        }
        return (DefaultPort)vertexCell.getChildAt(0);
    }

    void handleJGraphChangedEdge(Edge jEdge) {
        if (this.isDangling(jEdge)) {
            if (this.cellToEdge.containsKey(jEdge)) {
                this.handleJGraphRemovedEdge(jEdge);
            }
        } else if (this.cellToEdge.containsKey(jEdge)) {
            E jtEdge = this.cellToEdge.get(jEdge);
            Object jSource = JGraphModelAdapter.getSourceVertex((GraphModel)this, (Object)jEdge);
            Object jTarget = JGraphModelAdapter.getTargetVertex((GraphModel)this, (Object)jEdge);
            V jtSource = this.cellToVertex.get(jSource);
            V jtTarget = this.cellToVertex.get(jTarget);
            if (this.jtGraph.getEdgeSource(jtEdge) != jtSource || this.jtGraph.getEdgeTarget(jtEdge) != jtTarget) {
                this.handleJGraphRemovedEdge(jEdge);
                this.handleJGraphInsertedEdge(jEdge);
            }
        } else {
            this.handleJGraphInsertedEdge(jEdge);
        }
    }

    void handleJGraphInsertedEdge(Edge jEdge) {
        if (!this.isDangling(jEdge)) {
            V jtTarget;
            Object jSource = JGraphModelAdapter.getSourceVertex((GraphModel)this, (Object)jEdge);
            Object jTarget = JGraphModelAdapter.getTargetVertex((GraphModel)this, (Object)jEdge);
            V jtSource = this.cellToVertex.get(jSource);
            Object jtEdge = this.jtGraph.addEdge(jtSource, jtTarget = this.cellToVertex.get(jTarget));
            if (jtEdge != null) {
                this.cellToEdge.put(jEdge, jtEdge);
                this.edgeToCell.put(jtEdge, jEdge);
            } else {
                this.internalRemoveCell((GraphCell)jEdge);
                System.err.println("Warning: an edge was deleted because the underlying JGraphT graph refused to create it. This situation can happen when a constraint of the underlying graph is violated, e.g., an attempt to add a parallel edge or a self-loop to a graph that forbids them. To avoid this message, make sure to use a suitable underlying JGraphT graph.");
            }
        }
    }

    void handleJGraphInsertedVertex(GraphCell jVertex) {
        Object jtVertex = jVertex instanceof DefaultGraphCell ? ((DefaultGraphCell)jVertex).getUserObject() : jVertex.toString();
        if (this.vertexToCell.containsKey(jtVertex)) {
            System.err.println("Warning: detected two JGraph vertices with the same JGraphT vertex as user object. It is an indication for a faulty situation that should NOT happen.Removing vertex: " + jVertex);
            this.internalRemoveCell(jVertex);
        } else {
            this.jtGraph.addVertex(jtVertex);
            this.cellToVertex.put(jVertex, jtVertex);
            this.vertexToCell.put((GraphCell)jtVertex, jVertex);
        }
    }

    void handleJGraphRemovedEdge(Edge jEdge) {
        if (this.cellToEdge.containsKey(jEdge)) {
            E jtEdge = this.cellToEdge.get(jEdge);
            this.jtGraph.removeEdge(jtEdge);
            this.cellToEdge.remove(jEdge);
            this.edgeToCell.remove(jtEdge);
        }
    }

    void handleJGraphRemovedVertex(GraphCell jVertex) {
        if (this.cellToVertex.containsKey(jVertex)) {
            V jtVertex = this.cellToVertex.get(jVertex);
            Set jtIncidentEdges = this.jtGraph.edgesOf(jtVertex);
            if (!jtIncidentEdges.isEmpty()) {
                this.jtGraph.removeAllEdges(new ArrayList(jtIncidentEdges));
            }
            this.jtGraph.removeVertex(jtVertex);
            this.cellToVertex.remove(jVertex);
            this.vertexToCell.remove(jtVertex);
        }
    }

    void handleJGraphTAddedEdge(E jtEdge) {
        DefaultEdge edgeCell = this.cellFactory.createEdgeCell(jtEdge);
        this.edgeToCell.put(jtEdge, (Edge)edgeCell);
        this.cellToEdge.put((Edge)edgeCell, jtEdge);
        ConnectionSet cs = new ConnectionSet();
        cs.connect((Object)edgeCell, (Object)this.getVertexPort(this.jtGraph.getEdgeSource(jtEdge)), (Object)this.getVertexPort(this.jtGraph.getEdgeTarget(jtEdge)));
        this.internalInsertCell((GraphCell)edgeCell, this.createEdgeAttributeMap(edgeCell), cs);
    }

    void handleJGraphTAddedVertex(V jtVertex) {
        DefaultGraphCell vertexCell = this.cellFactory.createVertexCell(jtVertex);
        vertexCell.add((MutableTreeNode)new DefaultPort());
        this.vertexToCell.put((GraphCell)jtVertex, (GraphCell)vertexCell);
        this.cellToVertex.put((GraphCell)vertexCell, jtVertex);
        this.internalInsertCell((GraphCell)vertexCell, this.createVertexAttributeMap((GraphCell)vertexCell), null);
    }

    void handleJGraphTRemoveVertex(Object jtVertex) {
        DefaultGraphCell vertexCell = (DefaultGraphCell)this.vertexToCell.remove(jtVertex);
        this.cellToVertex.remove(vertexCell);
        ArrayList ports = new ArrayList();
        for (Object child : vertexCell.getChildren()) {
            if (!this.isPort(child)) continue;
            ports.add(child);
        }
        this.remove(ports.toArray());
        this.internalRemoveCell((GraphCell)vertexCell);
    }

    void handleJGraphTRemovedEdge(E jtEdge) {
        DefaultEdge edgeCell = (DefaultEdge)this.edgeToCell.remove(jtEdge);
        this.cellToEdge.remove(edgeCell);
        this.internalRemoveCell((GraphCell)edgeCell);
    }

    private boolean isDangling(Edge jEdge) {
        Object jSource = JGraphModelAdapter.getSourceVertex((GraphModel)this, (Object)jEdge);
        Object jTarget = JGraphModelAdapter.getTargetVertex((GraphModel)this, (Object)jEdge);
        return !this.cellToVertex.containsKey(jSource) || !this.cellToVertex.containsKey(jTarget);
    }

    private AttributeMap createEdgeAttributeMap(DefaultEdge edgeCell) {
        AttributeMap attrs = new AttributeMap();
        attrs.put((Object)edgeCell, this.getDefaultEdgeAttributes().clone());
        return attrs;
    }

    private AttributeMap createVertexAttributeMap(GraphCell vertexCell) {
        AttributeMap attrs = new AttributeMap();
        attrs.put((Object)vertexCell, this.getDefaultVertexAttributes().clone());
        return attrs;
    }

    private void internalInsertCell(GraphCell cell, AttributeMap attrs, ConnectionSet cs) {
        this.jCellsBeingAdded.add(cell);
        this.insert(new Object[]{cell}, (Map)attrs, cs, null, null);
        this.jCellsBeingAdded.remove(cell);
    }

    private void internalRemoveCell(GraphCell cell) {
        this.jCellsBeingRemoved.add(cell);
        this.remove(new Object[]{cell});
        this.jCellsBeingRemoved.remove(cell);
    }

    private class ShieldedGraph {
        private final Graph<V, E> graph;

        ShieldedGraph(Graph<V, E> graph) {
            this.graph = graph;
        }

        E addEdge(V jtSource, V jtTarget) {
            Object jtEdge = this.graph.getEdgeFactory().createEdge(jtSource, jtTarget);
            JGraphModelAdapter.this.jtElementsBeingAdded.add(jtEdge);
            boolean added = this.graph.addEdge(jtSource, jtTarget, jtEdge);
            JGraphModelAdapter.this.jtElementsBeingAdded.remove(jtEdge);
            return added ? jtEdge : null;
        }

        V getEdgeSource(E e) {
            return this.graph.getEdgeSource(e);
        }

        V getEdgeTarget(E e) {
            return this.graph.getEdgeTarget(e);
        }

        void addVertex(V jtVertex) {
            JGraphModelAdapter.this.jtElementsBeingAdded.add(jtVertex);
            this.graph.addVertex(jtVertex);
            JGraphModelAdapter.this.jtElementsBeingAdded.remove(jtVertex);
        }

        Set<E> edgesOf(V vertex) {
            return this.graph.edgesOf(vertex);
        }

        boolean removeAllEdges(Collection<E> edges) {
            return this.graph.removeAllEdges(edges);
        }

        void removeEdge(E jtEdge) {
            JGraphModelAdapter.this.jtElementsBeingRemoved.add(jtEdge);
            this.graph.removeEdge(jtEdge);
            JGraphModelAdapter.this.jtElementsBeingRemoved.remove(jtEdge);
        }

        void removeVertex(V jtVertex) {
            JGraphModelAdapter.this.jtElementsBeingRemoved.add(jtVertex);
            this.graph.removeVertex(jtVertex);
            JGraphModelAdapter.this.jtElementsBeingRemoved.remove(jtVertex);
        }
    }

    private class JGraphTListener
    implements GraphListener<V, E>,
    Serializable {
        private static final long serialVersionUID = 3616724963609360440L;

        private JGraphTListener() {
        }

        @Override
        public void edgeAdded(GraphEdgeChangeEvent<V, E> e) {
            Object jtEdge = e.getEdge();
            if (!JGraphModelAdapter.this.jtElementsBeingAdded.remove(jtEdge)) {
                JGraphModelAdapter.this.handleJGraphTAddedEdge(jtEdge);
            }
        }

        @Override
        public void edgeRemoved(GraphEdgeChangeEvent<V, E> e) {
            Object jtEdge = e.getEdge();
            if (!JGraphModelAdapter.this.jtElementsBeingRemoved.remove(jtEdge)) {
                JGraphModelAdapter.this.handleJGraphTRemovedEdge(jtEdge);
            }
        }

        @Override
        public void vertexAdded(GraphVertexChangeEvent<V> e) {
            Object jtVertex = e.getVertex();
            if (!JGraphModelAdapter.this.jtElementsBeingAdded.remove(jtVertex)) {
                JGraphModelAdapter.this.handleJGraphTAddedVertex(jtVertex);
            }
        }

        @Override
        public void vertexRemoved(GraphVertexChangeEvent<V> e) {
            Object jtVertex = e.getVertex();
            if (!JGraphModelAdapter.this.jtElementsBeingRemoved.remove(jtVertex)) {
                JGraphModelAdapter.this.handleJGraphTRemoveVertex(jtVertex);
            }
        }
    }

    private class JGraphListener
    implements GraphModelListener,
    Serializable {
        private static final long serialVersionUID = 3544673988098865209L;

        private JGraphListener() {
        }

        public void graphChanged(GraphModelEvent e) {
            Object[] changedCells;
            Object[] insertedCells;
            GraphModelEvent.GraphModelChange change = e.getChange();
            Object[] removedCells = change.getRemoved();
            if (removedCells != null) {
                this.handleRemovedEdges(this.filterEdges(removedCells));
                this.handleRemovedVertices(this.filterVertices(removedCells));
            }
            if ((insertedCells = change.getInserted()) != null) {
                this.handleInsertedVertices(this.filterVertices(insertedCells));
                this.handleInsertedEdges(this.filterEdges(insertedCells));
            }
            if ((changedCells = change.getChanged()) != null) {
                this.handleChangedEdges(this.filterEdges(changedCells));
            }
        }

        private List<Object> filterEdges(Object[] cells) {
            ArrayList<Object> jEdges = new ArrayList<Object>();
            for (int i = 0; i < cells.length; ++i) {
                if (!(cells[i] instanceof Edge)) continue;
                jEdges.add(cells[i]);
            }
            return jEdges;
        }

        private List<Object> filterVertices(Object[] cells) {
            ArrayList<Object> jVertices = new ArrayList<Object>();
            for (int i = 0; i < cells.length; ++i) {
                Object cell = cells[i];
                if (cell instanceof Edge || cell instanceof Port) continue;
                if (cell instanceof DefaultGraphCell) {
                    DefaultGraphCell graphCell = (DefaultGraphCell)cell;
                    if (!graphCell.isLeaf() && !(graphCell.getFirstChild() instanceof Port)) continue;
                    jVertices.add(cell);
                    continue;
                }
                if (!(cell instanceof GraphCell)) continue;
                jVertices.add(cell);
            }
            return jVertices;
        }

        private void handleChangedEdges(List<Object> jEdges) {
            for (Edge edge : jEdges) {
                JGraphModelAdapter.this.handleJGraphChangedEdge(edge);
            }
        }

        private void handleInsertedEdges(List<Object> jEdges) {
            for (Edge edge : jEdges) {
                if (JGraphModelAdapter.this.jCellsBeingAdded.remove(edge)) continue;
                JGraphModelAdapter.this.handleJGraphInsertedEdge(edge);
            }
        }

        private void handleInsertedVertices(List<Object> jVertices) {
            for (GraphCell graphCell : jVertices) {
                if (JGraphModelAdapter.this.jCellsBeingAdded.remove(graphCell)) continue;
                JGraphModelAdapter.this.handleJGraphInsertedVertex(graphCell);
            }
        }

        private void handleRemovedEdges(List<Object> jEdges) {
            for (Edge edge : jEdges) {
                if (JGraphModelAdapter.this.jCellsBeingRemoved.remove(edge)) continue;
                JGraphModelAdapter.this.handleJGraphRemovedEdge(edge);
            }
        }

        private void handleRemovedVertices(List<Object> jVertices) {
            for (GraphCell graphCell : jVertices) {
                if (JGraphModelAdapter.this.jCellsBeingRemoved.remove(graphCell)) continue;
                JGraphModelAdapter.this.handleJGraphRemovedVertex(graphCell);
            }
        }
    }

    public static class DefaultCellFactory<VV, EE>
    implements CellFactory<VV, EE>,
    Serializable {
        private static final long serialVersionUID = 3690194343461861173L;

        @Override
        public DefaultEdge createEdgeCell(EE jGraphTEdge) {
            return new DefaultEdge(jGraphTEdge);
        }

        @Override
        public DefaultGraphCell createVertexCell(VV jGraphTVertex) {
            return new DefaultGraphCell(jGraphTVertex);
        }
    }

    public static interface CellFactory<VV, EE> {
        public DefaultEdge createEdgeCell(EE var1);

        public DefaultGraphCell createVertexCell(VV var1);
    }
}

