/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import java.io.Serializable;
import org.joda.convert.FromString;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeUtils;
import org.joda.time.MutableDateTime;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.joda.time.base.AbstractInstant;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.convert.ConverterManager;
import org.joda.time.convert.InstantConverter;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public final class Instant
extends AbstractInstant
implements ReadableInstant,
Serializable {
    private static final long serialVersionUID = 3299096530934209741L;
    private final long iMillis;

    public static Instant now() {
        return new Instant();
    }

    @FromString
    public static Instant parse(String str) {
        return Instant.parse(str, ISODateTimeFormat.dateTimeParser());
    }

    public static Instant parse(String str, DateTimeFormatter formatter) {
        return formatter.parseDateTime(str).toInstant();
    }

    public Instant() {
        this.iMillis = DateTimeUtils.currentTimeMillis();
    }

    public Instant(long instant) {
        this.iMillis = instant;
    }

    public Instant(Object instant) {
        InstantConverter converter = ConverterManager.getInstance().getInstantConverter(instant);
        this.iMillis = converter.getInstantMillis(instant, ISOChronology.getInstanceUTC());
    }

    @Override
    public Instant toInstant() {
        return this;
    }

    public Instant withMillis(long newMillis) {
        return newMillis == this.iMillis ? this : new Instant(newMillis);
    }

    public Instant withDurationAdded(long durationToAdd, int scalar) {
        if (durationToAdd == 0L || scalar == 0) {
            return this;
        }
        long instant = this.getChronology().add(this.getMillis(), durationToAdd, scalar);
        return this.withMillis(instant);
    }

    public Instant withDurationAdded(ReadableDuration durationToAdd, int scalar) {
        if (durationToAdd == null || scalar == 0) {
            return this;
        }
        return this.withDurationAdded(durationToAdd.getMillis(), scalar);
    }

    public Instant plus(long duration) {
        return this.withDurationAdded(duration, 1);
    }

    public Instant plus(ReadableDuration duration) {
        return this.withDurationAdded(duration, 1);
    }

    public Instant minus(long duration) {
        return this.withDurationAdded(duration, -1);
    }

    public Instant minus(ReadableDuration duration) {
        return this.withDurationAdded(duration, -1);
    }

    @Override
    public long getMillis() {
        return this.iMillis;
    }

    @Override
    public Chronology getChronology() {
        return ISOChronology.getInstanceUTC();
    }

    @Override
    public DateTime toDateTime() {
        return new DateTime(this.getMillis(), (Chronology)ISOChronology.getInstance());
    }

    @Override
    @Deprecated
    public DateTime toDateTimeISO() {
        return this.toDateTime();
    }

    @Override
    public MutableDateTime toMutableDateTime() {
        return new MutableDateTime(this.getMillis(), (Chronology)ISOChronology.getInstance());
    }

    @Override
    @Deprecated
    public MutableDateTime toMutableDateTimeISO() {
        return this.toMutableDateTime();
    }
}

