/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import org.joda.convert.FromString;
import org.joda.convert.ToString;
import org.joda.time.Chronology;
import org.joda.time.DateTimeUtils;
import org.joda.time.Days;
import org.joda.time.Duration;
import org.joda.time.DurationFieldType;
import org.joda.time.Hours;
import org.joda.time.LocalTime;
import org.joda.time.Period;
import org.joda.time.PeriodType;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.joda.time.ReadablePartial;
import org.joda.time.ReadablePeriod;
import org.joda.time.Seconds;
import org.joda.time.Weeks;
import org.joda.time.base.BaseSingleFieldPeriod;
import org.joda.time.field.FieldUtils;
import org.joda.time.format.ISOPeriodFormat;
import org.joda.time.format.PeriodFormatter;

public final class Minutes
extends BaseSingleFieldPeriod {
    public static final Minutes ZERO = new Minutes(0);
    public static final Minutes ONE = new Minutes(1);
    public static final Minutes TWO = new Minutes(2);
    public static final Minutes THREE = new Minutes(3);
    public static final Minutes MAX_VALUE = new Minutes(Integer.MAX_VALUE);
    public static final Minutes MIN_VALUE = new Minutes(Integer.MIN_VALUE);
    private static final PeriodFormatter PARSER = ISOPeriodFormat.standard().withParseType(PeriodType.minutes());
    private static final long serialVersionUID = 87525275727380863L;

    public static Minutes minutes(int minutes) {
        switch (minutes) {
            case 0: {
                return ZERO;
            }
            case 1: {
                return ONE;
            }
            case 2: {
                return TWO;
            }
            case 3: {
                return THREE;
            }
            case 0x7FFFFFFF: {
                return MAX_VALUE;
            }
            case -2147483648: {
                return MIN_VALUE;
            }
        }
        return new Minutes(minutes);
    }

    public static Minutes minutesBetween(ReadableInstant start, ReadableInstant end) {
        int amount = BaseSingleFieldPeriod.between(start, end, DurationFieldType.minutes());
        return Minutes.minutes(amount);
    }

    public static Minutes minutesBetween(ReadablePartial start, ReadablePartial end) {
        if (start instanceof LocalTime && end instanceof LocalTime) {
            Chronology chrono = DateTimeUtils.getChronology(start.getChronology());
            int minutes = chrono.minutes().getDifference(((LocalTime)end).getLocalMillis(), ((LocalTime)start).getLocalMillis());
            return Minutes.minutes(minutes);
        }
        int amount = BaseSingleFieldPeriod.between(start, end, ZERO);
        return Minutes.minutes(amount);
    }

    public static Minutes minutesIn(ReadableInterval interval) {
        if (interval == null) {
            return ZERO;
        }
        int amount = BaseSingleFieldPeriod.between(interval.getStart(), interval.getEnd(), DurationFieldType.minutes());
        return Minutes.minutes(amount);
    }

    public static Minutes standardMinutesIn(ReadablePeriod period) {
        int amount = BaseSingleFieldPeriod.standardPeriodIn(period, 60000L);
        return Minutes.minutes(amount);
    }

    @FromString
    public static Minutes parseMinutes(String periodStr) {
        if (periodStr == null) {
            return ZERO;
        }
        Period p = PARSER.parsePeriod(periodStr);
        return Minutes.minutes(p.getMinutes());
    }

    private Minutes(int minutes) {
        super(minutes);
    }

    private Object readResolve() {
        return Minutes.minutes(this.getValue());
    }

    @Override
    public DurationFieldType getFieldType() {
        return DurationFieldType.minutes();
    }

    @Override
    public PeriodType getPeriodType() {
        return PeriodType.minutes();
    }

    public Weeks toStandardWeeks() {
        return Weeks.weeks(this.getValue() / 10080);
    }

    public Days toStandardDays() {
        return Days.days(this.getValue() / 1440);
    }

    public Hours toStandardHours() {
        return Hours.hours(this.getValue() / 60);
    }

    public Seconds toStandardSeconds() {
        return Seconds.seconds(FieldUtils.safeMultiply(this.getValue(), 60));
    }

    public Duration toStandardDuration() {
        long minutes = this.getValue();
        return new Duration(minutes * 60000L);
    }

    public int getMinutes() {
        return this.getValue();
    }

    public Minutes plus(int minutes) {
        if (minutes == 0) {
            return this;
        }
        return Minutes.minutes(FieldUtils.safeAdd(this.getValue(), minutes));
    }

    public Minutes plus(Minutes minutes) {
        if (minutes == null) {
            return this;
        }
        return this.plus(minutes.getValue());
    }

    public Minutes minus(int minutes) {
        return this.plus(FieldUtils.safeNegate(minutes));
    }

    public Minutes minus(Minutes minutes) {
        if (minutes == null) {
            return this;
        }
        return this.minus(minutes.getValue());
    }

    public Minutes multipliedBy(int scalar) {
        return Minutes.minutes(FieldUtils.safeMultiply(this.getValue(), scalar));
    }

    public Minutes dividedBy(int divisor) {
        if (divisor == 1) {
            return this;
        }
        return Minutes.minutes(this.getValue() / divisor);
    }

    public Minutes negated() {
        return Minutes.minutes(FieldUtils.safeNegate(this.getValue()));
    }

    public boolean isGreaterThan(Minutes other) {
        if (other == null) {
            return this.getValue() > 0;
        }
        return this.getValue() > other.getValue();
    }

    public boolean isLessThan(Minutes other) {
        if (other == null) {
            return this.getValue() < 0;
        }
        return this.getValue() < other.getValue();
    }

    @Override
    @ToString
    public String toString() {
        String string = String.valueOf(this.getValue());
        return new StringBuilder(3 + String.valueOf(string).length()).append("PT").append(string).append("M").toString();
    }
}

