/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import java.util.Locale;
import org.joda.time.Chronology;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeZone;
import org.joda.time.DurationField;
import org.joda.time.DurationFieldType;
import org.joda.time.chrono.AssembledChronology;
import org.joda.time.chrono.BasicDayOfMonthDateTimeField;
import org.joda.time.chrono.BasicDayOfYearDateTimeField;
import org.joda.time.chrono.BasicWeekOfWeekyearDateTimeField;
import org.joda.time.chrono.BasicWeekyearDateTimeField;
import org.joda.time.chrono.BasicYearDateTimeField;
import org.joda.time.chrono.GJDayOfWeekDateTimeField;
import org.joda.time.chrono.GJEraDateTimeField;
import org.joda.time.chrono.GJLocaleSymbols;
import org.joda.time.chrono.GJMonthOfYearDateTimeField;
import org.joda.time.chrono.GJYearOfEraDateTimeField;
import org.joda.time.field.DecoratedDateTimeField;
import org.joda.time.field.DividedDateTimeField;
import org.joda.time.field.FieldUtils;
import org.joda.time.field.MillisDurationField;
import org.joda.time.field.OffsetDateTimeField;
import org.joda.time.field.PreciseDateTimeField;
import org.joda.time.field.PreciseDurationField;
import org.joda.time.field.RemainderDateTimeField;
import org.joda.time.field.ZeroIsMaxDateTimeField;

abstract class BasicChronology
extends AssembledChronology {
    private static final long serialVersionUID = 8283225332206808863L;
    private static final DurationField cMillisField = MillisDurationField.INSTANCE;
    private static final DurationField cSecondsField = new PreciseDurationField(DurationFieldType.seconds(), 1000L);
    private static final DurationField cMinutesField = new PreciseDurationField(DurationFieldType.minutes(), 60000L);
    private static final DurationField cHoursField = new PreciseDurationField(DurationFieldType.hours(), 3600000L);
    private static final DurationField cHalfdaysField = new PreciseDurationField(DurationFieldType.halfdays(), 43200000L);
    private static final DurationField cDaysField = new PreciseDurationField(DurationFieldType.days(), 86400000L);
    private static final DurationField cWeeksField = new PreciseDurationField(DurationFieldType.weeks(), 604800000L);
    private static final DateTimeField cMillisOfSecondField = new PreciseDateTimeField(DateTimeFieldType.millisOfSecond(), cMillisField, cSecondsField);
    private static final DateTimeField cMillisOfDayField = new PreciseDateTimeField(DateTimeFieldType.millisOfDay(), cMillisField, cDaysField);
    private static final DateTimeField cSecondOfMinuteField = new PreciseDateTimeField(DateTimeFieldType.secondOfMinute(), cSecondsField, cMinutesField);
    private static final DateTimeField cSecondOfDayField = new PreciseDateTimeField(DateTimeFieldType.secondOfDay(), cSecondsField, cDaysField);
    private static final DateTimeField cMinuteOfHourField = new PreciseDateTimeField(DateTimeFieldType.minuteOfHour(), cMinutesField, cHoursField);
    private static final DateTimeField cMinuteOfDayField = new PreciseDateTimeField(DateTimeFieldType.minuteOfDay(), cMinutesField, cDaysField);
    private static final DateTimeField cHourOfDayField = new PreciseDateTimeField(DateTimeFieldType.hourOfDay(), cHoursField, cDaysField);
    private static final DateTimeField cHourOfHalfdayField = new PreciseDateTimeField(DateTimeFieldType.hourOfHalfday(), cHoursField, cHalfdaysField);
    private static final DateTimeField cClockhourOfDayField = new ZeroIsMaxDateTimeField(cHourOfDayField, DateTimeFieldType.clockhourOfDay());
    private static final DateTimeField cClockhourOfHalfdayField = new ZeroIsMaxDateTimeField(cHourOfHalfdayField, DateTimeFieldType.clockhourOfHalfday());
    private static final DateTimeField cHalfdayOfDayField = new HalfdayField();
    private static final int CACHE_SIZE = 1024;
    private static final int CACHE_MASK = 1023;
    private final transient YearInfo[] iYearInfoCache = new YearInfo[1024];
    private final int iMinDaysInFirstWeek;

    BasicChronology(Chronology base, Object param, int minDaysInFirstWeek) {
        super(base, param);
        if (minDaysInFirstWeek < 1 || minDaysInFirstWeek > 7) {
            throw new IllegalArgumentException(new StringBuilder(43).append("Invalid min days in first week: ").append(minDaysInFirstWeek).toString());
        }
        this.iMinDaysInFirstWeek = minDaysInFirstWeek;
    }

    @Override
    public DateTimeZone getZone() {
        Chronology base = this.getBase();
        if (base != null) {
            return base.getZone();
        }
        return DateTimeZone.UTC;
    }

    @Override
    public long getDateTimeMillis(int year, int monthOfYear, int dayOfMonth, int millisOfDay) throws IllegalArgumentException {
        Chronology base = this.getBase();
        if (base != null) {
            return base.getDateTimeMillis(year, monthOfYear, dayOfMonth, millisOfDay);
        }
        FieldUtils.verifyValueBounds(DateTimeFieldType.millisOfDay(), millisOfDay, 0, 86399999);
        return this.getDateMidnightMillis(year, monthOfYear, dayOfMonth) + (long)millisOfDay;
    }

    @Override
    public long getDateTimeMillis(int year, int monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour, int secondOfMinute, int millisOfSecond) throws IllegalArgumentException {
        Chronology base = this.getBase();
        if (base != null) {
            return base.getDateTimeMillis(year, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour, secondOfMinute, millisOfSecond);
        }
        FieldUtils.verifyValueBounds(DateTimeFieldType.hourOfDay(), hourOfDay, 0, 23);
        FieldUtils.verifyValueBounds(DateTimeFieldType.minuteOfHour(), minuteOfHour, 0, 59);
        FieldUtils.verifyValueBounds(DateTimeFieldType.secondOfMinute(), secondOfMinute, 0, 59);
        FieldUtils.verifyValueBounds(DateTimeFieldType.millisOfSecond(), millisOfSecond, 0, 999);
        return this.getDateMidnightMillis(year, monthOfYear, dayOfMonth) + (long)(hourOfDay * 3600000) + (long)(minuteOfHour * 60000) + (long)(secondOfMinute * 1000) + (long)millisOfSecond;
    }

    public int getMinimumDaysInFirstWeek() {
        return this.iMinDaysInFirstWeek;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && this.getClass() == obj.getClass()) {
            BasicChronology chrono = (BasicChronology)obj;
            return this.getMinimumDaysInFirstWeek() == chrono.getMinimumDaysInFirstWeek() && this.getZone().equals(chrono.getZone());
        }
        return false;
    }

    public int hashCode() {
        return this.getClass().getName().hashCode() * 11 + this.getZone().hashCode() + this.getMinimumDaysInFirstWeek();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(60);
        String name = this.getClass().getName();
        int index = name.lastIndexOf(46);
        if (index >= 0) {
            name = name.substring(index + 1);
        }
        sb.append(name);
        sb.append('[');
        DateTimeZone zone = this.getZone();
        if (zone != null) {
            sb.append(zone.getID());
        }
        if (this.getMinimumDaysInFirstWeek() != 4) {
            sb.append(",mdfw=");
            sb.append(this.getMinimumDaysInFirstWeek());
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    protected void assemble(AssembledChronology.Fields fields) {
        fields.millis = cMillisField;
        fields.seconds = cSecondsField;
        fields.minutes = cMinutesField;
        fields.hours = cHoursField;
        fields.halfdays = cHalfdaysField;
        fields.days = cDaysField;
        fields.weeks = cWeeksField;
        fields.millisOfSecond = cMillisOfSecondField;
        fields.millisOfDay = cMillisOfDayField;
        fields.secondOfMinute = cSecondOfMinuteField;
        fields.secondOfDay = cSecondOfDayField;
        fields.minuteOfHour = cMinuteOfHourField;
        fields.minuteOfDay = cMinuteOfDayField;
        fields.hourOfDay = cHourOfDayField;
        fields.hourOfHalfday = cHourOfHalfdayField;
        fields.clockhourOfDay = cClockhourOfDayField;
        fields.clockhourOfHalfday = cClockhourOfHalfdayField;
        fields.halfdayOfDay = cHalfdayOfDayField;
        fields.year = new BasicYearDateTimeField(this);
        fields.yearOfEra = new GJYearOfEraDateTimeField(fields.year, this);
        DecoratedDateTimeField field = new OffsetDateTimeField(fields.yearOfEra, 99);
        fields.centuryOfEra = new DividedDateTimeField(field, DateTimeFieldType.centuryOfEra(), 100);
        field = new RemainderDateTimeField((DividedDateTimeField)fields.centuryOfEra);
        fields.yearOfCentury = new OffsetDateTimeField(field, DateTimeFieldType.yearOfCentury(), 1);
        fields.era = new GJEraDateTimeField(this);
        fields.dayOfWeek = new GJDayOfWeekDateTimeField(this, fields.days);
        fields.dayOfMonth = new BasicDayOfMonthDateTimeField(this, fields.days);
        fields.dayOfYear = new BasicDayOfYearDateTimeField(this, fields.days);
        fields.monthOfYear = new GJMonthOfYearDateTimeField(this);
        fields.weekyear = new BasicWeekyearDateTimeField(this);
        fields.weekOfWeekyear = new BasicWeekOfWeekyearDateTimeField(this, fields.weeks);
        field = new RemainderDateTimeField(fields.weekyear, DateTimeFieldType.weekyearOfCentury(), 100);
        fields.weekyearOfCentury = new OffsetDateTimeField(field, DateTimeFieldType.weekyearOfCentury(), 1);
        fields.years = fields.year.getDurationField();
        fields.centuries = fields.centuryOfEra.getDurationField();
        fields.months = fields.monthOfYear.getDurationField();
        fields.weekyears = fields.weekyear.getDurationField();
    }

    int getDaysInYearMax() {
        return 366;
    }

    int getDaysInYear(int year) {
        return this.isLeapYear(year) ? 366 : 365;
    }

    int getWeeksInYear(int year) {
        long firstWeekMillis1 = this.getFirstWeekOfYearMillis(year);
        long firstWeekMillis2 = this.getFirstWeekOfYearMillis(year + 1);
        return (int)((firstWeekMillis2 - firstWeekMillis1) / 604800000L);
    }

    long getFirstWeekOfYearMillis(int year) {
        long jan1millis = this.getYearMillis(year);
        int jan1dayOfWeek = this.getDayOfWeek(jan1millis);
        if (jan1dayOfWeek > 8 - this.iMinDaysInFirstWeek) {
            return jan1millis + (long)(8 - jan1dayOfWeek) * 86400000L;
        }
        return jan1millis - (long)(jan1dayOfWeek - 1) * 86400000L;
    }

    long getYearMillis(int year) {
        return this.getYearInfo((int)year).iFirstDayMillis;
    }

    long getYearMonthMillis(int year, int month) {
        long millis = this.getYearMillis(year);
        return millis += this.getTotalMillisByYearMonth(year, month);
    }

    long getYearMonthDayMillis(int year, int month, int dayOfMonth) {
        long millis = this.getYearMillis(year);
        return (millis += this.getTotalMillisByYearMonth(year, month)) + (long)(dayOfMonth - 1) * 86400000L;
    }

    int getYear(long instant) {
        long oneYear;
        int year;
        long yearStart;
        long diff;
        long unitMillis = this.getAverageMillisPerYearDividedByTwo();
        long i2 = (instant >> 1) + this.getApproxMillisAtEpochDividedByTwo();
        if (i2 < 0L) {
            i2 = i2 - unitMillis + 1L;
        }
        if ((diff = instant - (yearStart = this.getYearMillis(year = (int)(i2 / unitMillis)))) < 0L) {
            --year;
        } else if (diff >= 31536000000L && (yearStart += (oneYear = this.isLeapYear(year) ? 31622400000L : 31536000000L)) <= instant) {
            ++year;
        }
        return year;
    }

    int getMonthOfYear(long millis) {
        return this.getMonthOfYear(millis, this.getYear(millis));
    }

    abstract int getMonthOfYear(long var1, int var3);

    int getDayOfMonth(long millis) {
        int year = this.getYear(millis);
        int month = this.getMonthOfYear(millis, year);
        return this.getDayOfMonth(millis, year, month);
    }

    int getDayOfMonth(long millis, int year) {
        int month = this.getMonthOfYear(millis, year);
        return this.getDayOfMonth(millis, year, month);
    }

    int getDayOfMonth(long millis, int year, int month) {
        long dateMillis = this.getYearMillis(year);
        return (int)((millis - (dateMillis += this.getTotalMillisByYearMonth(year, month))) / 86400000L) + 1;
    }

    int getDayOfYear(long instant) {
        return this.getDayOfYear(instant, this.getYear(instant));
    }

    int getDayOfYear(long instant, int year) {
        long yearStart = this.getYearMillis(year);
        return (int)((instant - yearStart) / 86400000L) + 1;
    }

    int getWeekyear(long instant) {
        int year = this.getYear(instant);
        int week = this.getWeekOfWeekyear(instant, year);
        if (week == 1) {
            return this.getYear(instant + 604800000L);
        }
        if (week > 51) {
            return this.getYear(instant - 1209600000L);
        }
        return year;
    }

    int getWeekOfWeekyear(long instant) {
        return this.getWeekOfWeekyear(instant, this.getYear(instant));
    }

    int getWeekOfWeekyear(long instant, int year) {
        long firstWeekMillis1 = this.getFirstWeekOfYearMillis(year);
        if (instant < firstWeekMillis1) {
            return this.getWeeksInYear(year - 1);
        }
        long firstWeekMillis2 = this.getFirstWeekOfYearMillis(year + 1);
        if (instant >= firstWeekMillis2) {
            return 1;
        }
        return (int)((instant - firstWeekMillis1) / 604800000L) + 1;
    }

    int getDayOfWeek(long instant) {
        long daysSince19700101;
        if (instant >= 0L) {
            daysSince19700101 = instant / 86400000L;
        } else {
            daysSince19700101 = (instant - 86399999L) / 86400000L;
            if (daysSince19700101 < -3L) {
                return 7 + (int)((daysSince19700101 + 4L) % 7L);
            }
        }
        return 1 + (int)((daysSince19700101 + 3L) % 7L);
    }

    int getMillisOfDay(long instant) {
        if (instant >= 0L) {
            return (int)(instant % 86400000L);
        }
        return 86399999 + (int)((instant + 1L) % 86400000L);
    }

    int getDaysInMonthMax() {
        return 31;
    }

    int getDaysInMonthMax(long instant) {
        int thisYear = this.getYear(instant);
        int thisMonth = this.getMonthOfYear(instant, thisYear);
        return this.getDaysInYearMonth(thisYear, thisMonth);
    }

    int getDaysInMonthMaxForSet(long instant, int value) {
        return this.getDaysInMonthMax(instant);
    }

    long getDateMidnightMillis(int year, int monthOfYear, int dayOfMonth) {
        FieldUtils.verifyValueBounds(DateTimeFieldType.year(), year, this.getMinYear(), this.getMaxYear());
        FieldUtils.verifyValueBounds(DateTimeFieldType.monthOfYear(), monthOfYear, 1, this.getMaxMonth(year));
        FieldUtils.verifyValueBounds(DateTimeFieldType.dayOfMonth(), dayOfMonth, 1, this.getDaysInYearMonth(year, monthOfYear));
        return this.getYearMonthDayMillis(year, monthOfYear, dayOfMonth);
    }

    abstract long getYearDifference(long var1, long var3);

    abstract boolean isLeapYear(int var1);

    abstract int getDaysInYearMonth(int var1, int var2);

    abstract int getDaysInMonthMax(int var1);

    abstract long getTotalMillisByYearMonth(int var1, int var2);

    abstract long calculateFirstDayOfYearMillis(int var1);

    abstract int getMinYear();

    abstract int getMaxYear();

    int getMaxMonth(int year) {
        return this.getMaxMonth();
    }

    int getMaxMonth() {
        return 12;
    }

    abstract long getAverageMillisPerYear();

    abstract long getAverageMillisPerYearDividedByTwo();

    abstract long getAverageMillisPerMonth();

    abstract long getApproxMillisAtEpochDividedByTwo();

    abstract long setYear(long var1, int var3);

    private YearInfo getYearInfo(int year) {
        YearInfo info = this.iYearInfoCache[year & 0x3FF];
        if (info == null || info.iYear != year) {
            this.iYearInfoCache[year & 0x3FF] = info = new YearInfo(year, this.calculateFirstDayOfYearMillis(year));
        }
        return info;
    }

    private static class YearInfo {
        public final int iYear;
        public final long iFirstDayMillis;

        YearInfo(int year, long firstDayMillis) {
            this.iYear = year;
            this.iFirstDayMillis = firstDayMillis;
        }
    }

    private static class HalfdayField
    extends PreciseDateTimeField {
        private static final long serialVersionUID = 581601443656929254L;

        HalfdayField() {
            super(DateTimeFieldType.halfdayOfDay(), cHalfdaysField, cDaysField);
        }

        @Override
        public String getAsText(int fieldValue, Locale locale) {
            return GJLocaleSymbols.forLocale(locale).halfdayValueToText(fieldValue);
        }

        @Override
        public long set(long millis, String text, Locale locale) {
            return this.set(millis, GJLocaleSymbols.forLocale(locale).halfdayTextToValue(text));
        }

        @Override
        public int getMaximumTextLength(Locale locale) {
            return GJLocaleSymbols.forLocale(locale).getHalfdayMaxTextLength();
        }
    }
}

