/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.convert;

import org.joda.time.Chronology;
import org.joda.time.DateTimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.PeriodType;
import org.joda.time.ReadablePartial;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.convert.Converter;
import org.joda.time.format.DateTimeFormatter;

public abstract class AbstractConverter
implements Converter {
    protected AbstractConverter() {
    }

    public long getInstantMillis(Object object, Chronology chrono) {
        return DateTimeUtils.currentTimeMillis();
    }

    public Chronology getChronology(Object object, DateTimeZone zone) {
        return ISOChronology.getInstance(zone);
    }

    public Chronology getChronology(Object object, Chronology chrono) {
        return DateTimeUtils.getChronology(chrono);
    }

    public int[] getPartialValues(ReadablePartial fieldSource, Object object, Chronology chrono) {
        long instant = this.getInstantMillis(object, chrono);
        return chrono.get(fieldSource, instant);
    }

    public int[] getPartialValues(ReadablePartial fieldSource, Object object, Chronology chrono, DateTimeFormatter parser) {
        return this.getPartialValues(fieldSource, object, chrono);
    }

    public PeriodType getPeriodType(Object object) {
        return PeriodType.standard();
    }

    public boolean isReadableInterval(Object object, Chronology chrono) {
        return false;
    }

    public String toString() {
        String string = this.getSupportedType() == null ? "null" : this.getSupportedType().getName();
        return new StringBuilder(11 + String.valueOf(string).length()).append("Converter[").append(string).append("]").toString();
    }
}

