/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.field;

import java.io.Serializable;
import org.joda.time.DurationField;
import org.joda.time.DurationFieldType;
import org.joda.time.field.FieldUtils;

public final class MillisDurationField
extends DurationField
implements Serializable {
    private static final long serialVersionUID = 2656707858124633367L;
    public static final DurationField INSTANCE = new MillisDurationField();

    private MillisDurationField() {
    }

    @Override
    public DurationFieldType getType() {
        return DurationFieldType.millis();
    }

    @Override
    public String getName() {
        return "millis";
    }

    @Override
    public boolean isSupported() {
        return true;
    }

    @Override
    public final boolean isPrecise() {
        return true;
    }

    @Override
    public final long getUnitMillis() {
        return 1L;
    }

    @Override
    public int getValue(long duration) {
        return FieldUtils.safeToInt(duration);
    }

    @Override
    public long getValueAsLong(long duration) {
        return duration;
    }

    @Override
    public int getValue(long duration, long instant) {
        return FieldUtils.safeToInt(duration);
    }

    @Override
    public long getValueAsLong(long duration, long instant) {
        return duration;
    }

    @Override
    public long getMillis(int value) {
        return value;
    }

    @Override
    public long getMillis(long value) {
        return value;
    }

    @Override
    public long getMillis(int value, long instant) {
        return value;
    }

    @Override
    public long getMillis(long value, long instant) {
        return value;
    }

    @Override
    public long add(long instant, int value) {
        return FieldUtils.safeAdd(instant, (long)value);
    }

    @Override
    public long add(long instant, long value) {
        return FieldUtils.safeAdd(instant, value);
    }

    @Override
    public int getDifference(long minuendInstant, long subtrahendInstant) {
        return FieldUtils.safeToInt(FieldUtils.safeSubtract(minuendInstant, subtrahendInstant));
    }

    @Override
    public long getDifferenceAsLong(long minuendInstant, long subtrahendInstant) {
        return FieldUtils.safeSubtract(minuendInstant, subtrahendInstant);
    }

    @Override
    public int compareTo(DurationField otherField) {
        long otherMillis = otherField.getUnitMillis();
        long thisMillis = this.getUnitMillis();
        if (thisMillis == otherMillis) {
            return 0;
        }
        if (thisMillis < otherMillis) {
            return -1;
        }
        return 1;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MillisDurationField) {
            return this.getUnitMillis() == ((MillisDurationField)obj).getUnitMillis();
        }
        return false;
    }

    public int hashCode() {
        return (int)this.getUnitMillis();
    }

    @Override
    public String toString() {
        return "DurationField[millis]";
    }

    private Object readResolve() {
        return INSTANCE;
    }
}

