/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.tools.expr.parser;

import com.google.api.expr.Expr;
import com.google.api.tools.expr.parser.CELParser;
import com.google.api.tools.expr.parser.ParserHelpers;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.Token;

public class AntlrExprVisitor {
    protected final ParserHelpers helpers;

    public AntlrExprVisitor(ParserHelpers helpers) {
        this.helpers = helpers;
    }

    public Expr visit(CELParser.ExprContext ctx) {
        if (ctx == null) {
            return ParserHelpers.ERROR;
        }
        Expr result = this.visit(ctx.e);
        if (ctx.op == null) {
            return result;
        }
        long opId = this.newId(ctx.op);
        Expr ifTrue = this.visit(ctx.e1);
        Expr ifFalse = this.visit(ctx.e2);
        return this.helpers.makeCall(opId, "_?_:_", result, ifTrue, ifFalse);
    }

    private Expr visit(CELParser.ConditionalOrContext ctx) {
        Expr result = this.visit(ctx.e);
        if (ctx.ops == null) {
            return result;
        }
        BalancedOperatorBuilder builder = new BalancedOperatorBuilder("_||_", result, this.helpers);
        for (int i = 0; i < ctx.ops.size(); ++i) {
            builder.addTerm(this.newId(ctx.ops.get(i)), this.visit(ctx.e1.get(i)));
        }
        return builder.build();
    }

    private Expr visit(CELParser.ConditionalAndContext ctx) {
        Expr result = this.visit(ctx.e);
        if (ctx.ops == null) {
            return result;
        }
        BalancedOperatorBuilder builder = new BalancedOperatorBuilder("_&&_", result, this.helpers);
        for (int i = 0; i < ctx.ops.size(); ++i) {
            builder.addTerm(this.newId(ctx.ops.get(i)), this.visit(ctx.e1.get(i)));
        }
        return builder.build();
    }

    private Expr visit(CELParser.RelationContext ctx) {
        String opText;
        if (ctx.calc() != null) {
            return this.visit(ctx.calc());
        }
        String string = opText = ctx.op != null ? ctx.op.getText() : "";
        if (this.helpers.isBinaryOperator(opText)) {
            Expr lhs = this.visit(ctx.relation(0));
            long opId = this.newId(ctx.op);
            Expr rhs = this.visit(ctx.relation(1));
            return this.helpers.makeCall(opId, opText, lhs, rhs);
        }
        return ParserHelpers.ERROR;
    }

    private Expr visit(CELParser.CalcContext ctx) {
        String opText;
        if (ctx.unary() != null) {
            return this.visit(ctx.unary());
        }
        String string = opText = ctx.op != null ? ctx.op.getText() : "";
        if (this.helpers.isBinaryOperator(opText)) {
            Expr lhs = this.visit(ctx.calc(0));
            long opId = this.newId(ctx.op);
            Expr rhs = this.visit(ctx.calc(1));
            return this.helpers.makeCall(opId, opText, lhs, rhs);
        }
        return ParserHelpers.ERROR;
    }

    private Expr visit(CELParser.UnaryContext ctx) {
        if (ctx instanceof CELParser.MemberExprContext) {
            return this.visit(((CELParser.MemberExprContext)ctx).member());
        }
        if (ctx instanceof CELParser.NegateContext) {
            CELParser.NegateContext neg = (CELParser.NegateContext)ctx;
            int negationCount = neg.ops.size();
            if (negationCount % 2 == 0) {
                return this.visit(neg.member());
            }
            long opId = this.newId(neg.ops.get(0));
            Expr target = this.visit(neg.member());
            return this.helpers.makeCall(opId, "-_", target);
        }
        if (ctx instanceof CELParser.LogicalNotContext) {
            CELParser.LogicalNotContext not = (CELParser.LogicalNotContext)ctx;
            int notCount = not.ops.size();
            if (notCount % 2 == 0) {
                return this.visit(not.member());
            }
            long opId = this.newId(not.ops.get(0));
            Expr target = this.visit(not.member());
            return this.helpers.makeCall(opId, "!_", target);
        }
        return ParserHelpers.ERROR;
    }

    private Expr visit(CELParser.MemberContext ctx) {
        if (ctx instanceof CELParser.PrimaryExprContext) {
            return this.visit(((CELParser.PrimaryExprContext)ctx).primary());
        }
        if (ctx instanceof CELParser.SelectOrCallContext) {
            return this.visit((CELParser.SelectOrCallContext)ctx);
        }
        if (ctx instanceof CELParser.IndexContext) {
            return this.visit((CELParser.IndexContext)ctx);
        }
        if (ctx instanceof CELParser.CreateMessageContext) {
            return this.visit((CELParser.CreateMessageContext)ctx);
        }
        return ParserHelpers.ERROR;
    }

    private Expr visit(CELParser.PrimaryContext ctx) {
        if (ctx instanceof CELParser.NestedContext) {
            return this.visit(((CELParser.NestedContext)ctx).e);
        }
        if (ctx instanceof CELParser.IdentOrGlobalCallContext) {
            return this.visit((CELParser.IdentOrGlobalCallContext)ctx);
        }
        if (ctx instanceof CELParser.CreateListContext) {
            return this.visit((CELParser.CreateListContext)ctx);
        }
        if (ctx instanceof CELParser.CreateStructContext) {
            return this.visit((CELParser.CreateStructContext)ctx);
        }
        if (ctx instanceof CELParser.ConstantLiteralContext) {
            return this.visit((CELParser.ConstantLiteralContext)ctx);
        }
        return ParserHelpers.ERROR;
    }

    private Expr visit(CELParser.SelectOrCallContext ctx) {
        Expr target = this.visit(ctx.member());
        String id = ctx.id.getText();
        if (ctx.open != null) {
            return this.helpers.makeCall(this.newId(ctx.op), target, id, this.visit(ctx.args));
        }
        return this.helpers.makeSelect(this.newId(ctx.op), target, id, false);
    }

    private Expr visit(CELParser.IndexContext ctx) {
        Expr operand = this.visit(ctx.member());
        return this.helpers.makeCall(this.newId(ctx.op), "_[_]", operand, this.visit(ctx.index));
    }

    private Expr visit(CELParser.CreateMessageContext ctx) {
        Expr target = this.visit(ctx.member());
        long nodeId = this.newId(ctx.op);
        String messageName = this.helpers.extractQualifiedName(nodeId, target);
        List<Expr.CreateStruct.Entry> entries = this.visit(ctx.entries);
        return this.helpers.newExpr(nodeId).setStructExpr(Expr.CreateStruct.newBuilder().setMessageName(messageName).addAllEntries(entries)).build();
    }

    private Expr visit(CELParser.IdentOrGlobalCallContext ctx) {
        String identName;
        String string = String.valueOf(ctx.leadingDot != null ? "." : "");
        String string2 = String.valueOf(ctx.id.getText());
        String string3 = identName = string2.length() != 0 ? string.concat(string2) : new String(string);
        if (ctx.op != null) {
            return this.helpers.makeCall(this.newId(ctx.op), null, identName, this.visit(ctx.args));
        }
        return this.helpers.newExpr(this.newId(ctx.id)).setIdentExpr(Expr.Ident.newBuilder().setName(identName)).build();
    }

    private Expr visit(CELParser.CreateListContext ctx) {
        long opId = this.newId(ctx.op);
        List<Expr> elems = this.visit(ctx.elems);
        return this.helpers.newExpr(opId).setListExpr(Expr.CreateList.newBuilder().addAllElements(elems)).build();
    }

    private Expr visit(CELParser.CreateStructContext ctx) {
        long opId = this.newId(ctx.op);
        List<Expr.CreateStruct.Entry> entries = this.visit(ctx.entries);
        return this.helpers.newExpr(opId).setStructExpr(Expr.CreateStruct.newBuilder().addAllEntries(entries)).build();
    }

    private Expr visit(CELParser.ConstantLiteralContext ctx) {
        CELParser.LiteralContext lit = ctx.literal();
        if (lit instanceof CELParser.IntContext) {
            CELParser.IntContext intCtx = (CELParser.IntContext)lit;
            return this.helpers.getSignedValue(intCtx.sign, intCtx.tok);
        }
        if (lit instanceof CELParser.UintContext) {
            return this.helpers.getUnsignedValue(((CELParser.UintContext)lit).tok);
        }
        if (lit instanceof CELParser.DoubleContext) {
            CELParser.DoubleContext doubleCtx = (CELParser.DoubleContext)lit;
            return this.helpers.getDoubleValue(doubleCtx.sign, doubleCtx.tok);
        }
        if (lit instanceof CELParser.StringContext) {
            return this.helpers.getStringValue(((CELParser.StringContext)lit).tok);
        }
        if (lit instanceof CELParser.BytesContext) {
            return this.helpers.getBytesValue(((CELParser.BytesContext)lit).tok);
        }
        if (lit instanceof CELParser.BoolFalseContext) {
            return this.helpers.getBoolValue(((CELParser.BoolFalseContext)lit).tok, false);
        }
        if (lit instanceof CELParser.BoolTrueContext) {
            return this.helpers.getBoolValue(((CELParser.BoolTrueContext)lit).tok, true);
        }
        if (lit instanceof CELParser.NullContext) {
            return this.helpers.getNullValue(((CELParser.NullContext)lit).tok);
        }
        return ParserHelpers.ERROR;
    }

    private List<Expr> visit(CELParser.ExprListContext ctx) {
        ArrayList<Expr> exprList = new ArrayList<Expr>();
        if (ctx == null || ctx.e == null) {
            return exprList;
        }
        for (CELParser.ExprContext exprContext : ctx.e) {
            exprList.add(this.visit(exprContext));
        }
        return exprList;
    }

    private List<Expr.CreateStruct.Entry> visit(CELParser.FieldInitializerListContext ctx) {
        ArrayList<Expr.CreateStruct.Entry> fieldList = new ArrayList<Expr.CreateStruct.Entry>();
        if (ctx == null || ctx.fields == null) {
            return fieldList;
        }
        for (int i = 0; i < ctx.cols.size() && i < ctx.fields.size() && i < ctx.values.size(); ++i) {
            fieldList.add(this.helpers.newEntry(this.newId(ctx.cols.get(i))).setFieldKey(ctx.fields.get(i).getText()).setValue(this.visit(ctx.values.get(i))).build());
        }
        return fieldList;
    }

    private List<Expr.CreateStruct.Entry> visit(CELParser.MapInitializerListContext ctx) {
        ArrayList<Expr.CreateStruct.Entry> mapList = new ArrayList<Expr.CreateStruct.Entry>();
        if (ctx == null || ctx.keys == null) {
            return mapList;
        }
        for (int i = 0; i < ctx.cols.size() && i < ctx.keys.size() && i < ctx.values.size(); ++i) {
            mapList.add(this.helpers.newEntry(this.newId(ctx.cols.get(i))).setMapKey(this.visit(ctx.keys.get(i))).setValue(this.visit(ctx.values.get(i))).build());
        }
        return mapList;
    }

    private long newId(Token token) {
        return this.helpers.newId(token);
    }

    private static class BalancedOperatorBuilder {
        private final List<Expr> exprs = new ArrayList<Expr>();
        private final List<Long> operators = new ArrayList<Long>();
        private final String operator;
        private final ParserHelpers helpers;

        public BalancedOperatorBuilder(String operator, Expr expr, ParserHelpers helpers) {
            this.operator = operator;
            this.exprs.add(expr);
            this.helpers = helpers;
        }

        public BalancedOperatorBuilder addTerm(long opId, Expr expr) {
            this.operators.add(opId);
            this.exprs.add(expr);
            return this;
        }

        public Expr build() {
            if (this.operators.isEmpty()) {
                return this.exprs.get(0);
            }
            return this.buildBalancedTree(0, this.operators.size() - 1);
        }

        private Expr buildBalancedTree(int low, int high) {
            int mid = (low + high + 1) / 2;
            Expr left = mid == low ? this.exprs.get(mid) : this.buildBalancedTree(low, mid - 1);
            Expr right = mid == high ? this.exprs.get(mid + 1) : this.buildBalancedTree(mid + 1, high);
            return this.helpers.makeCall((long)this.operators.get(mid), this.operator, left, right);
        }
    }
}

