/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.tools.expr.parser;

import com.google.api.tools.expr.parser.AutoValue_Errors_SourceRef;
import com.google.auto.value.AutoValue;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.re2j.Matcher;
import com.google.re2j.Pattern;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.annotation.Nullable;

public final class Errors {
    private static final Pattern LINE_REGEXP = Pattern.compile("(?m)^");
    private final List<Error> errors = new ArrayList<Error>();
    private final Stack<Context> context = new Stack();

    public Errors(String description, @Nullable String source) {
        this.enterContext(description, source);
    }

    public void enterContext(String description, @Nullable String source) {
        this.context.push(new Context(Preconditions.checkNotNull(description), source));
    }

    public void exitContext() {
        Preconditions.checkState(this.context.size() > 0, "cannot exit top-level error context");
        this.context.pop();
    }

    public List<Integer> getLineOffsets() {
        return this.context.peek().getLineOffsets();
    }

    public String getDescription() {
        return this.context.peek().description;
    }

    public String getLocationAt(int position) {
        Context current = this.context.peek();
        SourceRef sourceRef = current.getSourceRef(position);
        if (sourceRef == null) {
            String string = current.description;
            return new StringBuilder(12 + String.valueOf(string).length()).append(string).append(":").append(position).toString();
        }
        int line = sourceRef.line() + 1;
        int column = sourceRef.column();
        return String.format("%s:%d:%d", current.description, line, column);
    }

    public SourceRef getSourceRef(int position) {
        Context current = this.context.peek();
        return current.getSourceRef(position);
    }

    public int getErrorCount() {
        return this.errors.size();
    }

    public List<Error> getErrors() {
        return this.errors;
    }

    public String getAllErrorsAsString() {
        return Joiner.on(String.format("%n", new Object[0])).join(this.errors);
    }

    public void reportError(int position, String message, Object ... args) {
        if (args.length > 0) {
            message = String.format(message, args);
        }
        this.errors.add(new Error(this.context.peek(), position, message));
    }

    public static interface ErrorFormatter {
        public String formatError(String var1);
    }

    public static class Error {
        private final Context context;
        private final int position;
        private final String message;

        private Error(Context context, int position, String message) {
            this.context = context;
            this.position = position;
            this.message = message;
        }

        public int position() {
            return this.position;
        }

        public String rawMessage() {
            return this.message;
        }

        public String toDisplayString(@Nullable ErrorFormatter formatter) {
            String marker = formatter != null ? formatter.formatError("ERROR") : "ERROR";
            SourceRef sourceRef = this.context.getSourceRef(this.position);
            if (sourceRef == null) {
                return String.format("%s: %s:%s: %s", marker, this.context.description, this.position, this.message);
            }
            String sourceLine = sourceRef.source();
            int line = sourceRef.line() + 1;
            int column = sourceRef.column();
            StringBuilder result = new StringBuilder(String.format("%s: %s:%s:%s: %s", marker, this.context.description, line, column, this.message));
            result.append(String.format("%n", new Object[0]));
            result.append("  | ");
            result.append(sourceLine.replace("%", "%%"));
            result.append(String.format("%n", new Object[0]));
            result.append("  | ");
            result.append(Strings.repeat(".", column));
            result.append("^");
            return result.toString();
        }

        public String toString() {
            return this.toDisplayString(null);
        }
    }

    @AutoValue
    public static abstract class SourceRef {
        public abstract String source();

        public abstract int line();

        public abstract int column();

        public static SourceRef of(String source, int line, int column) {
            return new AutoValue_Errors_SourceRef(source, line, column);
        }
    }

    private static class Context {
        private final String description;
        @Nullable
        private final String source;
        private List<Integer> lineOffsets;

        private Context(String description, @Nullable String source) {
            this.description = description;
            this.source = source;
        }

        public List<Integer> getLineOffsets() {
            if (this.lineOffsets == null) {
                this.lineOffsets = new ArrayList<Integer>();
                if (this.source != null) {
                    Matcher matcher = LINE_REGEXP.matcher(this.source);
                    while (matcher.find()) {
                        this.lineOffsets.add(matcher.end());
                    }
                    this.lineOffsets.add(this.source.length());
                }
            }
            return this.lineOffsets;
        }

        @Nullable
        private SourceRef getSourceRef(int offset) {
            int line;
            if (this.source == null) {
                return null;
            }
            List<Integer> offsets = this.getLineOffsets();
            for (line = 0; line < offsets.size() - 1; ++line) {
                int lineStart = offsets.get(line);
                int lineEnd = offsets.get(line + 1);
                if (offset < lineStart || offset >= lineEnd && (offset != lineEnd || line != offsets.size() - 2)) continue;
                return SourceRef.of(this.source.substring(lineStart, lineEnd).replaceAll("\n$", ""), line, offset - lineStart);
            }
            return SourceRef.of("", line, 0);
        }
    }
}

