/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.tools.expr.parser;

import com.google.api.expr.Expr;
import com.google.api.expr.ParsedExpr;
import com.google.api.expr.SourceInfo;
import com.google.api.tools.expr.features.ExprFeatures;
import com.google.api.tools.expr.parser.AntlrExprVisitor;
import com.google.api.tools.expr.parser.CELLexer;
import com.google.api.tools.expr.parser.CELParser;
import com.google.api.tools.expr.parser.Errors;
import com.google.api.tools.expr.parser.Macros;
import com.google.api.tools.expr.parser.Operators;
import com.google.api.tools.expr.parser.ParserHelpers;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CommonTokenStream;

public final class ExprParser {
    private ExprParser() {
    }

    public static ParsedExpr parse(Errors errors, String source, List<Macros.Macro> supportedMacros, ExprFeatures ... exprFeatures) {
        return ExprParser.parse(errors, source, supportedMacros, ImmutableSet.copyOf(exprFeatures));
    }

    public static ParsedExpr parse(Errors errors, String source, List<Macros.Macro> supportedMacros, ImmutableSet<ExprFeatures> exprFeatures) {
        Operators.Version ops = Operators.Version.V1;
        if (exprFeatures.contains(ExprFeatures.NON_OVERRIDABLE_OPERATOR_NAMES)) {
            ops = Operators.Version.V2;
        }
        ParserHelpers helpers = new ParserHelpers(errors, supportedMacros, ops);
        AntlrExprVisitor visitor = new AntlrExprVisitor(helpers);
        CELLexer lexer = new CELLexer(new ANTLRInputStream(source));
        CELParser parser = new CELParser(new CommonTokenStream(lexer));
        lexer.removeErrorListeners();
        parser.removeErrorListeners();
        lexer.addErrorListener(helpers);
        parser.addErrorListener(helpers);
        Expr result = visitor.visit(parser.start().expr());
        SourceInfo sourceInfo = helpers.getSourceInfo().setLocation(errors.getDescription()).addAllLineOffsets(errors.getLineOffsets()).build();
        return ParsedExpr.newBuilder().setSourceInfo(sourceInfo).setExpr(result).build();
    }
}

