/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.tools.expr.parser;

import com.google.api.expr.Constant;
import com.google.api.expr.Expr;
import com.google.api.tools.expr.parser.ParserHelpers;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import java.util.List;
import javax.annotation.Nullable;

public class Macros {
    public static final Macro HAS = new Macro("has", false, 1, new MacroExpander(){

        @Override
        public Expr expand(ParserHelpers helpers, long id, @Nullable Expr target, List<Expr> args) {
            return Macros.makeHas(helpers, id, target, args);
        }
    });
    public static final Macro ALL = new Macro("all", true, 2, new MacroExpander(){

        @Override
        public Expr expand(ParserHelpers helpers, long id, @Nullable Expr target, List<Expr> args) {
            return Macros.makeQuantifier(QuantifierKind.ALL, helpers, id, target, args);
        }
    });
    public static final Macro EXISTS = new Macro("exists", true, 2, new MacroExpander(){

        @Override
        public Expr expand(ParserHelpers helpers, long id, @Nullable Expr target, List<Expr> args) {
            return Macros.makeQuantifier(QuantifierKind.EXISTS, helpers, id, target, args);
        }
    });
    public static final Macro EXISTS_ONE = new Macro("exists_one", true, 2, new MacroExpander(){

        @Override
        public Expr expand(ParserHelpers helpers, long id, @Nullable Expr target, List<Expr> args) {
            return Macros.makeQuantifier(QuantifierKind.EXISTS_ONE, helpers, id, target, args);
        }
    });
    public static final Macro MAP = new Macro("map", true, 2, new MacroExpander(){

        @Override
        public Expr expand(ParserHelpers helpers, long id, @Nullable Expr target, List<Expr> args) {
            return Macros.makeMap(helpers, id, target, args);
        }
    });
    public static final Macro MAP_FILTER = new Macro("map", true, 3, new MacroExpander(){

        @Override
        public Expr expand(ParserHelpers helpers, long id, @Nullable Expr target, List<Expr> args) {
            return Macros.makeMap(helpers, id, target, args);
        }
    });
    public static final Macro FILTER = new Macro("filter", true, 2, new MacroExpander(){

        @Override
        public Expr expand(ParserHelpers helpers, long id, @Nullable Expr target, List<Expr> args) {
            return Macros.makeFilter(helpers, id, target, args);
        }
    });
    public static final ImmutableList<Macro> ALL_MACROS = ImmutableList.of(HAS, ALL, EXISTS, EXISTS_ONE, MAP, MAP_FILTER, FILTER);
    public static final ImmutableList<Macro> NO_MACROS = ImmutableList.of();
    private static final String ACCUMULATOR_NAME = "__result__";

    private static Expr makeHas(ParserHelpers helpers, long id, Expr unusedTarget, List<Expr> args) {
        Expr arg = args.get(0);
        if (arg.getExprKindCase() != Expr.ExprKindCase.SELECT_EXPR) {
            helpers.errors.reportError(helpers.getPosition(id), "The argument to the function 'has' must be a field selection", new Object[0]);
            return ParserHelpers.ERROR;
        }
        return helpers.newExpr(id).setSelectExpr(arg.getSelectExpr().toBuilder().setTestOnly(true)).build();
    }

    private static Expr makeQuantifier(QuantifierKind kind, final ParserHelpers helpers, final long id, Expr target, List<Expr> args) {
        Expr result;
        Expr step;
        Expr condition;
        Expr init;
        String var = helpers.extractIdent(args.get(0));
        if (var == null) {
            return ParserHelpers.ERROR;
        }
        Supplier<Expr> accuIdent = new Supplier<Expr>(){

            @Override
            public Expr get() {
                return helpers.makeIdent(Macros.macroId(helpers, id), Macros.ACCUMULATOR_NAME);
            }
        };
        long initId = Macros.macroId(helpers, id);
        switch (kind) {
            case ALL: {
                init = helpers.makeConst(initId, Constant.newBuilder().setBoolValue(true));
                condition = helpers.makeCall(Macros.macroId(helpers, id), "__not_strictly_false__", (Expr)accuIdent.get());
                step = helpers.makeCall(Macros.macroId(helpers, id), "_&&_", (Expr)accuIdent.get(), args.get(1));
                result = (Expr)accuIdent.get();
                break;
            }
            case EXISTS: {
                init = helpers.makeConst(initId, Constant.newBuilder().setBoolValue(false));
                condition = helpers.makeCall(Macros.macroId(helpers, id), "__not_strictly_false__", helpers.makeCall(Macros.macroId(helpers, id), "!_", (Expr)accuIdent.get()));
                step = helpers.makeCall(Macros.macroId(helpers, id), "_||_", (Expr)accuIdent.get(), args.get(1));
                result = (Expr)accuIdent.get();
                break;
            }
            case EXISTS_ONE: {
                Expr zeroExpr = helpers.makeConst(initId, Constant.newBuilder().setInt64Value(0L));
                Expr oneExpr = helpers.makeConst(Macros.macroId(helpers, id), Constant.newBuilder().setInt64Value(1L));
                init = zeroExpr;
                condition = helpers.makeCall(Macros.macroId(helpers, id), "_<=_", (Expr)accuIdent.get(), oneExpr);
                step = helpers.makeCall(Macros.macroId(helpers, id), "_?_:_", args.get(1), helpers.makeCall(helpers.newId(helpers.getPosition(id)), "_+_", (Expr)accuIdent.get(), oneExpr), (Expr)accuIdent.get());
                result = helpers.makeCall(helpers.newId(helpers.getPosition(id)), "_==_", (Expr)accuIdent.get(), oneExpr);
                break;
            }
            default: {
                throw new IllegalArgumentException("not a quantifier");
            }
        }
        return helpers.newExpr(id).setComprehensionExpr(Expr.Comprehension.newBuilder().setIterVar(var).setIterRange(target).setAccuVar(ACCUMULATOR_NAME).setAccuInit(init).setLoopCondition(condition).setLoopStep(step).setResult(result)).build();
    }

    private static Expr makeMap(ParserHelpers helpers, long id, Expr target, List<Expr> args) {
        Expr func;
        Expr filter;
        String var = helpers.extractIdent(args.get(0));
        if (var == null) {
            return ParserHelpers.ERROR;
        }
        if (args.size() == 3) {
            filter = args.get(1);
            func = args.get(2);
        } else {
            filter = null;
            func = args.get(1);
        }
        Expr accuExpr = helpers.makeIdent(Macros.macroId(helpers, id), ACCUMULATOR_NAME);
        Expr init = helpers.newExpr(Macros.macroId(helpers, id)).setListExpr(Expr.CreateList.newBuilder()).build();
        Expr condition = helpers.makeConst(Macros.macroId(helpers, id), Constant.newBuilder().setBoolValue(true));
        Expr step = helpers.makeCall(Macros.macroId(helpers, id), "_+_", accuExpr, helpers.newExpr(Macros.macroId(helpers, id)).setListExpr(Expr.CreateList.newBuilder().addElements(func)).build());
        if (filter != null) {
            step = helpers.makeCall(Macros.macroId(helpers, id), "_?_:_", filter, step, accuExpr);
        }
        return helpers.newExpr(id).setComprehensionExpr(Expr.Comprehension.newBuilder().setIterVar(var).setIterRange(target).setAccuVar(ACCUMULATOR_NAME).setAccuInit(init).setLoopCondition(condition).setLoopStep(step).setResult(accuExpr)).build();
    }

    private static Expr makeFilter(ParserHelpers helpers, long id, Expr target, List<Expr> args) {
        String var = helpers.extractIdent(args.get(0));
        if (var == null) {
            return ParserHelpers.ERROR;
        }
        Expr filter = args.get(1);
        Expr accuExpr = helpers.makeIdent(Macros.macroId(helpers, id), ACCUMULATOR_NAME);
        Expr init = helpers.newExpr(Macros.macroId(helpers, id)).setListExpr(Expr.CreateList.newBuilder()).build();
        Expr condition = helpers.makeConst(Macros.macroId(helpers, id), Constant.newBuilder().setBoolValue(true));
        Expr step = helpers.makeCall(Macros.macroId(helpers, id), "_+_", accuExpr, helpers.newExpr(Macros.macroId(helpers, id)).setListExpr(Expr.CreateList.newBuilder().addElements(args.get(0))).build());
        step = helpers.makeCall(Macros.macroId(helpers, id), "_?_:_", filter, step, accuExpr);
        return helpers.newExpr(id).setComprehensionExpr(Expr.Comprehension.newBuilder().setIterVar(var).setIterRange(target).setAccuVar(ACCUMULATOR_NAME).setAccuInit(init).setLoopCondition(condition).setLoopStep(step).setResult(accuExpr)).build();
    }

    private static long macroId(ParserHelpers helpers, long nodeId) {
        return helpers.newId(helpers.getPosition(nodeId));
    }

    private static enum QuantifierKind {
        ALL,
        EXISTS,
        EXISTS_ONE;

    }

    @Immutable
    public static interface MacroExpander {
        public Expr expand(ParserHelpers var1, long var2, @Nullable Expr var4, List<Expr> var5);
    }

    public static class Macro {
        public final String name;
        public final boolean instanceStyle;
        public final int argCount;
        public final MacroExpander rewriter;

        public Macro(String name, boolean instanceStyle, int argCount, MacroExpander rewriter) {
            this.name = name;
            this.instanceStyle = instanceStyle;
            this.argCount = argCount;
            this.rewriter = rewriter;
        }
    }
}

