/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.tools.expr.parser;

import com.google.common.collect.ImmutableMap;
import javax.annotation.Nullable;

public class Operators {
    public static final String CONDITIONAL_NAME = "_?_:_";
    public static final String LOGICAL_AND_NAME = "_&&_";
    public static final String LOGICAL_OR_NAME = "_||_";
    public static final String LOGICAL_NOT_NAME = "!_";
    public static final String IN_NAME = "_in_";
    public static final String EQUALS_NAME = "_==_";
    public static final String NOT_EQUALS_NAME = "_!=_";
    public static final String LESS_NAME = "_<_";
    public static final String LESS_EQUALS_NAME = "_<=_";
    public static final String GREATER_NAME = "_>_";
    public static final String GREATER_EQUALS_NAME = "_>=_";
    public static final String ADD_NAME = "_+_";
    public static final String SUBTRACT_NAME = "_-_";
    public static final String MULTIPLY_NAME = "_*_";
    public static final String DIVIDE_NAME = "_/_";
    public static final String MODULO_NAME = "_%_";
    public static final String NEGATE_NAME = "-_";
    public static final String INDEX_NAME = "_[_]";
    public static final String HAS_NAME = "has";
    public static final String ALL_NAME = "all";
    public static final String EXISTS_NAME = "exists";
    public static final String EXISTS_ONE_NAME = "exists_one";
    public static final String MAP_NAME = "map";
    public static final String FILTER_NAME = "filter";
    public static final String NOT_STRICTLY_FALSE = "__not_strictly_false__";
    public static final String IN_NAME_V2 = "@in";
    public static final String NOT_STRICTLY_FALSE_V2 = "@not_strictly_false";

    private Operators() {
    }

    public static enum Version {
        V1(ImmutableMap.of(1, ImmutableMap.builder().put("-", "-_").put("!", "!_").build(), 2, ImmutableMap.builder().put("+", "_+_").put("-", "_-_").put("*", "_*_").put("/", "_/_").put("%", "_%_").put("==", "_==_").put("!=", "_!=_").put("<", "_<_").put("<=", "_<=_").put(">", "_>_").put(">=", "_>=_").put("in", "_in_").build())),
        V2(V1, ImmutableMap.of(1, ImmutableMap.of("__not_strictly_false__", "@not_strictly_false"), 2, ImmutableMap.of("_in_", "@in", "in", "@in")));

        @Nullable
        private final Version base;
        private final ImmutableMap<Integer, ImmutableMap<String, String>> opsByArgCount;

        private Version(ImmutableMap<Integer, ImmutableMap<String, String>> opsByArgCount) {
            this(null, opsByArgCount);
        }

        private Version(Version base, ImmutableMap<Integer, ImmutableMap<String, String>> opsByArgCount) {
            this.base = base;
            this.opsByArgCount = opsByArgCount;
        }

        boolean isOperator(String name, int argCount) {
            ImmutableMap opGroup = this.opsByArgCount.getOrDefault(argCount, ImmutableMap.of());
            return opGroup.containsKey(name) || this.base != null && this.base.isOperator(name, argCount);
        }

        String getFunction(String txt, int argCount) {
            ImmutableMap opGroup = this.opsByArgCount.getOrDefault(argCount, ImmutableMap.of());
            if (opGroup.containsKey(txt)) {
                return (String)opGroup.get(txt);
            }
            if (this.base != null) {
                return this.base.getFunction(txt, argCount);
            }
            return txt;
        }
    }
}

