/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.tools.expr.parser;

import com.google.api.expr.Constant;
import com.google.api.expr.Expr;
import com.google.api.expr.SourceInfo;
import com.google.api.tools.expr.parser.Errors;
import com.google.api.tools.expr.parser.Macros;
import com.google.api.tools.expr.parser.Operators;
import com.google.api.tools.expr.parser.StringDecoder;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.UnsignedLong;
import com.google.protobuf.ByteString;
import com.google.protobuf.NullValue;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.IntStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenStream;

public class ParserHelpers
extends BaseErrorListener {
    private static final String ERROR_STRING = "*error*";
    public static final Expr ERROR = Expr.newBuilder().setConstExpr(Constant.newBuilder().setStringValue("*error*")).build();
    final Errors errors;
    private final ImmutableMap<String, Macros.Macro> macros;
    private final Operators.Version operators;
    private long nodeId = 1L;
    private final Map<Long, Integer> positions;

    public ParserHelpers(Errors errors, List<Macros.Macro> supportedMacros, Operators.Version operators) {
        this(errors, supportedMacros, ImmutableMap.of(), operators);
    }

    public ParserHelpers(Errors errors, List<Macros.Macro> supportedMacros, Map<Long, Integer> existingPositions, Operators.Version operators) {
        this.errors = Preconditions.checkNotNull(errors);
        ImmutableMap.Builder<String, Macros.Macro> macrosBuilder = ImmutableMap.builder();
        for (Macros.Macro macro : supportedMacros) {
            macrosBuilder.put(ParserHelpers.makeMacroKey(macro.name, macro.argCount, macro.instanceStyle), macro);
        }
        this.operators = operators;
        this.macros = macrosBuilder.build();
        this.positions = new HashMap<Long, Integer>();
        for (Map.Entry entry : existingPositions.entrySet()) {
            if ((Long)entry.getKey() >= this.nodeId) {
                this.nodeId = (Long)entry.getKey() + 1L;
            }
            this.positions.put((Long)entry.getKey(), (Integer)entry.getValue());
        }
    }

    public boolean isBinaryOperator(String txt) {
        return this.operators.isOperator(txt, 2);
    }

    public Errors getErrorContext() {
        return this.errors;
    }

    public SourceInfo.Builder getSourceInfo() {
        return SourceInfo.newBuilder().putAllPositions(this.positions);
    }

    public int getPosition(Expr expr) {
        return this.getPosition(expr.getId());
    }

    public int getPosition(long nodeId) {
        return this.positions.get(nodeId);
    }

    public Map<Long, Integer> getPositions() {
        return this.positions;
    }

    public long newId(Token token) {
        return this.newId(token.getStartIndex());
    }

    public long newId(int position) {
        long nodeId = this.nodeId++;
        this.positions.put(nodeId, position);
        return nodeId;
    }

    public Expr.Builder newExpr(long id) {
        return Expr.newBuilder().setId(id);
    }

    public Expr.CreateStruct.Entry.Builder newEntry(long id) {
        return Expr.CreateStruct.Entry.newBuilder().setId(id);
    }

    public boolean checkNull(Iterable<Expr> args) {
        for (Expr arg : args) {
            if (arg != null) continue;
            return true;
        }
        return false;
    }

    public Expr makeCall(long id, String name, Expr ... args) {
        List<Expr> list = Arrays.asList(args);
        return this.makeCall(id, null, name, list);
    }

    public Expr makeCall(long id, @Nullable Expr target, String name, List<Expr> args) {
        if (this.checkNull(args)) {
            return ERROR;
        }
        Macros.Macro macro = this.macros.get(ParserHelpers.makeMacroKey(name = this.operators.getFunction(name, args.size()), args.size(), target != null));
        if (macro != null) {
            return macro.rewriter.expand(this, id, target, args);
        }
        Expr.Call.Builder builder = Expr.Call.newBuilder();
        builder.setFunction(name);
        if (target != null) {
            builder.setTarget(target);
        }
        builder.addAllArgs(args);
        return this.newExpr(id).setCallExpr(builder).build();
    }

    public Expr makeSelect(long id, Expr oper, String field, boolean testOnly) {
        if (oper == null) {
            return ERROR;
        }
        return this.newExpr(id).setSelectExpr(Expr.Select.newBuilder().setOperand(oper).setField(field).setTestOnly(testOnly)).build();
    }

    public Expr makeConst(long id, Constant.Builder value) {
        return this.newExpr(id).setConstExpr(value).build();
    }

    public Expr makeIdent(long id, String name) {
        return this.newExpr(id).setIdentExpr(Expr.Ident.newBuilder().setName(name)).build();
    }

    public String extractQualifiedName(long id, Expr expr) {
        if (expr == null) {
            return ERROR_STRING;
        }
        switch (expr.getExprKindCase()) {
            case IDENT_EXPR: {
                return expr.getIdentExpr().getName();
            }
            case SELECT_EXPR: {
                String string = this.extractQualifiedName(id, expr.getSelectExpr().getOperand());
                String string2 = expr.getSelectExpr().getField();
                return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(".").append(string2).toString();
            }
        }
        this.errors.reportError(this.getPosition(id), "expected a qualified name", new Object[0]);
        return ERROR_STRING;
    }

    public String extractIdent(Expr expr) {
        if (expr.getExprKindCase() != Expr.ExprKindCase.IDENT_EXPR) {
            this.errors.reportError(this.getPosition(expr), "The argument must be a simple name", new Object[0]);
            return ERROR_STRING;
        }
        return expr.getIdentExpr().getName();
    }

    public Expr getStringValue(Token token) {
        String input;
        int position = token.getStartIndex();
        String text = input = token.getText();
        try {
            text = StringDecoder.decodeUtf8String(input);
        }
        catch (IllegalArgumentException e) {
            this.errors.reportError(position, e.getMessage(), new Object[0]);
        }
        return this.makeConst(this.newId(token), Constant.newBuilder().setStringValue(text));
    }

    public Expr getBytesValue(Token token) {
        ByteString bytes;
        int position = token.getStartIndex();
        String input = token.getText();
        try {
            bytes = StringDecoder.decodeByteString(input);
        }
        catch (IllegalArgumentException e) {
            this.errors.reportError(position, e.getMessage(), new Object[0]);
            bytes = ByteString.copyFromUtf8(input);
        }
        return this.makeConst(this.newId(token), Constant.newBuilder().setBytesValue(bytes));
    }

    public Expr getSignedValue(@Nullable Token sign, Token token) {
        String text = token.getText();
        if (sign != null) {
            String string = String.valueOf(sign.getText());
            String string2 = String.valueOf(text);
            text = string2.length() != 0 ? string.concat(string2) : new String(string);
        }
        try {
            return this.makeConst(this.newId(token), Constant.newBuilder().setInt64Value(Long.parseLong(text)));
        }
        catch (NumberFormatException e) {
            this.errors.reportError(token.getStartIndex(), "Invalid number '%s'", text);
            return ERROR;
        }
    }

    public Expr getUnsignedValue(Token token) {
        String text = token.getText();
        text = text.substring(0, text.length() - 1);
        try {
            return this.makeConst(this.newId(token), Constant.newBuilder().setUint64Value(UnsignedLong.valueOf(text).longValue()));
        }
        catch (NumberFormatException e) {
            this.errors.reportError(token.getStartIndex(), "Invalid number '%s'", token.getText());
            return ERROR;
        }
    }

    public Expr getDoubleValue(@Nullable Token sign, Token token) {
        String text = token.getText();
        if (sign != null) {
            String string = String.valueOf(sign.getText());
            String string2 = String.valueOf(text);
            text = string2.length() != 0 ? string.concat(string2) : new String(string);
        }
        try {
            return this.makeConst(this.newId(token), Constant.newBuilder().setDoubleValue(Double.parseDouble(text)));
        }
        catch (NumberFormatException e) {
            this.errors.reportError(token.getStartIndex(), "Invalid number '%s'", text);
            return ERROR;
        }
    }

    public Expr getBoolValue(Token token, boolean value) {
        return this.makeConst(this.newId(token), Constant.newBuilder().setBoolValue(value));
    }

    public Expr getNullValue(Token token) {
        return this.makeConst(this.newId(token), Constant.newBuilder().setNullValue(NullValue.NULL_VALUE));
    }

    @Override
    public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
        int position;
        msg = msg.replace("%", "%%");
        IntStream inputStream = recognizer.getInputStream();
        if (inputStream instanceof TokenStream) {
            TokenStream tokenStream = (TokenStream)inputStream;
            position = tokenStream.LT(1).getStartIndex();
        } else {
            position = charPositionInLine;
        }
        this.errors.reportError(position, msg, new Object[0]);
    }

    private static String makeMacroKey(String name, int argCount, boolean instanceStyle) {
        return String.format("%s:%s:%s", name, argCount, instanceStyle);
    }
}

