/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.tools.expr.parser;

import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import com.google.re2j.Pattern;
import java.nio.charset.StandardCharsets;

public final class StringDecoder {
    private static final Pattern NON_STANDARD_NEWLINES = Pattern.compile("(\r\n|\r)");
    private static final char BACKSLASH = '\\';
    private static final String NEWLINE = "\n";

    public static String decodeUtf8String(String value) {
        Preconditions.checkArgument(value.length() >= 2, "unable to decode string");
        boolean isRawLiteral = value.charAt(0) == 'r' || value.charAt(0) == 'R';
        StringBuilder val = StringDecoder.normalize(value);
        if (isRawLiteral || value.indexOf(92) < 0) {
            return val.toString();
        }
        return StringDecoder.decodeInternal(val, new UnicodeStringBuffer(val.length()));
    }

    public static ByteString decodeByteString(String value) {
        Preconditions.checkArgument(value.length() >= 2, "unable to decode string");
        Preconditions.checkArgument(value.charAt(0) == 'b' || value.charAt(0) == 'B', "byte literals must be prefixed with a 'b' or 'B'");
        value = value.substring(1);
        boolean isRawLiteral = value.charAt(0) == 'r' || value.charAt(0) == 'R';
        StringBuilder val = StringDecoder.normalize(value);
        if (isRawLiteral || value.indexOf(92) < 0) {
            return ByteString.copyFromUtf8(val.toString());
        }
        return StringDecoder.decodeInternal(val, new ByteStringBuffer(val.length()));
    }

    private static <T> T decodeInternal(StringBuilder val, DecodeBuffer<T> buf) {
        int len = val.length();
        for (int index = 0; index < len; ++index) {
            index = StringDecoder.unescapeCharAt(index, val, buf);
        }
        return buf.toDecodeValue();
    }

    private static StringBuilder normalize(String value) {
        char last;
        char first;
        int len = (value = NON_STANDARD_NEWLINES.matcher(value).replaceAll(NEWLINE)).length();
        Preconditions.checkArgument(len >= 2, "unable to decode string");
        if (value.charAt(0) == 'r' || value.charAt(0) == 'R') {
            value = value.substring(1);
            --len;
        }
        Preconditions.checkArgument((first = value.charAt(0)) == (last = value.charAt(len - 1)) && (first == '\"' || first == '\''), "unable to decode string");
        if (len >= 6) {
            if (value.startsWith("'''")) {
                if (!value.endsWith("'''")) {
                    throw new IllegalArgumentException("unable to decode string");
                }
                return new StringBuilder(value.substring(3, len - 3));
            }
            if (value.startsWith("\"\"\"")) {
                if (!value.endsWith("\"\"\"")) {
                    throw new IllegalArgumentException("unable to decode string");
                }
                return new StringBuilder(value.substring(3, len - 3));
            }
        }
        return new StringBuilder(value.substring(1, len - 1));
    }

    private static int unescapeCharAt(int index, StringBuilder value, DecodeBuffer<?> buf) {
        int codePoint = value.codePointAt(index);
        if (codePoint <= 127) {
            return StringDecoder.unescapeAsciiAt(index, value, buf);
        }
        int charCount = Character.charCount(codePoint);
        buf.pushCodePoint(codePoint);
        return index + (charCount - 1);
    }

    private static int unescapeAsciiAt(int index, StringBuilder value, DecodeBuffer<?> buf) {
        int remaining = value.length() - index;
        int codePoint = value.codePointAt(index);
        if (codePoint != 92) {
            buf.pushByte((byte)codePoint);
            return index;
        }
        --remaining;
        codePoint = value.codePointAt(++index);
        switch (codePoint) {
            case 97: {
                buf.pushByte((byte)7);
                break;
            }
            case 98: {
                buf.pushByte((byte)8);
                break;
            }
            case 102: {
                buf.pushByte((byte)12);
                break;
            }
            case 110: {
                buf.pushByte((byte)10);
                break;
            }
            case 114: {
                buf.pushByte((byte)13);
                break;
            }
            case 116: {
                buf.pushByte((byte)9);
                break;
            }
            case 118: {
                buf.pushByte((byte)11);
                break;
            }
            case 92: {
                buf.pushByte((byte)92);
                break;
            }
            case 39: {
                buf.pushByte((byte)39);
                break;
            }
            case 34: {
                buf.pushByte((byte)34);
                break;
            }
            case 96: {
                buf.pushByte((byte)96);
                break;
            }
            case 63: {
                buf.pushByte((byte)63);
                break;
            }
            case 85: 
            case 88: 
            case 117: 
            case 120: {
                int n;
                boolean isEscapedByte;
                ++index;
                --remaining;
                boolean bl = isEscapedByte = codePoint == 120 || codePoint == 88;
                int n2 = isEscapedByte ? 2 : (n = codePoint == 117 ? 4 : 8);
                if (n >= 4 && !buf.supportsUnicode()) {
                    throw new IllegalArgumentException("unicode escape sequence not supported");
                }
                Preconditions.checkArgument(remaining >= n, "unable to decode string");
                int unicode = 0;
                for (int j = 0; j < n; ++j) {
                    unicode = unicode << 4 | StringDecoder.unhex(value.codePointAt(index + j));
                }
                Preconditions.checkArgument(unicode <= 0x10FFFF, "unable to decode string");
                index += n - 1;
                if (isEscapedByte) {
                    buf.pushByte((byte)unicode);
                    break;
                }
                buf.pushCodePoint(unicode);
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                Preconditions.checkArgument(--remaining >= 2, "unable to decode string");
                int octal = codePoint - 48;
                ++index;
                for (int j = 0; j < 2; ++j) {
                    int x = value.codePointAt(index + j);
                    Preconditions.checkArgument(x >= 48 && x <= 55, "unable to decode octal sequence in string.");
                    octal = octal * 8 + (x - 48);
                }
                ++index;
                buf.pushByte((byte)octal);
                break;
            }
            default: {
                throw new IllegalArgumentException("unable to decode string.");
            }
        }
        return index;
    }

    private static int unhex(int c) {
        if (48 <= c && c <= 57) {
            return c - 48;
        }
        if (97 <= c && c <= 102) {
            return c - 97 + 10;
        }
        if (65 <= c && c <= 70) {
            return c - 65 + 10;
        }
        throw new IllegalArgumentException(new StringBuilder(34).append("Invalid hex character: ").append(c).toString());
    }

    private StringDecoder() {
    }

    private static class UnicodeStringBuffer
    implements DecodeBuffer<String> {
        private final StringBuilder stringBuilder;

        UnicodeStringBuffer(int initialLength) {
            this.stringBuilder = new StringBuilder(initialLength);
        }

        @Override
        public void pushByte(byte b) {
            this.stringBuilder.appendCodePoint(b & 0xFF);
        }

        @Override
        public void pushCodePoint(int codePoint) {
            this.stringBuilder.appendCodePoint(codePoint);
        }

        @Override
        public boolean supportsUnicode() {
            return true;
        }

        @Override
        public String toDecodeValue() {
            return this.stringBuilder.toString();
        }
    }

    private static class ByteStringBuffer
    implements DecodeBuffer<ByteString> {
        private final ByteString.Output bytes;
        private final StringBuilder stringBuilder = new StringBuilder(2);

        ByteStringBuffer(int initialCapacity) {
            this.bytes = ByteString.newOutput(initialCapacity);
        }

        @Override
        public void pushByte(byte b) {
            this.bytes.write(b);
        }

        @Override
        public void pushCodePoint(int codePoint) {
            this.stringBuilder.setLength(0);
            this.stringBuilder.appendCodePoint(codePoint);
            byte[] utf8 = this.stringBuilder.toString().getBytes(StandardCharsets.UTF_8);
            this.bytes.write(utf8, 0, utf8.length);
        }

        @Override
        public boolean supportsUnicode() {
            return false;
        }

        @Override
        public ByteString toDecodeValue() {
            return this.bytes.toByteString();
        }
    }

    private static interface DecodeBuffer<T> {
        public void pushByte(byte var1);

        public void pushCodePoint(int var1);

        public boolean supportsUnicode();

        public T toDecodeValue();
    }
}

