/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.appengv3;

import com.google.apphosting.datastore.DatastoreV3Pb;
import com.google.cloud.datastore.core.exception.ValidationException;
import com.google.cloud.datastore.core.extractor.Extractor;
import com.google.cloud.datastore.core.rep.DatabaseRef;
import com.google.cloud.datastore.core.rep.validator.DatabaseRefValidator;
import com.google.cloud.datastore.core.rep.validator.ValidationUtils;
import com.google.common.base.Preconditions;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.nio.charset.StandardCharsets;

public class AppEngV3DatabaseRefExtractor
extends Extractor<DatabaseRef> {
    public static final AppEngV3DatabaseRefExtractor INSTANCE = new AppEngV3DatabaseRefExtractor();
    private static final DatabaseRef EMPTY_INTERNAL_DATABASE = DatabaseRef.createForApp("", "");

    private AppEngV3DatabaseRefExtractor() {
    }

    private static DatabaseRef handleMissingKey() {
        return EMPTY_INTERNAL_DATABASE;
    }

    public DatabaseRef extract(DatastoreV3Pb.GetRequest request) throws ValidationException {
        if (request.keySize() == 0) {
            return AppEngV3DatabaseRefExtractor.handleMissingKey();
        }
        return this.extract(request.getKey(0));
    }

    public DatabaseRef extract(DatastoreV3Pb.AllocateIdsRequest request) throws ValidationException {
        OnestoreEntity.Reference key;
        if (request.hasModelKey()) {
            key = request.getModelKey();
        } else if (request.reserveSize() > 0) {
            key = request.getReserve(0);
        } else {
            return AppEngV3DatabaseRefExtractor.handleMissingKey();
        }
        return this.extract(key);
    }

    public DatabaseRef extract(OnestoreEntity.Reference key) throws ValidationException {
        return AppEngV3DatabaseRefExtractor.validateUtf8AndCreateDatabaseRef(key.getAppAsBytes(), key.getDatabaseIdAsBytes());
    }

    public DatabaseRef extract(OnestoreEntity.PropertyValue.ReferenceValue referenceValue) throws ValidationException {
        return AppEngV3DatabaseRefExtractor.validateUtf8AndCreateDatabaseRef(referenceValue.getAppAsBytes(), referenceValue.getDatabaseIdAsBytes());
    }

    public DatabaseRef extract(DatastoreV3Pb.Transaction request) throws ValidationException {
        return AppEngV3DatabaseRefExtractor.validateUtf8AndCreateDatabaseRef(request.getAppAsBytes(), request.getDatabaseIdAsBytes());
    }

    public DatabaseRef extract(DatastoreV3Pb.BeginTransactionRequest request) throws ValidationException {
        return AppEngV3DatabaseRefExtractor.validateUtf8AndCreateDatabaseRef(request.getAppAsBytes(), request.getDatabaseIdAsBytes());
    }

    public DatabaseRef extract(DatastoreV3Pb.Cursor request) throws ValidationException {
        return AppEngV3DatabaseRefExtractor.validateUtf8AndCreateDatabaseRef(request.getAppAsBytes(), request.getDatabaseIdAsBytes());
    }

    public DatabaseRef extract(DatastoreV3Pb.NextRequest request) throws ValidationException {
        return this.extract(request.getCursor());
    }

    public DatabaseRef extract(DatastoreV3Pb.Query request) throws ValidationException {
        return AppEngV3DatabaseRefExtractor.validateUtf8AndCreateDatabaseRef(request.getAppAsBytes(), request.getDatabaseIdAsBytes());
    }

    public DatabaseRef extract(DatastoreV3Pb.AddActionsRequest request) throws ValidationException {
        return this.extract(request.getTransaction());
    }

    public DatabaseRef extract(DatastoreV3Pb.DeleteRequest request) throws ValidationException {
        if (request.keySize() == 0) {
            return AppEngV3DatabaseRefExtractor.handleMissingKey();
        }
        return this.extract(request.getKey(0));
    }

    public DatabaseRef extract(DatastoreV3Pb.TouchRequest request) throws ValidationException {
        if (request.keySize() == 0) {
            return EMPTY_INTERNAL_DATABASE;
        }
        return this.extract(request.getKey(0));
    }

    public DatabaseRef extract(DatastoreV3Pb.PutRequest request) throws ValidationException {
        if (request.entitySize() == 0) {
            return AppEngV3DatabaseRefExtractor.handleMissingKey();
        }
        return this.extract(request.getEntity(0).getKey());
    }

    public DatabaseRef extract(OnestoreEntity.EntityProto entityProto) throws ValidationException {
        return this.extract(entityProto.getKey());
    }

    public DatabaseRef extract(OnestoreEntity.CompositeIndex request) throws ValidationException {
        return AppEngV3DatabaseRefExtractor.validateUtf8AndCreateDatabaseRef(request.getAppIdAsBytes(), request.getDatabaseIdAsBytes());
    }

    public DatabaseRef extract(DatastoreV3Pb.GetIndicesRequest request) throws ValidationException {
        return AppEngV3DatabaseRefExtractor.validateUtf8AndCreateDatabaseRef(request.getAppIdAsBytes(), request.getDatabaseIdAsBytes());
    }

    public static OnestoreEntity.CompositeIndex set(OnestoreEntity.CompositeIndex compositeIndex, DatabaseRef internalDatabase) {
        compositeIndex.setAppId(internalDatabase.appId());
        if (!internalDatabase.databaseId().isEmpty()) {
            compositeIndex.setDatabaseId(internalDatabase.databaseId());
        }
        return compositeIndex;
    }

    public static DatastoreV3Pb.Query set(DatastoreV3Pb.Query query, DatabaseRef internalDatabase) {
        query.setApp(internalDatabase.appId());
        if (!internalDatabase.databaseId().isEmpty()) {
            query.setDatabaseId(internalDatabase.databaseId());
        }
        return query;
    }

    public static OnestoreEntity.PropertyValue.ReferenceValue set(OnestoreEntity.PropertyValue.ReferenceValue key, DatabaseRef internalDatabase) {
        key.setApp(internalDatabase.appId());
        if (!internalDatabase.databaseId().isEmpty()) {
            key.setDatabaseId(internalDatabase.databaseId());
        }
        return key;
    }

    public static OnestoreEntity.Reference set(OnestoreEntity.Reference key, DatabaseRef internalDatabase) {
        key.setApp(internalDatabase.appId());
        if (!internalDatabase.databaseId().isEmpty()) {
            key.setDatabaseId(internalDatabase.databaseId());
        }
        return key;
    }

    public static DatastoreV3Pb.Transaction set(DatastoreV3Pb.Transaction transaction, DatabaseRef internalDatabase) {
        transaction.setApp(internalDatabase.appId());
        if (!internalDatabase.databaseId().isEmpty()) {
            transaction.setDatabaseId(internalDatabase.databaseId());
        }
        return transaction;
    }

    public static DatastoreV3Pb.BeginTransactionRequest set(DatastoreV3Pb.BeginTransactionRequest beginTransactionRequest, DatabaseRef internalDatabase) {
        beginTransactionRequest.setApp(internalDatabase.appId());
        if (!internalDatabase.databaseId().isEmpty()) {
            beginTransactionRequest.setDatabaseId(internalDatabase.databaseId());
        }
        return beginTransactionRequest;
    }

    public static DatastoreV3Pb.Cursor set(DatastoreV3Pb.Cursor cursor, DatabaseRef internalDatabase) {
        cursor.setApp(internalDatabase.appId());
        if (!internalDatabase.databaseId().isEmpty()) {
            cursor.setDatabaseId(internalDatabase.databaseId());
        }
        return cursor;
    }

    public static DatastoreV3Pb.AllocateIdsRequest set(DatastoreV3Pb.AllocateIdsRequest request, DatabaseRef internalDatabase) {
        Preconditions.checkArgument(request.equals(DatastoreV3Pb.AllocateIdsRequest.getDefaultInstance()), "Because there are two places to set keys, and you sent an AllocateIdsRequest that already had something in it, you need to directly set the database where you want.");
        AppEngV3DatabaseRefExtractor.set(request.addReserve(), internalDatabase);
        return request;
    }

    public static DatastoreV3Pb.GetIndicesRequest set(DatastoreV3Pb.GetIndicesRequest getIndicesRequest, DatabaseRef internalDatabase) {
        getIndicesRequest.setAppId(internalDatabase.appId());
        if (!internalDatabase.databaseId().isEmpty()) {
            getIndicesRequest.setDatabaseId(internalDatabase.databaseId());
        }
        return getIndicesRequest;
    }

    private static DatabaseRef validateUtf8AndCreateDatabaseRef(byte[] appIdBytes, byte[] databaseIdBytes) throws ValidationException {
        ValidationUtils.INSTANCE.validateStringUtf8(appIdBytes, "app id");
        ValidationUtils.INSTANCE.validateStringUtf8(databaseIdBytes, "database id");
        String appId = new String(appIdBytes, StandardCharsets.UTF_8);
        String databaseId = new String(databaseIdBytes, StandardCharsets.UTF_8);
        return DatabaseRefValidator.INSTANCE.createAndValidateDatabaseRef(appId, databaseId);
    }
}

