/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.appengv3;

import com.google.cloud.datastore.core.rep.V3Paths;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.Iterator;

public final class EntityStorageConversions {
    private EntityStorageConversions() {
    }

    public static void setEntityGroup(OnestoreEntity.EntityProto entity) {
        entity.setEntityGroup(V3Paths.entityGroup(entity.getKey()));
    }

    public static void preprocessIndexes(OnestoreEntity.EntityProto diskEntity) {
        EntityStorageConversions.createComputedAndStashedValuesForEntityValues(diskEntity);
        EntityStorageConversions.markEmptyListsForStashing(diskEntity);
        EntityStorageConversions.stashProperties(diskEntity);
    }

    public static void postprocessIndexes(OnestoreEntity.EntityProto storageEntity) {
        Preconditions.checkNotNull(storageEntity);
        EntityStorageConversions.removeComputedProperties(storageEntity);
        EntityStorageConversions.restoreStashedProperties(storageEntity);
    }

    public static void removeComputedProperties(OnestoreEntity.EntityProto storageEntity) {
        Iterator<OnestoreEntity.Property> propertyIterator = storageEntity.propertyIterator();
        while (propertyIterator.hasNext()) {
            if (!propertyIterator.next().isComputed()) continue;
            propertyIterator.remove();
        }
    }

    public static void restoreStashedProperties(OnestoreEntity.EntityProto storageEntity) {
        ImmutableList<OnestoreEntity.Property> properties = ImmutableList.copyOf(storageEntity.propertys());
        ImmutableList<OnestoreEntity.Property> rawProperties = ImmutableList.copyOf(storageEntity.rawPropertys());
        ImmutableList.Builder badlyStashedProperties = ImmutableList.builder();
        int propertyListIndex = 0;
        storageEntity.clearProperty();
        storageEntity.clearRawProperty();
        for (OnestoreEntity.Property rawProperty : rawProperties) {
            if (rawProperty.hasStashed()) {
                int stashed = rawProperty.getStashed();
                int advance = stashed - storageEntity.propertySize();
                if (stashed < storageEntity.propertySize() || propertyListIndex + advance > properties.size()) {
                    badlyStashedProperties.add(rawProperty.clearStashed());
                    continue;
                }
                if (advance > 0) {
                    storageEntity.mutablePropertys().addAll(properties.subList(propertyListIndex, propertyListIndex + advance));
                    propertyListIndex += advance;
                }
                storageEntity.addProperty(rawProperty.clearStashed());
                continue;
            }
            storageEntity.addRawProperty(rawProperty);
        }
        storageEntity.mutablePropertys().addAll(properties.subList(propertyListIndex, properties.size()));
        storageEntity.mutablePropertys().addAll(badlyStashedProperties.build());
    }

    public static void markEmptyListsForStashing(OnestoreEntity.EntityProto diskEntity) {
        for (int i = 0; i < diskEntity.propertySize(); ++i) {
            OnestoreEntity.Property property = diskEntity.getProperty(i);
            if (property.getMeaningEnum() != OnestoreEntity.Property.Meaning.EMPTY_LIST) continue;
            property.setStashed(i);
        }
    }

    public static void stashProperties(OnestoreEntity.EntityProto diskEntity) {
        ImmutableList<OnestoreEntity.Property> properties = ImmutableList.copyOf(diskEntity.propertys());
        diskEntity.clearProperty();
        for (OnestoreEntity.Property property : properties) {
            if (property.hasStashed()) {
                if (property.isComputed()) continue;
                diskEntity.addRawProperty(property);
                continue;
            }
            diskEntity.addProperty(property);
        }
    }

    public static void createComputedAndStashedValuesForEntityValues(OnestoreEntity.EntityProto diskEntity) {
        ImmutableList.Builder<OnestoreEntity.Property> computedProperties = ImmutableList.builder();
        for (int i = 0; i < diskEntity.propertySize(); ++i) {
            OnestoreEntity.Property property = diskEntity.getProperty(i);
            if (!EntityStorageConversions.isEntityValue(property)) continue;
            property.setStashed(i);
            EntityStorageConversions.flattenIndexedEntityValues(property.getName(), property.isMultiple(), property.getValue().getStringValueAsBytes(), computedProperties);
        }
        diskEntity.mutablePropertys().addAll(computedProperties.build());
    }

    private static OnestoreEntity.EntityProto deserializeEmbeddedEntityProto(byte[] value, String propertyName) {
        try {
            return OnestoreEntity.EntityProto.parser().parsePartialFrom(value);
        }
        catch (InvalidProtocolBufferException e) {
            String string = String.valueOf(propertyName);
            throw new IllegalArgumentException(string.length() != 0 ? "Unable to parse ".concat(string) : new String("Unable to parse "), e);
        }
    }

    private static void flattenIndexedEntityValues(String pathPrefix, boolean multiplePath, byte[] currentSerializedEntityValue, ImmutableList.Builder<OnestoreEntity.Property> flattenedProperties) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(pathPrefix));
        OnestoreEntity.EntityProto currentEntityValue = EntityStorageConversions.deserializeEmbeddedEntityProto(currentSerializedEntityValue, pathPrefix);
        if (currentEntityValue.getKey().getPath().elementSize() > 0) {
            String string = String.valueOf(pathPrefix);
            String string2 = String.valueOf(".__key__");
            flattenedProperties.add((Object)new OnestoreEntity.Property().setName(string2.length() != 0 ? string.concat(string2) : new String(string)).setValue(V3Paths.toReferenceProperty(currentEntityValue.getKey())).setMultiple(multiplePath).setComputed(true));
        }
        for (OnestoreEntity.Property property : currentEntityValue.propertys()) {
            String string;
            if (EntityStorageConversions.isEntityValue(property)) {
                string = property.getName();
                EntityStorageConversions.flattenIndexedEntityValues(new StringBuilder(1 + String.valueOf(pathPrefix).length() + String.valueOf(string).length()).append(pathPrefix).append(".").append(string).toString(), multiplePath || property.isMultiple(), property.getValue().getStringValueAsBytes(), flattenedProperties);
                continue;
            }
            string = property.getName();
            flattenedProperties.add((Object)property.setName(new StringBuilder(1 + String.valueOf(pathPrefix).length() + String.valueOf(string).length()).append(pathPrefix).append(".").append(string).toString()).setMultiple(multiplePath || property.isMultiple()).setComputed(true));
        }
    }

    static boolean isEntityValue(OnestoreEntity.Property property) {
        return property.getMeaningEnum().equals(OnestoreEntity.Property.Meaning.ENTITY_PROTO);
    }
}

