/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.appengv3;

import com.google.apphosting.datastore.DatastoreV3Pb;
import com.google.cloud.datastore.core.appengv3.AppEngV3DatabaseRefExtractor;
import com.google.cloud.datastore.core.exception.InvalidConversionException;
import com.google.cloud.datastore.core.internal.Transactions;
import com.google.cloud.datastore.core.rep.DatabaseRef;
import com.google.cloud.datastore.internal.Transaction;
import com.google.protobuf.ByteString;

public class LocalTransactionConverter {
    public ByteString toTransactionBytes(DatastoreV3Pb.Transaction transactionV3) {
        return this.toTransactionBytes(transactionV3.getHandle());
    }

    public ByteString toTransactionBytes(long transactionHandle) {
        return this.toTransactionProto(transactionHandle).toByteString();
    }

    public DatastoreV3Pb.Transaction toV3Transaction(ByteString transactionBytesV1, String appId, String databaseId) throws InvalidConversionException {
        DatastoreV3Pb.Transaction transactionV3 = new DatastoreV3Pb.Transaction();
        transactionV3.setHandle(Transactions.getTransactionHandle(transactionBytesV1));
        AppEngV3DatabaseRefExtractor.set(transactionV3, DatabaseRef.createForApp(appId, databaseId));
        return transactionV3;
    }

    public Transaction toTransactionProto(long transactionHandle) {
        return Transaction.newBuilder().setHandle(transactionHandle).build();
    }
}

