/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.appengv3;

import com.google.cloud.datastore.core.exception.DatastoreException;
import com.google.cloud.datastore.core.exception.DatastoreExceptionHelper;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.storage.onestore.v3.OnestoreEntity;

public class PropertyHelper {
    private static OnestoreEntity.PropertyValue addRawProperty(OnestoreEntity.EntityProto proto, String propertyName) {
        return proto.addRawProperty().setName(propertyName).setMultiple(false).getMutableValue();
    }

    public static void addRawProperty(OnestoreEntity.EntityProto proto, String propertyName, long value) {
        OnestoreEntity.PropertyValue newValue = PropertyHelper.addRawProperty(proto, propertyName);
        newValue.setInt64Value(value);
    }

    public static void addRawProperty(OnestoreEntity.EntityProto proto, String propertyName, String value) {
        OnestoreEntity.PropertyValue newValue = PropertyHelper.addRawProperty(proto, propertyName);
        newValue.setStringValue(value);
    }

    private static OnestoreEntity.PropertyValue addProperty(OnestoreEntity.EntityProto proto, String propertyName) {
        return proto.addProperty().setName(propertyName).setMultiple(false).getMutableValue();
    }

    public static void addProperty(OnestoreEntity.EntityProto proto, String propertyName, boolean value) {
        OnestoreEntity.PropertyValue newValue = PropertyHelper.addProperty(proto, propertyName);
        newValue.setBooleanValue(value);
    }

    public static void addProperty(OnestoreEntity.EntityProto proto, String propertyName, long value) {
        OnestoreEntity.PropertyValue newValue = PropertyHelper.addProperty(proto, propertyName);
        newValue.setInt64Value(value);
    }

    public static void addProperty(OnestoreEntity.EntityProto proto, String propertyName, OnestoreEntity.PropertyValue value) {
        PropertyHelper.addProperty(proto, propertyName).copyFrom(value);
    }

    public static void addProperty(OnestoreEntity.EntityProto proto, String propertyName, OnestoreEntity.EntityProto embedded) {
        proto.addProperty().setName(propertyName).setMultiple(false).setMeaning(OnestoreEntity.Property.Meaning.ENTITY_PROTO).getMutableValue().setStringValueAsBytes(embedded.toByteArray());
    }

    public static OnestoreEntity.Property findProperty(OnestoreEntity.EntityProto proto, String propertyName) throws DatastoreException {
        Optional<OnestoreEntity.Property> result = PropertyHelper.tryFindProperty(proto, propertyName);
        if (!result.isPresent()) {
            String string = String.valueOf(propertyName);
            throw DatastoreExceptionHelper.internalError(string.length() != 0 ? "Cannot find property: ".concat(string) : new String("Cannot find property: "), new Throwable());
        }
        return result.get();
    }

    private static OnestoreEntity.Property findRawProperty(OnestoreEntity.EntityProto proto, String propertyName) throws DatastoreException {
        Optional<OnestoreEntity.Property> result = PropertyHelper.tryFindRawProperty(proto, propertyName);
        if (!result.isPresent()) {
            String string = String.valueOf(propertyName);
            throw DatastoreExceptionHelper.internalError(string.length() != 0 ? "Cannot find property: ".concat(string) : new String("Cannot find property: "), new Throwable());
        }
        return result.get();
    }

    public static Optional<OnestoreEntity.Property> tryFindProperty(OnestoreEntity.EntityProto proto, String propertyName) {
        return Iterables.tryFind(proto.propertys(), input -> input.getName().equals(propertyName));
    }

    public static Optional<OnestoreEntity.Property> tryFindRawProperty(OnestoreEntity.EntityProto proto, String propertyName) {
        return Iterables.tryFind(proto.rawPropertys(), input -> input.getName().equals(propertyName));
    }

    public static Optional<Long> tryGetLongProperty(OnestoreEntity.EntityProto proto, String propertyName) throws DatastoreException {
        Optional<OnestoreEntity.Property> result = PropertyHelper.tryFindRawProperty(proto, propertyName);
        if (!result.isPresent()) {
            return Optional.absent();
        }
        Preconditions.checkState(result.get().getValue().hasInt64Value(), "Property %s should have a Int64Value", (Object)propertyName);
        return Optional.of(result.get().getValue().getInt64Value());
    }

    public static long getLongProperty(OnestoreEntity.EntityProto proto, String propertyName) throws DatastoreException {
        return PropertyHelper.tryGetLongProperty(proto, propertyName).get();
    }

    public static String getStringProperty(OnestoreEntity.EntityProto proto, String propertyName) throws DatastoreException {
        OnestoreEntity.Property result = PropertyHelper.findRawProperty(proto, propertyName);
        Preconditions.checkState(result.getValue().hasStringValue(), "Property %s should have a StringValue", (Object)propertyName);
        return result.getValue().getStringValue();
    }
}

