/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.appengv3.converter;

import com.google.cloud.datastore.core.appengv3.converter.AppEngV3ResourceRefFromRepConverter;
import com.google.cloud.datastore.core.appengv3.converter.base.AppEngV3EntityFromRepConverterInterface;
import com.google.cloud.datastore.core.exception.InvalidConversionException;
import com.google.cloud.datastore.core.rep.Entity;
import com.google.cloud.datastore.core.rep.EntityRef;
import com.google.cloud.datastore.core.rep.V3Paths;
import com.google.cloud.datastore.core.rep.Value;
import com.google.cloud.datastore.core.rep.converter.ConverterHelper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.Timestamp;
import com.google.storage.onestore.v3.OnestoreEntity;
import com.google.type.LatLng;
import java.util.Map;

public class AppEngV3EntityFromRepConverter
implements AppEngV3EntityFromRepConverterInterface {
    public static final AppEngV3EntityFromRepConverter INSTANCE = new AppEngV3EntityFromRepConverter();

    private AppEngV3EntityFromRepConverter() {
    }

    public OnestoreEntity.EntityProto convertEntityUnchecked(Entity entity) {
        try {
            return this.convertEntity(entity);
        }
        catch (InvalidConversionException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public OnestoreEntity.EntityProto convertEntity(Entity entity) throws InvalidConversionException {
        OnestoreEntity.EntityProto v3Entity = this.convertMapToEntity(entity.propertyMap());
        OnestoreEntity.Reference v3EntityRef = AppEngV3ResourceRefFromRepConverter.INSTANCE.convertEntityRef(entity.ref());
        v3Entity.setKey(v3EntityRef);
        OnestoreEntity.Path v3EntityRefPath = v3EntityRef.getPath();
        if (v3EntityRefPath.elementSize() == 1 && V3Paths.hasIdOrName(v3EntityRefPath)) {
            v3Entity.setEntityGroup(v3EntityRefPath);
        } else if (v3EntityRefPath.elementSize() > 1) {
            OnestoreEntity.Path v3EntityGroup = new OnestoreEntity.Path();
            v3EntityGroup.addElement(v3EntityRefPath.getElement(0));
            v3Entity.setEntityGroup(v3EntityGroup);
        }
        return v3Entity;
    }

    private OnestoreEntity.EntityProto convertMapToEntity(ImmutableMap<String, Value> map) throws InvalidConversionException {
        OnestoreEntity.EntityProto v3Entity = new OnestoreEntity.EntityProto();
        for (Map.Entry entry : map.entrySet()) {
            String propertyName = (String)entry.getKey();
            Value value = (Value)entry.getValue();
            this.addProperty(propertyName, value, v3Entity);
        }
        return v3Entity;
    }

    private void addProperty(String propertyName, Value value, OnestoreEntity.EntityProto v3Entity) throws InvalidConversionException {
        byte[] propertyNameByteArray = ConverterHelper.convertStringToBytes("property name", propertyName);
        if (value.type() == Value.Type.ARRAY) {
            ImmutableList<Value> values = value.asArray();
            if (values.isEmpty()) {
                this.addSingleProperty(propertyNameByteArray, value, false, v3Entity);
            } else {
                for (Value elementValue : values) {
                    InvalidConversionException.checkConversion(elementValue.type() != Value.Type.ARRAY, "Cannot convert an array value in an array value.", new Object[0]);
                    this.addSingleProperty(propertyNameByteArray, elementValue, true, v3Entity);
                }
            }
        } else {
            this.addSingleProperty(propertyNameByteArray, value, false, v3Entity);
        }
    }

    private void addSingleProperty(byte[] propertyNameByteArray, Value value, boolean inArray, OnestoreEntity.EntityProto v3Entity) throws InvalidConversionException {
        OnestoreEntity.Property v3Property = this.convertValue(value);
        v3Property.setNameAsBytes(propertyNameByteArray);
        v3Property.setMultiple(inArray);
        if (value.isDatastoreIndexed()) {
            v3Entity.addProperty(v3Property);
        } else {
            v3Entity.addRawProperty(v3Property);
        }
    }

    @Override
    public OnestoreEntity.Property convertValueUnchecked(Value value) {
        try {
            return this.convertValue(value);
        }
        catch (InvalidConversionException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public OnestoreEntity.Property convertValue(Value value) throws InvalidConversionException {
        Value.Meaning meaning = value.meaning();
        OnestoreEntity.Property v3Property = new OnestoreEntity.Property();
        OnestoreEntity.PropertyValue v3PropertyValue = v3Property.getMutableValue();
        switch (meaning) {
            case NONE: 
            case NON_UTF8_BLOB_WITH_APP_ENG_V3_MEANING_NONE: 
            case GEO_POINT_WITHOUT_APP_ENG_V3_MEANING: {
                v3Property.setMeaning(OnestoreEntity.Property.Meaning.NO_MEANING);
                break;
            }
            case NON_UTF8_BLOB_WITH_APP_ENG_V3_MEANING_TEXT: {
                v3Property.setMeaning(OnestoreEntity.Property.Meaning.TEXT);
                break;
            }
            case URI_MEANING_ZLIB: {
                v3Property.setMeaning(OnestoreEntity.Property.Meaning.BLOB);
                v3Property.setMeaningUri("ZLIB");
                break;
            }
            default: {
                v3Property.setMeaning(OnestoreEntity.Property.Meaning.valueOf(meaning.ordinal()));
            }
        }
        switch (value.type()) {
            case NULL: {
                break;
            }
            case BOOLEAN: {
                v3PropertyValue.setBooleanValue(value.asBoolean());
                break;
            }
            case LONG: {
                v3PropertyValue.setInt64Value(value.asLong());
                break;
            }
            case DOUBLE: {
                v3PropertyValue.setDoubleValue(value.asDouble());
                break;
            }
            case TIMESTAMP: {
                Timestamp timestamp = value.asTimestamp();
                long microseconds = ConverterHelper.timestampToMicrosecondsLossy(timestamp);
                v3PropertyValue.setInt64Value(microseconds);
                v3Property.setMeaning(OnestoreEntity.Property.Meaning.GD_WHEN);
                break;
            }
            case RESOURCE_REF: {
                throw new InvalidConversionException("Non-document resource reference value not supported.");
            }
            case ENTITY_REF: {
                EntityRef entityRef = value.asEntityRef();
                v3PropertyValue.setReferenceValue(AppEngV3ResourceRefFromRepConverter.INSTANCE.convertEntityRefForValue(entityRef));
                break;
            }
            case STRING: {
                v3PropertyValue.setStringValue(value.asString());
                break;
            }
            case BYTES: {
                v3PropertyValue.setStringValueAsBytes(value.asBytes().toByteArray());
                if (meaning != Value.Meaning.NONE) break;
                v3Property.setMeaning(value.isDatastoreIndexed() ? OnestoreEntity.Property.Meaning.BYTESTRING : OnestoreEntity.Property.Meaning.BLOB);
                break;
            }
            case GEO_POINT: {
                LatLng geoPoint = value.asGeoPoint();
                OnestoreEntity.PropertyValue.PointValue v3GeoPoint = new OnestoreEntity.PropertyValue.PointValue();
                v3GeoPoint.setX(geoPoint.getLatitude());
                v3GeoPoint.setY(geoPoint.getLongitude());
                v3PropertyValue.setPointValue(v3GeoPoint);
                if (meaning != Value.Meaning.NONE) break;
                v3Property.setMeaning(OnestoreEntity.Property.Meaning.GEORSS_POINT);
                break;
            }
            case MAP: {
                ImmutableMap<String, Value> map = value.asMap();
                OnestoreEntity.EntityProto v3MapEntity = this.convertMapToEntity(map);
                if (value.unknownFieldSet() != null) {
                    v3MapEntity.setUnknownFields(value.unknownFieldSet());
                }
                v3PropertyValue.setStringValueAsBytes(v3MapEntity.toByteArray());
                v3Property.setMeaning(OnestoreEntity.Property.Meaning.ENTITY_PROTO);
                break;
            }
            case ENTITY: {
                Entity entity = value.asEntity();
                OnestoreEntity.EntityProto v3Entity = this.convertEntity(entity);
                if (value.unknownFieldSet() != null) {
                    v3Entity.setUnknownFields(value.unknownFieldSet());
                }
                v3PropertyValue.setStringValueAsBytes(v3Entity.toByteArray());
                v3Property.setMeaning(OnestoreEntity.Property.Meaning.ENTITY_PROTO);
                break;
            }
            case ARRAY: {
                InvalidConversionException.checkConversion(value.asArray().isEmpty(), "OnestoreEntity.PropertyValue cannot represent a non-empty array value.", new Object[0]);
                v3Property.setMeaning(OnestoreEntity.Property.Meaning.EMPTY_LIST);
                break;
            }
            case LEGACY_USER: {
                Value.LegacyUser user = value.asLegacyUser();
                v3PropertyValue.setUserValue(this.convertLegacyUserValue(user));
                break;
            }
            case LEGACY_TIMESTAMP_MICROSECONDS: {
                long legacyTimestampMicroseconds = value.asLegacyTimestampMicroseconds();
                v3PropertyValue.setInt64Value(legacyTimestampMicroseconds);
                v3Property.setMeaning(OnestoreEntity.Property.Meaning.GD_WHEN);
                break;
            }
            default: {
                throw new InvalidConversionException("Unknown value type.");
            }
        }
        if (v3Property.getMeaningEnum() == OnestoreEntity.Property.Meaning.NO_MEANING) {
            v3Property.clearMeaning();
        }
        return v3Property;
    }

    public ImmutableList<OnestoreEntity.Property> convertProperties(ImmutableMap<String, Value> properties) throws InvalidConversionException {
        ImmutableList.Builder result = ImmutableList.builder();
        for (Map.Entry entry : properties.entrySet()) {
            OnestoreEntity.Property property = this.convertValue((Value)entry.getValue());
            property.setName((String)entry.getKey());
            result.add(property);
        }
        return result.build();
    }

    private OnestoreEntity.PropertyValue.UserValue convertLegacyUserValue(Value.LegacyUser user) {
        OnestoreEntity.PropertyValue.UserValue v3User = new OnestoreEntity.PropertyValue.UserValue();
        v3User.setEmail(user.email());
        v3User.setAuthDomain(user.authDomain());
        v3User.setGaiaid(0L);
        if (!user.obfuscatedGaiaId().isEmpty()) {
            v3User.setObfuscatedGaiaid(user.obfuscatedGaiaId());
        }
        if (user.federatedIdentity() != null) {
            v3User.setFederatedIdentity(user.federatedIdentity());
        }
        if (user.federatedProvider() != null) {
            v3User.setFederatedProvider(user.federatedProvider());
        }
        return v3User;
    }
}

