/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.appengv3.converter;

import com.google.apphosting.datastore.DatastoreV3Pb;
import com.google.cloud.datastore.core.appengv3.AppEngV3DatabaseRefExtractor;
import com.google.cloud.datastore.core.appengv3.converter.AppEngV3QueryFromRepConverter;
import com.google.cloud.datastore.core.appengv3.converter.IndexAppEngV3FromRepConverter;
import com.google.cloud.datastore.core.exception.InvalidConversionException;
import com.google.cloud.datastore.core.rep.BufferedWriteResult;
import com.google.cloud.datastore.core.rep.DatabaseRef;
import com.google.cloud.datastore.core.rep.Index;
import com.google.cloud.datastore.core.rep.LookupResults;
import com.google.cloud.datastore.core.rep.MutationResult;
import com.google.cloud.datastore.core.rep.PrepareQueryResult;
import com.google.cloud.datastore.core.rep.QueryResults;
import com.google.cloud.datastore.core.rep.ReadResult;
import com.google.cloud.datastore.core.rep.WriteResult;
import com.google.cloud.datastore.core.rep.WriteStats;
import com.google.datastore.v1.QueryResultBatch;

public class AppEngV3FromRepConverter {
    public static final AppEngV3FromRepConverter INSTANCE = new AppEngV3FromRepConverter();

    private AppEngV3FromRepConverter() {
    }

    public DatastoreV3Pb.GetResponse toV3GetResponse(LookupResults lookupResults) {
        DatastoreV3Pb.GetResponse response = new DatastoreV3Pb.GetResponse();
        response.setInOrder(lookupResults.inOrder());
        for (ReadResult readResult : lookupResults.results()) {
            if (readResult.missingEntityReason() == ReadResult.MissingEntityReason.DEFERRED) {
                response.addDeferred(readResult.reference());
                continue;
            }
            DatastoreV3Pb.GetResponse.Entity entity = response.addEntity();
            if (readResult.exists()) {
                entity.setEntity(readResult.entity());
            } else {
                entity.setKey(readResult.reference());
            }
            if (readResult.updateVersion() == -1L) continue;
            entity.setVersion(readResult.updateVersion());
        }
        return response;
    }

    public DatastoreV3Pb.CommitResponse toV3CommitResponse(WriteResult writeResult) {
        DatastoreV3Pb.CommitResponse res = new DatastoreV3Pb.CommitResponse().setCost(this.toV3Cost(writeResult.stats(), true));
        for (MutationResult result : writeResult.collapsedMutationResults()) {
            res.addVersion().setRootEntityKey(result.key()).setVersion(result.updateVersion());
        }
        return res;
    }

    public DatastoreV3Pb.PutResponse toV3PutResponse(WriteResult writeResult) {
        DatastoreV3Pb.PutResponse response = new DatastoreV3Pb.PutResponse();
        for (MutationResult result : writeResult.mutationResults()) {
            response.mutableKeys().add(result.key());
            response.addVersion(result.updateVersion());
        }
        response.setCost(this.toV3Cost(writeResult.stats(), false));
        return response;
    }

    public DatastoreV3Pb.PutResponse toV3PutResponse(BufferedWriteResult result) {
        DatastoreV3Pb.PutResponse response = new DatastoreV3Pb.PutResponse();
        response.mutableKeys().addAll(result.keys());
        return response;
    }

    public DatastoreV3Pb.DeleteResponse toV3DeleteResponse(WriteResult writeResult) {
        DatastoreV3Pb.DeleteResponse response = new DatastoreV3Pb.DeleteResponse();
        response.setCost(this.toV3Cost(writeResult.stats(), false));
        for (MutationResult result : writeResult.mutationResults()) {
            response.addVersion(result.updateVersion());
        }
        return response;
    }

    public DatastoreV3Pb.Cost toV3Cost(WriteStats stats, boolean includeCommitCost) {
        DatastoreV3Pb.Cost cost = new DatastoreV3Pb.Cost();
        cost.setIndexWrites(stats.indexWrites());
        cost.setIndexWriteBytes(stats.indexWriteBytes());
        cost.setEntityWrites(stats.entityWrites());
        cost.setEntityWriteBytes(stats.entityWriteBytes());
        if (includeCommitCost) {
            DatastoreV3Pb.Cost.CommitCost commitCost = cost.getMutableCommitCost();
            commitCost.setRequestedEntityPuts(stats.requestedPuts());
            commitCost.setRequestedEntityDeletes(stats.requestedDeletes());
        }
        cost.setApproximateStorageDelta((int)stats.approximateStorageDelta());
        cost.setIdSequenceUpdates(stats.idSequenceUpdates());
        return cost;
    }

    private DatastoreV3Pb.CompiledQuery correctCompiledQuery(DatastoreV3Pb.Query original, DatastoreV3Pb.CompiledQuery compiledQuery) {
        compiledQuery = ((DatastoreV3Pb.CompiledQuery)compiledQuery.clone()).clearLimit();
        compiledQuery.setKeysOnly(original.isKeysOnly());
        if (original.hasOffset()) {
            compiledQuery.setOffset(original.getOffset());
        }
        if (original.hasLimit()) {
            compiledQuery.setLimit(original.getLimit());
        }
        return compiledQuery;
    }

    public DatastoreV3Pb.QueryResult toV3NextResult(DatastoreV3Pb.NextRequest original, QueryResults internalResult) throws InvalidConversionException {
        DatastoreV3Pb.QueryResult result = this.toV3QueryResultBatch(internalResult);
        if (result.isMoreResults()) {
            result.setCursor(original.getCursor());
        }
        return result;
    }

    private DatastoreV3Pb.QueryResult toV3QueryResultBatch(QueryResults internalResult) throws InvalidConversionException {
        DatastoreV3Pb.QueryResult result = new DatastoreV3Pb.QueryResult();
        result.setSkippedResults(internalResult.skippedResults());
        if (internalResult.skippedCursor() != null) {
            result.setSkippedResultsCompiledCursor(AppEngV3QueryFromRepConverter.INSTANCE.convertCursor(internalResult.skippedCursor(), internalResult.query().firstSortDirection()));
        }
        for (ReadResult readResult : internalResult.readResults()) {
            result.addResult(readResult.entity());
            if (readResult.updateVersion() != -1L) {
                result.addVersion(readResult.updateVersion());
            }
            if (readResult.cursor() == null) continue;
            result.addResultCompiledCursor(AppEngV3QueryFromRepConverter.INSTANCE.convertCursor(readResult.cursor(), internalResult.query().firstSortDirection()));
        }
        if (internalResult.endCursor() != null) {
            result.setCompiledCursor(AppEngV3QueryFromRepConverter.INSTANCE.convertCursor(internalResult.endCursor(), internalResult.query().firstSortDirection()));
        }
        result.setMoreResults(internalResult.moreResults() == QueryResultBatch.MoreResultsType.NOT_FINISHED);
        result.setKeysOnly(internalResult.query().hasOnlyKeys());
        result.setIndexOnly(internalResult.query().isIndexOnly());
        result.setSmallOps(internalResult.query().isSmallOps());
        return result;
    }

    public DatastoreV3Pb.QueryResult toV3RunQueryResult(DatabaseRef databaseRef, DatastoreV3Pb.Query original, PrepareQueryResult prepareQueryResult, QueryResults queryResults) throws InvalidConversionException {
        DatastoreV3Pb.QueryResult result = this.toV3QueryResultBatch(queryResults);
        if (queryResults.query().compiledQuery() != null) {
            result.setCompiledQuery(this.correctCompiledQuery(original, queryResults.query().compiledQuery()));
        }
        for (Index index : prepareQueryResult.indexes()) {
            result.addIndex(IndexAppEngV3FromRepConverter.INSTANCE.convertIndex(databaseRef, index));
        }
        if (result.isMoreResults()) {
            AppEngV3DatabaseRefExtractor.set(result.getMutableCursor(), databaseRef).setCursor(prepareQueryResult.handle());
        }
        return result;
    }
}

