/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.appengv3.converter;

import com.google.apphosting.datastore.DatastoreV3Pb;
import com.google.apphosting.datastore.shared.Config;
import com.google.cloud.datastore.core.appengv3.AppEngV3DatabaseRefExtractor;
import com.google.cloud.datastore.core.appengv3.UserValueObfuscator;
import com.google.cloud.datastore.core.appengv3.converter.AppEngV3EntityToRepConverter;
import com.google.cloud.datastore.core.appengv3.converter.AppEngV3ResourceRefToRepConverter;
import com.google.cloud.datastore.core.appengv3.converter.CompiledCursorUtil;
import com.google.cloud.datastore.core.config.proto1api.DatastoreCustomizableConfigPb;
import com.google.cloud.datastore.core.exception.InvalidConversionException;
import com.google.cloud.datastore.core.rep.Condition;
import com.google.cloud.datastore.core.rep.Cursor;
import com.google.cloud.datastore.core.rep.DatabaseRef;
import com.google.cloud.datastore.core.rep.Direction;
import com.google.cloud.datastore.core.rep.EntityRef;
import com.google.cloud.datastore.core.rep.GeoRegion;
import com.google.cloud.datastore.core.rep.IdAllocationPolicy;
import com.google.cloud.datastore.core.rep.LogicalCondition;
import com.google.cloud.datastore.core.rep.Lookup;
import com.google.cloud.datastore.core.rep.Mutation;
import com.google.cloud.datastore.core.rep.PartitionRef;
import com.google.cloud.datastore.core.rep.PropertyCondition;
import com.google.cloud.datastore.core.rep.PropertyMask;
import com.google.cloud.datastore.core.rep.PropertyPath;
import com.google.cloud.datastore.core.rep.PropertyPathWithDirection;
import com.google.cloud.datastore.core.rep.PropertyValueCondition;
import com.google.cloud.datastore.core.rep.Query;
import com.google.cloud.datastore.core.rep.QueryScope;
import com.google.cloud.datastore.core.rep.TransactionOptions;
import com.google.cloud.datastore.core.rep.UnifiedIndexValue;
import com.google.cloud.datastore.core.rep.Value;
import com.google.cloud.datastore.core.rep.Write;
import com.google.cloud.datastore.core.rep.converter.ConverterHelper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.storage.onestore.v3.OnestoreEntity;
import com.google.type.LatLng;
import java.util.List;
import javax.annotation.Nullable;

public class AppEngV3ToRepConverter {
    private final UserValueObfuscator userValueObfuscator;
    private final AppEngV3ResourceRefToRepConverter appEngV3ResourceRefToRepConverter;
    private final AppEngV3EntityToRepConverter entityToRepConverter;

    public AppEngV3ToRepConverter(Config.DatastoreConfig config, UserValueObfuscator userValueObfuscator, AppEngV3ResourceRefToRepConverter appEngV3ResourceRefToRepConverter, AppEngV3EntityToRepConverter entityToRepConverter) {
        this.userValueObfuscator = userValueObfuscator;
        this.appEngV3ResourceRefToRepConverter = appEngV3ResourceRefToRepConverter;
        this.entityToRepConverter = entityToRepConverter;
    }

    public Query convertQueryNoIndexes(DatastoreV3Pb.Query v3Query, PropertyMask propertyMask, @Nullable DatastoreCustomizableConfigPb.DatastoreCustomizableConfig configOverrides) throws InvalidConversionException {
        v3Query = (DatastoreV3Pb.Query)v3Query.clone();
        try {
            CompiledCursorUtil.modernizeQueryCursors(v3Query);
            CompiledCursorUtil.unobfuscateQueryCursors(v3Query, this.userValueObfuscator);
        }
        catch (InvalidConversionException exception) {
            String string = String.valueOf(exception.getMessage());
            throw new InvalidConversionException(string.length() != 0 ? "Invalid cursor: ".concat(string) : new String("Invalid cursor: "), exception);
        }
        Query.Builder builder = Query.builder().scope(this.convertQueryScope(v3Query)).isShallow(v3Query.isShallow()).condition(this.convertConditions(v3Query.filters(), configOverrides)).orderBy(this.convertOrderBy(v3Query.orders())).groupBy(this.convertPropertyPaths(v3Query.groupByPropertyNamesAsBytes())).projection(this.convertPropertyPaths(v3Query.propertyNamesAsBytes())).selectOnlyKeys(v3Query.isKeysOnly()).offset(v3Query.getOffset()).propertyMask(propertyMask);
        if (v3Query.hasKind()) {
            builder.kind(v3Query.getKind());
        }
        if (v3Query.hasAncestor()) {
            builder.ancestor(this.appEngV3ResourceRefToRepConverter.convertEntityRef(v3Query.getAncestor(), configOverrides));
        }
        if (v3Query.hasDistinct()) {
            builder.allowDuplicateResults(!v3Query.isDistinct());
        } else {
            builder.allowDuplicateResults(!v3Query.propertyNames().isEmpty());
        }
        if (v3Query.hasCompiledCursor()) {
            builder.startCursor(this.toCursor(v3Query.getCompiledCursor(), configOverrides));
        }
        if (v3Query.hasEndCompiledCursor()) {
            builder.endCursor(this.toCursor(v3Query.getEndCompiledCursor(), configOverrides));
        }
        if (v3Query.hasLimit()) {
            builder.limit(v3Query.getLimit());
        }
        return builder.build();
    }

    public Lookup toLookup(DatastoreV3Pb.GetRequest request) throws InvalidConversionException {
        Lookup.Builder builder = Lookup.builder().keys(request.keys()).allowFailover(request.hasFailoverMs()).allowDefer(request.isAllowDeferred()).isStrong(request.hasTransaction() || !request.hasStrong() || request.isStrong());
        return builder.build();
    }

    public Write.Builder toWriteNoIndexes(DatastoreV3Pb.PutRequest request) throws InvalidConversionException {
        this.validateSequenceNumber(request.getSequenceNumber());
        ImmutableList.Builder internalMutationList = ImmutableList.builder();
        for (OnestoreEntity.EntityProto entity : request.entitys()) {
            internalMutationList.add(Mutation.upsert(entity).sequenceNumber(request.getSequenceNumber()).build());
        }
        Write.Builder builder = Write.builder().mutations(internalMutationList.build()).markChanges(!request.hasTransaction() && request.isMarkChanges()).isTrusted(request.isTrusted());
        builder.idPolicy(request.getAutoIdPolicyEnum() == DatastoreV3Pb.PutRequest.AutoIdPolicy.SEQUENTIAL ? IdAllocationPolicy.SEQUENTIAL : null);
        return builder;
    }

    public Write.Builder toWriteNoIndexes(DatastoreV3Pb.Transaction request) {
        Write.Builder builder = Write.builder();
        builder.mutations(ImmutableList.of());
        builder.markChanges(request.isMarkChanges());
        return builder;
    }

    public Write.Builder toWriteNoIndexes(DatastoreV3Pb.DeleteRequest request) throws InvalidConversionException {
        Write.Builder builder = Write.builder();
        if (!request.hasTransaction()) {
            builder.markChanges(request.isMarkChanges());
        }
        this.validateSequenceNumber(request.getSequenceNumber());
        ImmutableList.Builder internalMutationList = ImmutableList.builder();
        for (OnestoreEntity.Reference reference : request.keys()) {
            internalMutationList.add(Mutation.delete(reference).sequenceNumber(request.getSequenceNumber()).build());
        }
        builder.mutations(internalMutationList.build());
        builder.isTrusted(request.isTrusted());
        return builder;
    }

    private void validateSequenceNumber(long sequenceNumber) throws InvalidConversionException {
        if (sequenceNumber < 0L) {
            throw new InvalidConversionException(String.format("Sequence number cannot be negative. Input sequence number is %d.", sequenceNumber));
        }
    }

    public TransactionOptions toTransactionOptions(DatastoreV3Pb.BeginTransactionRequest request) throws InvalidConversionException {
        TransactionOptions.Builder builder = TransactionOptions.builder().allowMultipleEg(request.isAllowMultipleEg()).mode(this.toTransactionOptionsMode(request.getModeEnum()));
        if (request.hasPreviousTransaction()) {
            builder.previousTransactionHandle(request.getPreviousTransaction().getHandle());
        }
        return builder.build();
    }

    private TransactionOptions.Mode toTransactionOptionsMode(DatastoreV3Pb.BeginTransactionRequest.TransactionMode transactionMode) throws InvalidConversionException {
        switch (transactionMode) {
            case UNKNOWN: {
                return TransactionOptions.Mode.UNSPECIFIED;
            }
            case READ_ONLY: {
                return TransactionOptions.Mode.READ_ONLY;
            }
            case READ_WRITE: {
                return TransactionOptions.Mode.READ_WRITE;
            }
        }
        throw InvalidConversionException.unrecognizedEnumValue("transaction mode", transactionMode);
    }

    @VisibleForTesting
    public QueryScope convertQueryScope(DatastoreV3Pb.Query v3Query) throws InvalidConversionException {
        PartitionRef partition = PartitionRef.createFromDatabaseRefAndNamespace((DatabaseRef)AppEngV3DatabaseRefExtractor.INSTANCE.extractValidated(v3Query), v3Query.getNameSpace());
        ImmutableList<String> safeReplicaNames = v3Query.hasMinSafeTimeSeconds() ? ImmutableList.copyOf(v3Query.safeReplicaNames()) : null;
        QueryScope.Builder scopeBuilder = QueryScope.builder().partition(partition).safeReplicaNames(safeReplicaNames).isStrong(v3Query.hasTransaction() && v3Query.getTransaction().getHandle() != 0L || (v3Query.hasStrong() ? v3Query.isStrong() : v3Query.hasAncestor())).isVeryInconsistent(v3Query.hasFailoverMs());
        if (v3Query.hasHint()) {
            scopeBuilder.hint(v3Query.getHintEnum());
        }
        if (v3Query.hasCount()) {
            scopeBuilder.batchSize(v3Query.getCount());
        }
        return scopeBuilder.build();
    }

    @Nullable
    @VisibleForTesting
    Condition convertConditions(List<DatastoreV3Pb.Query.Filter> filters, @Nullable DatastoreCustomizableConfigPb.DatastoreCustomizableConfig configOverrides) throws InvalidConversionException {
        if (filters.isEmpty()) {
            return null;
        }
        if (filters.size() == 1) {
            return this.convertCondition(filters.get(0), configOverrides);
        }
        ImmutableList.Builder subConditionsBuilder = ImmutableList.builder();
        for (DatastoreV3Pb.Query.Filter filter : filters) {
            subConditionsBuilder.add(this.convertCondition(filter, configOverrides));
        }
        return LogicalCondition.create(Condition.Op.AND, (ImmutableList<Condition>)subConditionsBuilder.build());
    }

    @VisibleForTesting
    Condition convertCondition(DatastoreV3Pb.Query.Filter v3Filter, @Nullable DatastoreCustomizableConfigPb.DatastoreCustomizableConfig configOverrides) throws InvalidConversionException {
        Condition.Op op;
        boolean expectV3Value = true;
        boolean expectV3GeoRegion = false;
        if (!v3Filter.hasOp()) {
            throw new InvalidConversionException("missing filter operator");
        }
        switch (v3Filter.getOpEnum()) {
            case LESS_THAN: {
                op = Condition.Op.LT;
                break;
            }
            case LESS_THAN_OR_EQUAL: {
                op = Condition.Op.LE;
                break;
            }
            case GREATER_THAN: {
                op = Condition.Op.GT;
                break;
            }
            case GREATER_THAN_OR_EQUAL: {
                op = Condition.Op.GE;
                break;
            }
            case IN: 
            case EQUAL: {
                op = Condition.Op.EQ;
                break;
            }
            case EXISTS: {
                expectV3Value = false;
                op = Condition.Op.EXISTS;
                break;
            }
            case CONTAINED_IN_REGION: {
                expectV3Value = false;
                expectV3GeoRegion = true;
                op = Condition.Op.GEO_IN;
                break;
            }
            default: {
                throw new Error("unknown filter op");
            }
        }
        if (v3Filter.propertySize() != 1) {
            throw new InvalidConversionException(v3Filter.propertySize() == 0 ? "filter.property required" : "multiple filter.property");
        }
        OnestoreEntity.Property v3Property = v3Filter.getProperty(0);
        PropertyPath propertyPath = this.convertPropertyPath(v3Property.getNameAsBytes());
        OnestoreEntity.PropertyValue v3Value = v3Property.getValue();
        InvalidConversionException.checkConversion(!v3Property.hasStashed(), "Property \"%s\" has field stashed", propertyPath.asStringLossy());
        InvalidConversionException.checkConversion(!v3Property.hasComputed(), "Property \"%s\" has field computed", propertyPath.asStringLossy());
        InvalidConversionException.checkConversion(expectV3Value || v3Value.equals(OnestoreEntity.PropertyValue.IMMUTABLE_DEFAULT_INSTANCE), "Filter property \"%s\" has unexpected value", propertyPath.asStringLossy());
        InvalidConversionException.checkConversion(expectV3GeoRegion == v3Filter.hasGeoRegion(), "Filter property \"%s\" %s geo region", propertyPath.asStringLossy(), expectV3GeoRegion ? "missing" : "has unexpected");
        Value value = expectV3Value ? this.entityToRepConverter.convertValueForQueryCondition(v3Property.getValue(), configOverrides) : (expectV3GeoRegion ? Value.createGeoRegion(this.toGeoRegion(v3Filter.getGeoRegion())) : null);
        PropertyCondition result = op == Condition.Op.EXISTS ? PropertyCondition.create(op, propertyPath) : PropertyValueCondition.create(op, propertyPath, value);
        return result;
    }

    private GeoRegion toGeoRegion(DatastoreV3Pb.GeoRegion geoRegion) throws InvalidConversionException {
        InvalidConversionException.checkConversion(geoRegion.hasCircle() ^ geoRegion.hasRectangle(), "GeoRegion must have either Circle or Rectangle", new Object[0]);
        if (geoRegion.hasRectangle()) {
            return GeoRegion.rectangle(GeoRegion.Rectangle.of(this.toLatLng(geoRegion.getRectangle().getSouthwest()), this.toLatLng(geoRegion.getRectangle().getNortheast())));
        }
        return GeoRegion.circle(GeoRegion.Circle.of(this.toLatLng(geoRegion.getCircle().getCenter()), geoRegion.getCircle().getRadiusMeters()));
    }

    private LatLng toLatLng(DatastoreV3Pb.RegionPoint regionPoint) {
        return LatLng.newBuilder().setLatitude(regionPoint.getLatitude()).setLongitude(regionPoint.getLongitude()).build();
    }

    @VisibleForTesting
    public ImmutableList<PropertyPathWithDirection> convertOrderBy(List<DatastoreV3Pb.Query.Order> v3OrderBy) throws InvalidConversionException {
        ImmutableList.Builder orderByBuilder = ImmutableList.builder();
        for (DatastoreV3Pb.Query.Order v3Order : v3OrderBy) {
            PropertyPath propertyPath = this.convertPropertyPath(v3Order.getPropertyAsBytes());
            Direction direction = v3Order.getDirectionEnum() == DatastoreV3Pb.Query.Order.Direction.DESCENDING ? Direction.DESCENDING : Direction.ASCENDING;
            PropertyPathWithDirection propertyPathWithDirection = PropertyPathWithDirection.create(propertyPath, direction);
            orderByBuilder.add(propertyPathWithDirection);
        }
        return orderByBuilder.build();
    }

    @VisibleForTesting
    public ImmutableList<PropertyPath> convertPropertyPaths(List<byte[]> propertyPathByteArrays) throws InvalidConversionException {
        ImmutableList.Builder propertyPathsBuilder = ImmutableList.builder();
        for (byte[] propertyPathByteArray : propertyPathByteArrays) {
            propertyPathsBuilder.add(this.convertPropertyPath(propertyPathByteArray));
        }
        return propertyPathsBuilder.build();
    }

    private PropertyPath convertPropertyPath(byte[] v3PropertyPathBytes) throws InvalidConversionException {
        String v3PropertyPathString = ConverterHelper.convertUtf8("Property path", "", v3PropertyPathBytes);
        return PropertyPath.createFromAmbiguousPathString(v3PropertyPathString);
    }

    public Cursor toCursor(DatastoreV3Pb.CompiledCursor v3Cursor, @Nullable DatastoreCustomizableConfigPb.DatastoreCustomizableConfig configOverrides) throws InvalidConversionException {
        InvalidConversionException.checkConversion(!v3Cursor.hasPosition(), "Cannot convert a non-normalized cursor.", new Object[0]);
        InvalidConversionException.checkConversion(!v3Cursor.hasPostfixPosition() || !v3Cursor.hasAbsolutePosition(), "Cursors cannot specify both postfix and absolute positions.", new Object[0]);
        if (v3Cursor.hasAbsolutePosition()) {
            OnestoreEntity.IndexPosition v3Position = v3Cursor.getAbsolutePosition();
            if (!v3Position.hasKey()) {
                return Cursor.RAW_INDEX_KEY_FIRST;
            }
            return Cursor.createRawIndex(v3Position.getKeyAsBytes(), v3Position.isBefore());
        }
        if (v3Cursor.hasPostfixPosition()) {
            return this.convertPostfixCursor(v3Cursor, configOverrides);
        }
        return Cursor.EMPTY;
    }

    public Cursor convertPostfixCursor(DatastoreV3Pb.CompiledCursor v3Cursor, @Nullable DatastoreCustomizableConfigPb.DatastoreCustomizableConfig configOverrides) throws InvalidConversionException {
        OnestoreEntity.IndexPostfix v3Postfix = v3Cursor.getPostfixPosition();
        InvalidConversionException.checkConversion(v3Postfix.hasKey() || v3Postfix.indexValueSize() > 0 || !v3Postfix.hasBefore(), "Cursor position cannot specify start inclusivity without a key.", new Object[0]);
        EntityRef key = v3Postfix.hasKey() ? this.appEngV3ResourceRefToRepConverter.convertEntityRef(v3Postfix.getKey(), configOverrides) : null;
        ImmutableList.Builder propertyPathsBuilder = ImmutableList.builder();
        ImmutableList.Builder indexValuesBuilder = ImmutableList.builder();
        for (OnestoreEntity.IndexPostfix_IndexValue v3IndexValue : v3Postfix.indexValues()) {
            PropertyPath propertyPath = PropertyPath.createFromAmbiguousPathString(v3IndexValue.getPropertyName());
            UnifiedIndexValue indexValue = UnifiedIndexValue.create(v3IndexValue.getValue());
            propertyPathsBuilder.add(propertyPath);
            indexValuesBuilder.add(indexValue);
        }
        return Cursor.create(key, (ImmutableList<PropertyPath>)propertyPathsBuilder.build(), (ImmutableList<UnifiedIndexValue>)indexValuesBuilder.build(), v3Postfix.isBefore());
    }
}

