/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.auth.rules;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.firebase.rules.runtime.common.AsyncRuntimeFunction;
import com.google.firebase.rules.runtime.utils.FunctionExpects;
import com.google.firebase.rules.runtime.v1.ExecutionRequest;
import com.google.firebase.rules.runtime.v1.ExecutionResponse;
import com.google.firebase.rules.runtime.v1.ExpressionValue;

@FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.ANY})
public class DebugFunction
implements AsyncRuntimeFunction {
    public static final DebugFunction NOOP = new DebugFunction();
    public static final DebugFunction STDOUT = new DebugFunction(){

        @Override
        public ListenableFuture<ExecutionResponse> execute(ExecutionRequest request) {
            System.out.println(request.getArguments(0));
            return super.execute(request);
        }
    };

    private DebugFunction() {
    }

    @Override
    public String name() {
        return "debug";
    }

    @Override
    public ListenableFuture<ExecutionResponse> execute(ExecutionRequest request) {
        ExpressionValue value = request.getArguments(0);
        return Futures.immediateFuture(ExecutionResponse.newBuilder().setValue(value).build());
    }
}

