/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.auth.rules;

import com.google.cloud.datastore.core.auth.rules.LookupManager;
import com.google.cloud.datastore.core.auth.rules.LookupsToAuthorize;
import com.google.cloud.datastore.core.auth.rules.RulesAuthorizer;
import com.google.cloud.datastore.core.auth.rules.RulesRequestContext;
import com.google.cloud.datastore.core.auth.rules.RulesStats;
import com.google.cloud.datastore.core.rep.EntityRef;
import com.google.cloud.datastore.core.rep.ReadResult;
import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import java.util.concurrent.TimeUnit;

class LookupHandlers {
    LookupHandlers() {
    }

    static RulesAuthorizer.LookupHandler accessCollectorDecorator(final RulesRequestContext requestContext, final RulesAuthorizer.LookupHandler delegate, final Ticker ticker) {
        return new RulesAuthorizer.LookupHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ReadResult lookup(EntityRef key) {
                boolean success = false;
                long updateVersion = 0L;
                Stopwatch stopwatch = Stopwatch.createStarted(ticker);
                try {
                    ReadResult result = delegate.lookup(key);
                    success = true;
                    if (result.exists()) {
                        updateVersion = result.updateVersion();
                    }
                    ReadResult readResult = result;
                    return readResult;
                }
                finally {
                    long elapsedInMicroSeconds = stopwatch.elapsed(TimeUnit.MICROSECONDS);
                    requestContext.rulesAccessCollector().registerLookup(LookupsToAuthorize.Lookup.builder().accessType(LookupsToAuthorize.AccessType.GET).key(key).updateVersion(updateVersion).build(), elapsedInMicroSeconds, success);
                    requestContext.stats().stat(RulesStats.Summing.RULES_READ_COUNT).accumulate(1L);
                    requestContext.stats().stat(RulesStats.Summing.RULES_ACCESS_COUNT).accumulate(1L);
                    requestContext.stats().stat(RulesStats.Summing.RULES_READ_LATENCY_US).accumulate(elapsedInMicroSeconds);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ReadResult exists(EntityRef key) {
                boolean success = false;
                long updateVersion = 0L;
                Stopwatch stopwatch = Stopwatch.createStarted(ticker);
                try {
                    ReadResult exists = delegate.exists(key);
                    success = true;
                    if (exists.exists()) {
                        updateVersion = exists.updateVersion();
                    }
                    ReadResult readResult = exists;
                    return readResult;
                }
                finally {
                    long elapsedInMicroSeconds = stopwatch.elapsed(TimeUnit.MICROSECONDS);
                    requestContext.rulesAccessCollector().registerLookup(LookupsToAuthorize.Lookup.builder().accessType(LookupsToAuthorize.AccessType.EXISTS).key(key).updateVersion(updateVersion).build(), elapsedInMicroSeconds, success);
                    requestContext.stats().stat(RulesStats.Summing.RULES_EXISTS_COUNT).accumulate(1L);
                    requestContext.stats().stat(RulesStats.Summing.RULES_ACCESS_COUNT).accumulate(1L);
                    requestContext.stats().stat(RulesStats.Summing.RULES_EXISTS_LATENCY_US).accumulate(elapsedInMicroSeconds);
                }
            }
        };
    }

    static RulesAuthorizer.LookupHandler limitingDecorator(final RulesAuthorizer.LookupHandler delegate, final LookupManager.AccessLimitManager accessLimitManager) {
        return new RulesAuthorizer.LookupHandler(){

            @Override
            public ReadResult lookup(EntityRef key) {
                accessLimitManager.beforeGet();
                return delegate.lookup(key);
            }

            @Override
            public ReadResult exists(EntityRef key) {
                accessLimitManager.beforeExists();
                return delegate.exists(key);
            }
        };
    }
}

