/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.auth.rules;

import com.google.cloud.datastore.core.auth.rules.RulesRequestContext;
import com.google.cloud.datastore.core.exception.DatastoreException;
import com.google.cloud.datastore.core.rep.EntityRef;
import com.google.cloud.datastore.core.rep.Lookup;
import com.google.cloud.datastore.core.rep.Query;
import com.google.cloud.datastore.core.rep.ReadResult;
import com.google.cloud.datastore.core.rep.Write;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.Map;
import javax.annotation.CheckReturnValue;

public interface RulesAuthorizer {
    public static final PreAuthorizedAuthorizer PREAUTHORIZED = new PreAuthorizedAuthorizer();
    public static final RulesAuthorizer NOOP = new RulesAuthorizer(){

        @Override
        public PerEntityReadAuthorizer checkAccess(RulesRequestContext requestContext, Lookup lookup) {
            return PREAUTHORIZED;
        }

        @Override
        public void checkAccess(RulesRequestContext requestContext, Query internalQuery, LookupHandler lookupHandler) {
        }

        @Override
        public PerEntityWriteAuthorizer checkCommit(RulesRequestContext requestContext, Write write) {
            return PREAUTHORIZED;
        }

        @Override
        public void checkWrite(RulesRequestContext requestContext, Write write) {
        }
    };

    @CheckReturnValue
    public PerEntityReadAuthorizer checkAccess(RulesRequestContext var1, Lookup var2) throws DatastoreException;

    public void checkAccess(RulesRequestContext var1, Query var2, LookupHandler var3) throws DatastoreException;

    @CheckReturnValue
    public PerEntityWriteAuthorizer checkCommit(RulesRequestContext var1, Write var2) throws DatastoreException;

    public void checkWrite(RulesRequestContext var1, Write var2) throws DatastoreException;

    public static class PreAuthorizedAuthorizer
    implements PerEntityReadAuthorizer,
    PerEntityWriteAuthorizer {
        private PreAuthorizedAuthorizer() {
        }

        @Override
        public boolean isPreAuthorized() {
            return true;
        }

        @Override
        public void checkAccess(LookupHandler lookupHandler, ReadResult entityUnderAuthorization) {
        }

        @Override
        public void checkAccess(LookupHandler lookupHandler, ReadResult oldEntity, OnestoreEntity.EntityProto newEntity, Map<EntityRef, OnestoreEntity.EntityProto> writeBatch) {
        }
    }

    public static interface LookupHandler {
        public ReadResult lookup(EntityRef var1);

        public ReadResult exists(EntityRef var1);
    }

    public static interface PerEntityReadAuthorizer {
        public boolean isPreAuthorized();

        public void checkAccess(LookupHandler var1, ReadResult var2) throws DatastoreException;
    }

    public static interface PerEntityWriteAuthorizer {
        public void checkAccess(LookupHandler var1, ReadResult var2, OnestoreEntity.EntityProto var3, Map<EntityRef, OnestoreEntity.EntityProto> var4) throws DatastoreException;
    }
}

