/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.auth.rules;

import com.google.cloud.datastore.core.appengv3.converter.AppEngV3ResourceRefToRepConverter;
import com.google.cloud.datastore.core.auth.rules.Constants;
import com.google.cloud.datastore.core.auth.rules.DatastoreRuleContextBuilder;
import com.google.cloud.datastore.core.auth.rules.EntityToExpressionValueConverter;
import com.google.cloud.datastore.core.auth.rules.FirebaseRulesAuthorizerOptions;
import com.google.cloud.datastore.core.auth.rules.LazyCollectingSupplier;
import com.google.cloud.datastore.core.auth.rules.LookupManager;
import com.google.cloud.datastore.core.auth.rules.PropertyMaskHelper;
import com.google.cloud.datastore.core.auth.rules.PropertyPathToExpressionValue;
import com.google.cloud.datastore.core.auth.rules.QueryToResourceConverter;
import com.google.cloud.datastore.core.auth.rules.RequestAuthorizationResponse;
import com.google.cloud.datastore.core.auth.rules.RuleContextBuilderAndResource;
import com.google.cloud.datastore.core.auth.rules.RulesAuthorizer;
import com.google.cloud.datastore.core.auth.rules.RulesRequestContext;
import com.google.cloud.datastore.core.auth.rules.RulesStats;
import com.google.cloud.datastore.core.exception.DatastoreException;
import com.google.cloud.datastore.core.exception.DatastoreExceptionHelper;
import com.google.cloud.datastore.core.names.Names;
import com.google.cloud.datastore.core.rep.Direction;
import com.google.cloud.datastore.core.rep.EntityRef;
import com.google.cloud.datastore.core.rep.Lookup;
import com.google.cloud.datastore.core.rep.Mutation;
import com.google.cloud.datastore.core.rep.PartitionRef;
import com.google.cloud.datastore.core.rep.PropertyMask;
import com.google.cloud.datastore.core.rep.PropertyPath;
import com.google.cloud.datastore.core.rep.Query;
import com.google.cloud.datastore.core.rep.ReadResult;
import com.google.cloud.datastore.core.rep.ReservedName;
import com.google.cloud.datastore.core.rep.Write;
import com.google.cloud.datastore.core.stats.GenericStats;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Ticker;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.firebase.rules.runtime.evaluators.AuthRuleEvaluator;
import com.google.firebase.rules.runtime.evaluators.RuleClient;
import com.google.firebase.rules.runtime.utils.ExpressionValueUtils;
import com.google.firebase.rules.runtime.utils.PathUtils;
import com.google.firebase.rules.runtime.v1.ExpressionListValue;
import com.google.firebase.rules.runtime.v1.ExpressionMapValue;
import com.google.firebase.rules.runtime.v1.ExpressionPathValue;
import com.google.firebase.rules.runtime.v1.ExpressionValue;
import com.google.firebase.rules.runtime.v1.RulesetAst;
import com.google.firebase.rules.runtime.v1.Undefined;
import com.google.net.rpc3.RpcException;
import com.google.net.util.error.Codes;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class SinglePhaseRulesAuthorizer
implements RulesAuthorizer {
    static final ExpressionValue EXPECTED_UNDEFINED = ExpressionValue.newBuilder().setUndefined(Undefined.getDefaultInstance()).build();
    static final String USER_DEFINED_DATA_FIELD = "data";
    static final String RESOURCE_ID_FIELD = "id";
    private final QueryToResourceConverter queryToResourceConverter;
    private final FirebaseRulesAuthorizerOptions firebaseRulesAuthorizerOptions;
    private final RuleClient ruleClient;
    private final Ticker ticker;
    private final EntityToExpressionValueConverter entityToExpressionValueConverter;
    private final String defaultReleaseName;

    protected SinglePhaseRulesAuthorizer(FirebaseRulesAuthorizerOptions firebaseRulesAuthorizerOptions, RuleClient ruleClient, Ticker ticker, EntityToExpressionValueConverter entityToExpressionValueConverter, String defaultReleaseName) {
        this.firebaseRulesAuthorizerOptions = firebaseRulesAuthorizerOptions;
        this.ruleClient = ruleClient;
        this.ticker = ticker;
        this.entityToExpressionValueConverter = entityToExpressionValueConverter;
        this.defaultReleaseName = defaultReleaseName;
        this.queryToResourceConverter = new QueryToResourceConverter(entityToExpressionValueConverter);
    }

    @Override
    public RulesAuthorizer.PerEntityReadAuthorizer checkAccess(RulesRequestContext requestContext, Lookup lookup) throws DatastoreException {
        AuthRuleEvaluator evaluator = this.getEvaluator(requestContext);
        ImmutableMap<EntityRef, RequestAuthorizationResponse> authorizationStates = SinglePhaseRulesAuthorizer.prepareLookupCheck(lookup);
        return new GetAuthorizer(requestContext, lookup, evaluator, authorizationStates);
    }

    @Override
    public void checkAccess(RulesRequestContext requestContext, Query internalQuery, RulesAuthorizer.LookupHandler lookupHandler) throws DatastoreException {
        AuthRuleEvaluator evaluator = this.getEvaluator(requestContext);
        ImmutableList<RuleContextBuilderAndResource> resourcesToAuthorize = this.constructQueryResources(requestContext, internalQuery, evaluator.getRulesetAst().getVersion());
        this.checkQueryResources(requestContext, lookupHandler, resourcesToAuthorize, evaluator);
    }

    @Override
    public void checkWrite(RulesRequestContext requestContext, Write write) throws DatastoreException {
        throw DatastoreExceptionHelper.permissionDenied();
    }

    @Override
    public RulesAuthorizer.PerEntityWriteAuthorizer checkCommit(RulesRequestContext requestContext, Write write) throws DatastoreException {
        if (requestContext.transactionHandle() == null) {
            throw DatastoreExceptionHelper.permissionDenied();
        }
        AuthRuleEvaluator evaluator = this.getEvaluator(requestContext);
        ImmutableMap<EntityRef, CommitAuthorizationInfo> authorizationStates = SinglePhaseRulesAuthorizer.prepareCommitCheck(write);
        return new CommitAuthorizerImpl(requestContext, evaluator, authorizationStates);
    }

    private static ImmutableMap<EntityRef, RequestAuthorizationResponse> prepareLookupCheck(Lookup lookup) {
        return lookup.keys().stream().map(k -> AppEngV3ResourceRefToRepConverter.convertValidEntityRef(k, null)).collect(ImmutableMap.toImmutableMap(k -> k, k -> RequestAuthorizationResponse.AUTHORIZATION_UNKNOWN));
    }

    final ImmutableList<RuleContextBuilderAndResource> constructQueryResources(RulesRequestContext requestContext, Query internalQuery, RulesetAst.Version rulesVersion) throws DatastoreException {
        if (internalQuery.kind() != null && Names.isNameReserved(internalQuery.kind())) {
            throw DatastoreExceptionHelper.permissionDenied();
        }
        ImmutableList.Builder contextAndResources = ImmutableList.builder();
        Iterable<QueryToResourceConverter.QueryConstraint> constraints = this.queryToResourceConverter.convert(internalQuery);
        for (QueryToResourceConverter.QueryConstraint queryConstraint : constraints) {
            contextAndResources.add(this.toContextAndResource(requestContext, internalQuery, queryConstraint, rulesVersion));
        }
        return contextAndResources.build();
    }

    private static ImmutableMap<EntityRef, CommitAuthorizationInfo> prepareCommitCheck(Write write) {
        return write.mutations().stream().collect(ImmutableMap.toImmutableMap(m -> AppEngV3ResourceRefToRepConverter.convertValidEntityRef(m.key(), null), mutation -> new CommitAuthorizationInfo(RequestAuthorizationResponse.AUTHORIZATION_UNKNOWN, (Mutation)mutation)));
    }

    final void checkQueryResources(RulesRequestContext requestContext, RulesAuthorizer.LookupHandler lookupHandler, ImmutableList<RuleContextBuilderAndResource> resourcesToAuthorize, AuthRuleEvaluator evaluator) throws DatastoreException {
        LookupManager lookupManager = this.makeLookupManager(requestContext);
        for (RuleContextBuilderAndResource contextBuilder : resourcesToAuthorize) {
            SinglePhaseRulesAuthorizer.checkQueryResource(contextBuilder, requestContext, evaluator, lookupManager, lookupHandler);
        }
    }

    private static void checkQueryResource(RuleContextBuilderAndResource contextBuilderAndResource, RulesRequestContext requestContext, AuthRuleEvaluator evaluator, LookupManager lookupManager, RulesAuthorizer.LookupHandler lookupHandler) throws DatastoreException {
        if (contextBuilderAndResource.resourcePath == null) {
            lookupManager.addDynamicLookupFunctionsAndVariables(lookupHandler, contextBuilderAndResource.datastoreRuleContextBuilder);
            contextBuilderAndResource.datastoreRuleContextBuilder.supplyResource(contextBuilderAndResource.resource);
        } else {
            lookupManager.addDynamicLookupFunctionsAndVariables(lookupHandler, contextBuilderAndResource.datastoreRuleContextBuilder, contextBuilderAndResource.resourcePath);
        }
        AuthRuleEvaluator.RuleContext context = contextBuilderAndResource.datastoreRuleContextBuilder.build(Constants.ActionIds.LIST);
        SinglePhaseRulesAuthorizer.evaluate(requestContext, evaluator, context);
    }

    private RuleContextBuilderAndResource toContextAndResource(RulesRequestContext requestContext, Query internalQuery, QueryToResourceConverter.QueryConstraint queryConstraint, RulesetAst.Version rulesVersion) throws DatastoreException {
        DatastoreRuleContextBuilder requestBuilder = this.makeRulesContext(requestContext).supplyTransaction(requestContext.transactionHandle());
        ExpressionValue fields = internalQuery.propertyMask().equals(PropertyMask.FULL) ? this.propertyPathListToExpressionValue(internalQuery.projection()) : PropertyMaskHelper.convertPropertyMaskToExpressionValue(internalQuery.propertyMask());
        requestBuilder.supplyRequestField(Constants.RequestFields.IN_TRANSACTION, ExpressionValueUtils.createValue(requestContext.transactionHandle() != null)).supplyRequestField(Constants.RequestFields.FIELDS, fields);
        requestBuilder.supplyRequestField(Constants.RequestFields.QUERY, this.queryToExpression(internalQuery));
        ExpressionValue keyConstraint = queryConstraint.keyConstraint();
        if (keyConstraint != null && ExpressionValueUtils.isPath(keyConstraint)) {
            requestBuilder.path(keyConstraint.getPathValue());
            return RuleContextBuilderAndResource.lazy(requestBuilder, keyConstraint.getPathValue());
        }
        requestBuilder.path(SinglePhaseRulesAuthorizer.buildMatchPath(requestContext, internalQuery, rulesVersion));
        requestBuilder.trackFieldAccesses();
        HashMap<String, ExpressionValue> fieldsMap = new HashMap<String, ExpressionValue>();
        if (keyConstraint != null) {
            fieldsMap.put(ReservedName.NAME.asString(), keyConstraint);
        }
        fieldsMap.put(USER_DEFINED_DATA_FIELD, queryConstraint.resourceConstraint());
        ExpressionValue resource = ExpressionValueUtils.createValue(fieldsMap);
        return RuleContextBuilderAndResource.eager(requestBuilder, resource);
    }

    private static ExpressionPathValue buildMatchPath(RulesRequestContext requestContext, Query internalQuery, RulesetAst.Version rulesVersion) throws DatastoreException {
        EntityRef ancestorRef = internalQuery.ancestor() != null ? internalQuery.ancestor() : EntityRef.createEmpty(PartitionRef.createFromDatabaseRefAndNamespace(requestContext.databaseRef(), internalQuery.scope().namespace()));
        PathUtils.Builder pathBuilder = DatastoreRuleContextBuilder.makeReferencePath(ancestorRef);
        if (!internalQuery.isShallow()) {
            if (internalQuery.semantics().equals((Object)Query.Semantics.FIRESTORE) && rulesVersion.equals(RulesetAst.Version.VERSION_2)) {
                pathBuilder.appendGlob();
            } else {
                if (internalQuery.semantics().equals((Object)Query.Semantics.FIRESTORE)) {
                    return pathBuilder.appendGlob().build();
                }
                throw DatastoreExceptionHelper.permissionDenied();
            }
        }
        if (!Strings.isNullOrEmpty(internalQuery.kind())) {
            pathBuilder.appendSegment(internalQuery.kind()).appendCapture();
        } else {
            pathBuilder.appendCapture().appendCapture();
        }
        return pathBuilder.build();
    }

    private ExpressionValue propertyPathListToExpressionValue(ImmutableList<PropertyPath> propertyPaths) {
        if (propertyPaths.isEmpty()) {
            return ExpressionValueUtils.NULL;
        }
        ExpressionListValue.Builder listBuilder = ExpressionListValue.newBuilder();
        for (PropertyPath propertyPath : propertyPaths) {
            listBuilder.addValues(PropertyPathToExpressionValue.INSTANCE.apply(propertyPath));
        }
        return ExpressionValueUtils.createValue(listBuilder.build());
    }

    private ExpressionValue queryToExpression(Query query) {
        String ancestorPropertyName = query.isShallow() ? "parent" : "ancestor";
        return ExpressionValueUtils.createValue(ExpressionMapValue.newBuilder().putFields("distinct", ExpressionValueUtils.createValue(query.allowDuplicateResults())).putFields("selectOnlyKeys", ExpressionValueUtils.createValue(query.selectOnlyKeys())).putFields("groupBy", ExpressionValueUtils.createValue(query.groupBy().stream().collect(Collectors.toMap(PropertyPathToExpressionValue.INSTANCE::asString, path -> ExpressionValueUtils.createValue(true))))).putFields("kind", ExpressionValueUtils.createValue((Object)query.kind())).putFields(ancestorPropertyName, query.ancestor() != null ? ExpressionValueUtils.createValue(DatastoreRuleContextBuilder.makeReferencePath(query.ancestor()).build()) : ExpressionValueUtils.NULL).putFields("orderBy", ExpressionValueUtils.createValue(query.orderBy().stream().collect(Collectors.toMap(pathAndDirection -> PropertyPathToExpressionValue.INSTANCE.asString(pathAndDirection.propertyPath()), pathAndDirection -> pathAndDirection.direction() == Direction.ASCENDING ? "ASC" : "DESC", (direction1, direction2) -> direction1)))).putFields("limit", ExpressionValueUtils.createValue(query.limit())).putFields("offset", ExpressionValueUtils.createValue(query.offset())).putFields("allDescendants", ExpressionValueUtils.createValue(!query.isShallow() && query.semantics().equals((Object)Query.Semantics.FIRESTORE))).build());
    }

    final DatastoreRuleContextBuilder makeGetRuleContext(RulesRequestContext requestContext, PropertyMask propertyMask, EntityRef key) {
        return this.makeRulesContext(requestContext).path(key).supplyTransaction(requestContext.transactionHandle()).supplyRequestField(Constants.RequestFields.FIELDS, PropertyMaskHelper.convertPropertyMaskToExpressionValue(propertyMask));
    }

    final DatastoreRuleContextBuilder makeWriteContext(RulesRequestContext requestContext, CommitAuthorizationInfo authorizationInfo) {
        if (authorizationInfo.mutation.allocateKey()) {
            return this.makeWriteContext(requestContext, authorizationInfo.referenceBeforeAssignId, authorizationInfo.mutation);
        }
        return this.makeWriteContext(requestContext, authorizationInfo.mutation);
    }

    final DatastoreRuleContextBuilder makeWriteContext(RulesRequestContext requestContext, Mutation mutation) {
        return this.makeWriteContext(requestContext, AppEngV3ResourceRefToRepConverter.convertValidEntityRef(mutation.key(), null), mutation);
    }

    final DatastoreRuleContextBuilder makeWriteContext(RulesRequestContext requestContext, EntityRef key, Mutation mutation) {
        DatastoreRuleContextBuilder contextBuilder = this.makeRulesContext(requestContext).path(key);
        ExpressionValue modifiedFieldsList = ExpressionValueUtils.NULL;
        if (mutation.transformation() != null) {
            modifiedFieldsList = ExpressionValueUtils.transformList(mutation.transformation().propertyTransformations(), propertyTransformation -> PropertyPathToExpressionValue.INSTANCE.apply(propertyTransformation.propertyPath()));
        }
        contextBuilder.supplyRequestField(Constants.RequestFields.TRANSFORMS, modifiedFieldsList);
        ExpressionValue maskPropertiesList = PropertyMaskHelper.convertPropertyMaskToExpressionValue(mutation.writePropertyMask());
        if (maskPropertiesList.hasListValue() && modifiedFieldsList.hasListValue()) {
            modifiedFieldsList = ExpressionValue.newBuilder().setListValue(ExpressionListValue.newBuilder(modifiedFieldsList.getListValue()).addAllValues(maskPropertiesList.getListValue().getValuesList())).build();
        } else if (maskPropertiesList.hasListValue()) {
            modifiedFieldsList = maskPropertiesList;
        }
        contextBuilder.supplyRequestField(Constants.RequestFields.WRITE_FIELDS, modifiedFieldsList);
        contextBuilder.supplyRequestField(Constants.RequestFields.READ_FIELDS, PropertyMaskHelper.convertPropertyMaskToExpressionValue(mutation.readPropertyMask()));
        if (mutation.op() == Mutation.Op.INSERT) {
            contextBuilder.supplyRequestField(Constants.RequestFields.AUTO_ID, ExpressionValueUtils.createValue(mutation.allocateKey()));
        }
        return contextBuilder;
    }

    private static void evaluate(RulesRequestContext requestContext, AuthRuleEvaluator evaluator, AuthRuleEvaluator.RuleContext ruleContext) throws DatastoreException {
        try {
            AuthRuleEvaluator.RuleResult result = (AuthRuleEvaluator.RuleResult)evaluator.evaluate(ruleContext).get();
            if (!result.permit()) {
                requestContext.stats().stat(RulesStats.Label.RULE_EVALUATION_OUTCOME).set((Object)RulesStats.RuleEvaluationOutcome.RULES_SECOND_PHASE_DENIED);
                throw DatastoreExceptionHelper.permissionDenied();
            }
            requestContext.stats().stat(RulesStats.Label.RULE_EVALUATION_OUTCOME).set((Object)RulesStats.RuleEvaluationOutcome.RULES_SECOND_PHASE_ALLOWED);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            requestContext.stats().stat(RulesStats.Label.RULE_EVALUATION_OUTCOME).set((Object)RulesStats.RuleEvaluationOutcome.RULES_SECOND_PHASE_ERROR);
            throw DatastoreExceptionHelper.permissionDenied(e.getCause());
        }
    }

    final AuthRuleEvaluator getEvaluator(RulesRequestContext requestContext) throws DatastoreException {
        AuthRuleEvaluator.AuthRuleEvaluatorRequest evaluatorRequest = AuthRuleEvaluator.AuthRuleEvaluatorRequest.release(requestContext.databaseRef().projectId(), this.defaultReleaseName);
        try {
            AuthRuleEvaluator evaluator = this.ruleClient.getEvaluator(evaluatorRequest);
            if (evaluator == null) {
                throw DatastoreExceptionHelper.permissionDenied();
            }
            requestContext.stats().stat(RulesStats.Label.RULESET_ID).set(SinglePhaseRulesAuthorizer.rulesetNameToId(evaluator.getRulesetName()));
            requestContext.rulesAccessCollector().setReleaseName(evaluatorRequest.releaseName()).setRulesetName(evaluator.getRulesetName());
            return evaluator;
        }
        catch (RpcException e) {
            if (e.getStatus().getCanonicalCode() == Codes.Code.NOT_FOUND) {
                throw DatastoreExceptionHelper.permissionDenied(e);
            }
            throw DatastoreExceptionHelper.internalError(e);
        }
    }

    private static String rulesetNameToId(String rulesetName) {
        int lastIndex = rulesetName.lastIndexOf(47);
        Preconditions.checkArgument(lastIndex > 0 && lastIndex < rulesetName.length() - 1);
        return rulesetName.substring(lastIndex + 1);
    }

    protected DatastoreRuleContextBuilder makeRulesContext(RulesRequestContext requestContext) {
        return DatastoreRuleContextBuilder.builder(requestContext, this.entityToExpressionValueConverter);
    }

    private LookupManager makeLookupManager(RulesRequestContext requestContext) {
        return new LookupManager(requestContext, this.entityToExpressionValueConverter, this.firebaseRulesAuthorizerOptions, this.ticker);
    }

    private static Constants.ActionIds actionId(Mutation.Op op, boolean oldEntityExists) {
        switch (op) {
            case INSERT: {
                return Constants.ActionIds.CREATE;
            }
            case UPDATE: {
                return Constants.ActionIds.UPDATE;
            }
            case UPSERT: {
                if (oldEntityExists) {
                    return Constants.ActionIds.UPDATE;
                }
                return Constants.ActionIds.CREATE;
            }
            case DELETE: 
            case DELETE_MUST_EXIST: 
            case DELETE_MUST_NOT_EXIST: {
                return Constants.ActionIds.DELETE;
            }
            case VERIFY_MUST_EXIST: 
            case VERIFY_MUST_NOT_EXIST: {
                return Constants.ActionIds.GET;
            }
        }
        throw new AssertionError((Object)"unreachable");
    }

    final class CommitAuthorizerImpl
    implements RulesAuthorizer.PerEntityWriteAuthorizer {
        private final RulesRequestContext requestContext;
        private final AuthRuleEvaluator evaluator;
        private final ImmutableMap<EntityRef, CommitAuthorizationInfo> authorizationStates;
        private final LookupManager lookupManager;

        CommitAuthorizerImpl(RulesRequestContext requestContext, AuthRuleEvaluator evaluator, ImmutableMap<EntityRef, CommitAuthorizationInfo> authorizationStates) {
            this.requestContext = requestContext;
            this.evaluator = evaluator;
            this.lookupManager = SinglePhaseRulesAuthorizer.this.makeLookupManager(requestContext);
            this.authorizationStates = authorizationStates;
        }

        @Override
        public void checkAccess(RulesAuthorizer.LookupHandler lookupHandler, ReadResult oldEntity, OnestoreEntity.EntityProto newEntity, Map<EntityRef, OnestoreEntity.EntityProto> writeBatch) throws DatastoreException {
            try (GenericStats.StatsAutoCloseable tracker = this.requestContext.stats().stat(RulesStats.Phase.EVALUATION).enter();){
                EntityRef key = oldEntity.entityRef();
                CommitAuthorizationInfo authorizationInfo = Preconditions.checkNotNull(this.getAuthorizationInfo(key), "%s was not part of the original request", (Object)key);
                if (authorizationInfo.requestAuthorizationResponse == RequestAuthorizationResponse.AUTHORIZED) {
                    return;
                }
                DatastoreRuleContextBuilder ruleContextBuilder = SinglePhaseRulesAuthorizer.this.makeWriteContext(this.requestContext, authorizationInfo);
                LazyCollectingSupplier resourceVariable = new LazyCollectingSupplier(SinglePhaseRulesAuthorizer.this.entityToExpressionValueConverter, this.requestContext, oldEntity);
                this.lookupManager.addDynamicLookupFunctionsAndVariables(lookupHandler, ruleContextBuilder, resourceVariable, writeBatch);
                ruleContextBuilder.supplyRequestResource(newEntity);
                SinglePhaseRulesAuthorizer.evaluate(this.requestContext, this.evaluator, ruleContextBuilder.build(SinglePhaseRulesAuthorizer.actionId(authorizationInfo.mutation.op(), oldEntity.exists())));
            }
        }

        private CommitAuthorizationInfo getAuthorizationInfo(EntityRef key) {
            if (!this.authorizationStates.containsKey(key)) {
                key = key.parent().append(EntityRef.PathElement.create(key.collectionId(), null));
            }
            return this.authorizationStates.get(key);
        }
    }

    static final class CommitAuthorizationInfo {
        @Nullable
        final EntityRef referenceBeforeAssignId;
        final RequestAuthorizationResponse requestAuthorizationResponse;
        final Mutation mutation;

        CommitAuthorizationInfo(RequestAuthorizationResponse requestAuthorizationResponse, Mutation mutation) {
            this.referenceBeforeAssignId = mutation.allocateKey() ? AppEngV3ResourceRefToRepConverter.convertValidEntityRef(mutation.key(), null) : null;
            this.requestAuthorizationResponse = requestAuthorizationResponse;
            this.mutation = mutation;
        }

        boolean isAuthorized() {
            return this.requestAuthorizationResponse == RequestAuthorizationResponse.AUTHORIZED;
        }
    }

    final class GetAuthorizer
    implements RulesAuthorizer.PerEntityReadAuthorizer {
        private final RulesRequestContext requestContext;
        private final Lookup lookup;
        private final AuthRuleEvaluator evaluator;
        private final ImmutableMap<EntityRef, RequestAuthorizationResponse> authorizationStates;
        private final LookupManager lookupManager;

        GetAuthorizer(RulesRequestContext requestContext, Lookup lookup, AuthRuleEvaluator evaluator, ImmutableMap<EntityRef, RequestAuthorizationResponse> authorizationStates) {
            this.requestContext = requestContext;
            this.lookup = lookup;
            this.evaluator = evaluator;
            this.authorizationStates = authorizationStates;
            this.lookupManager = SinglePhaseRulesAuthorizer.this.makeLookupManager(requestContext);
        }

        @Override
        public boolean isPreAuthorized() {
            return false;
        }

        @Override
        public void checkAccess(RulesAuthorizer.LookupHandler lookupHandler, ReadResult entityUnderAuthorization) throws DatastoreException {
            try (GenericStats.StatsAutoCloseable tracker = this.requestContext.stats().stat(RulesStats.Phase.EVALUATION).enter();){
                EntityRef key = entityUnderAuthorization.entityRef();
                RequestAuthorizationResponse authorizationState = Preconditions.checkNotNull(this.authorizationStates.get(key), "%s was not part of the original request", (Object)key);
                if (authorizationState == RequestAuthorizationResponse.AUTHORIZED) {
                    return;
                }
                DatastoreRuleContextBuilder ruleContextBuilder = SinglePhaseRulesAuthorizer.this.makeGetRuleContext(this.requestContext, this.lookup.propertyMask(), key);
                LazyCollectingSupplier resourceVariable = new LazyCollectingSupplier(SinglePhaseRulesAuthorizer.this.entityToExpressionValueConverter, this.requestContext, entityUnderAuthorization);
                ruleContextBuilder.supplyResource(resourceVariable);
                this.lookupManager.addDynamicLookupFunctionsAndVariables(lookupHandler, ruleContextBuilder, resourceVariable);
                SinglePhaseRulesAuthorizer.evaluate(this.requestContext, this.evaluator, ruleContextBuilder.build(Constants.ActionIds.GET));
            }
        }
    }
}

