/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.auth.rules;

import com.google.auto.value.AutoValue;
import com.google.cloud.datastore.core.appengv3.converter.AppEngV3ResourceRefToRepConverter;
import com.google.cloud.datastore.core.auth.rules.AutoValue_TwoPhaseRulesAuthorizer_PhaseOneCommitInfo;
import com.google.cloud.datastore.core.auth.rules.AutoValue_TwoPhaseRulesAuthorizer_PhaseOneLookupInfo;
import com.google.cloud.datastore.core.auth.rules.AutoValue_TwoPhaseRulesAuthorizer_PhaseOneQueryInfo;
import com.google.cloud.datastore.core.auth.rules.Constants;
import com.google.cloud.datastore.core.auth.rules.DatastoreRuleContextBuilder;
import com.google.cloud.datastore.core.auth.rules.EntityToExpressionValueConverter;
import com.google.cloud.datastore.core.auth.rules.FirebaseRulesAuthorizerOptions;
import com.google.cloud.datastore.core.auth.rules.RequestAuthorizationResponse;
import com.google.cloud.datastore.core.auth.rules.RuleContextBuilderAndResource;
import com.google.cloud.datastore.core.auth.rules.RulesAuthorizer;
import com.google.cloud.datastore.core.auth.rules.RulesRequestContext;
import com.google.cloud.datastore.core.auth.rules.RulesStats;
import com.google.cloud.datastore.core.auth.rules.SinglePhaseRulesAuthorizer;
import com.google.cloud.datastore.core.auth.rules.Trackable;
import com.google.cloud.datastore.core.auth.rules.Trackables;
import com.google.cloud.datastore.core.exception.DatastoreException;
import com.google.cloud.datastore.core.exception.DatastoreExceptionHelper;
import com.google.cloud.datastore.core.rep.EntityRef;
import com.google.cloud.datastore.core.rep.Lookup;
import com.google.cloud.datastore.core.rep.Mutation;
import com.google.cloud.datastore.core.rep.PropertyMask;
import com.google.cloud.datastore.core.rep.Query;
import com.google.cloud.datastore.core.rep.V3Paths;
import com.google.cloud.datastore.core.rep.Write;
import com.google.cloud.datastore.core.stats.GenericStats;
import com.google.common.base.Preconditions;
import com.google.common.base.Ticker;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.firebase.rules.runtime.evaluators.AuthRuleEvaluator;
import com.google.firebase.rules.runtime.evaluators.RuleClient;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.concurrent.ExecutionException;

public class TwoPhaseRulesAuthorizer
extends SinglePhaseRulesAuthorizer {
    public TwoPhaseRulesAuthorizer(FirebaseRulesAuthorizerOptions firebaseRulesAuthorizerOptions, RuleClient ruleClient, Ticker ticker, EntityToExpressionValueConverter entityToExpressionValueConverter, String defaultReleaseName) {
        super(firebaseRulesAuthorizerOptions, ruleClient, ticker, entityToExpressionValueConverter, defaultReleaseName);
    }

    @Override
    public RulesAuthorizer.PerEntityReadAuthorizer checkAccess(RulesRequestContext requestContext, Lookup lookup) throws DatastoreException {
        AuthRuleEvaluator evaluator = this.getEvaluator(requestContext);
        PhaseOneLookupInfo phaseOneInfo = this.checkLookupPhaseOne(requestContext, lookup, evaluator);
        TwoPhaseRulesAuthorizer.logFirstPhaseStat(requestContext, phaseOneInfo.requestAuthorizationResponse());
        switch (phaseOneInfo.requestAuthorizationResponse()) {
            case AUTHORIZED: {
                return PREAUTHORIZED;
            }
            case UNAUTHORIZED: 
            case EVALUATION_ERROR: {
                throw DatastoreExceptionHelper.permissionDenied();
            }
            case AUTHORIZATION_UNKNOWN: {
                return new SinglePhaseRulesAuthorizer.GetAuthorizer(requestContext, lookup, evaluator, phaseOneInfo.authorizationStates());
            }
        }
        throw new AssertionError((Object)"unreachable");
    }

    @Override
    public void checkAccess(RulesRequestContext requestContext, Query internalQuery, RulesAuthorizer.LookupHandler lookupHandler) throws DatastoreException {
        AuthRuleEvaluator evaluator = this.getEvaluator(requestContext);
        PhaseOneQueryInfo phaseOneInfo = this.checkQueryPhaseOne(requestContext, internalQuery, evaluator);
        TwoPhaseRulesAuthorizer.logFirstPhaseStat(requestContext, phaseOneInfo.requestAuthorizationResponse());
        switch (phaseOneInfo.requestAuthorizationResponse()) {
            case AUTHORIZED: {
                return;
            }
            case UNAUTHORIZED: 
            case EVALUATION_ERROR: {
                throw DatastoreExceptionHelper.permissionDenied();
            }
            case AUTHORIZATION_UNKNOWN: {
                this.checkQueryResources(requestContext, lookupHandler, phaseOneInfo.needSecondPhase(), evaluator);
            }
        }
    }

    @Override
    public void checkWrite(RulesRequestContext requestContext, Write write) throws DatastoreException {
        GenericStats.StatsAutoCloseable tracker = requestContext.stats().stat(RulesStats.Phase.EVALUATION).enter();
        Throwable throwable = null;
        try {
            try {
                TwoPhaseRulesAuthorizer.logFirstPhaseStat(requestContext, RequestAuthorizationResponse.UNAUTHORIZED);
                throw DatastoreExceptionHelper.permissionDenied();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            if (tracker != null) {
                TwoPhaseRulesAuthorizer.$closeResource(throwable, tracker);
            }
            throw throwable3;
        }
    }

    @Override
    public RulesAuthorizer.PerEntityWriteAuthorizer checkCommit(RulesRequestContext requestContext, Write write) throws DatastoreException {
        if (requestContext.transactionHandle() == null) {
            throw DatastoreExceptionHelper.permissionDenied();
        }
        AuthRuleEvaluator evaluator = this.getEvaluator(requestContext);
        PhaseOneCommitInfo phaseOneInfo = this.checkCommitPhaseOne(requestContext, write, evaluator);
        TwoPhaseRulesAuthorizer.logFirstPhaseStat(requestContext, phaseOneInfo.requestAuthorizationResponse());
        switch (phaseOneInfo.requestAuthorizationResponse()) {
            case AUTHORIZED: {
                return PREAUTHORIZED;
            }
            case UNAUTHORIZED: 
            case EVALUATION_ERROR: {
                throw DatastoreExceptionHelper.permissionDenied();
            }
            case AUTHORIZATION_UNKNOWN: {
                return new SinglePhaseRulesAuthorizer.CommitAuthorizerImpl(requestContext, evaluator, phaseOneInfo.authorizationStates());
            }
        }
        throw new AssertionError((Object)"unreachable");
    }

    private PhaseOneLookupInfo checkLookupPhaseOne(RulesRequestContext requestContext, Lookup lookup, AuthRuleEvaluator evaluator) {
        try (GenericStats.StatsAutoCloseable tracker = requestContext.stats().stat(RulesStats.Phase.EVALUATION).enter();){
            PhaseOneLookupInfo phaseOneLookupInfo;
            ImmutableMap.Builder<EntityRef, RequestAuthorizationResponse> authorizationResults = ImmutableMap.builder();
            for (OnestoreEntity.Reference ref : lookup.distinctKeys()) {
                EntityRef key = AppEngV3ResourceRefToRepConverter.convertValidEntityRef(ref, null);
                DatastoreRuleContextBuilder rulesContextBuilder = this.makeGetRuleContext(requestContext, lookup.propertyMask(), key);
                Trackable dataAccessTracker = Trackables.of(rulesContextBuilder.trackDynamicCalls(), rulesContextBuilder.trackResourceAccess());
                RequestAuthorizationResponse response = TwoPhaseRulesAuthorizer.evaluateRequest(evaluator, rulesContextBuilder.build(Constants.ActionIds.GET), dataAccessTracker);
                if (TwoPhaseRulesAuthorizer.canConclusivelyRejectInPhaseOne(response)) {
                    PhaseOneLookupInfo phaseOneLookupInfo2 = PhaseOneLookupInfo.conclusive(response);
                    return phaseOneLookupInfo2;
                }
                authorizationResults.put(key, response);
            }
            ImmutableMap authorizationStates = authorizationResults.build();
            if (authorizationStates.values().stream().allMatch(RequestAuthorizationResponse.AUTHORIZED::equals)) {
                phaseOneLookupInfo = PhaseOneLookupInfo.conclusive(RequestAuthorizationResponse.AUTHORIZED);
                return phaseOneLookupInfo;
            }
            phaseOneLookupInfo = PhaseOneLookupInfo.inconclusive(authorizationStates);
            return phaseOneLookupInfo;
        }
    }

    private PhaseOneQueryInfo checkQueryPhaseOne(RulesRequestContext requestContext, Query internalQuery, AuthRuleEvaluator evaluator) throws DatastoreException {
        try (GenericStats.StatsAutoCloseable tracker = requestContext.stats().stat(RulesStats.Phase.EVALUATION).enter();){
            PhaseOneQueryInfo phaseOneQueryInfo;
            ImmutableList<RuleContextBuilderAndResource> ruleContextBuilderAndResources = this.constructQueryResources(requestContext, internalQuery, evaluator.getRulesetAst().getVersion());
            ImmutableList.Builder inconclusive = ImmutableList.builder();
            for (RuleContextBuilderAndResource contextBuilder : ruleContextBuilderAndResources) {
                RequestAuthorizationResponse requestAuthorizationResponse = this.runFirstPhase(evaluator, contextBuilder);
                if (TwoPhaseRulesAuthorizer.canConclusivelyRejectInPhaseOne(requestAuthorizationResponse)) {
                    PhaseOneQueryInfo phaseOneQueryInfo2 = PhaseOneQueryInfo.conclusive(requestAuthorizationResponse);
                    return phaseOneQueryInfo2;
                }
                if (requestAuthorizationResponse != RequestAuthorizationResponse.AUTHORIZATION_UNKNOWN) continue;
                inconclusive.add(contextBuilder);
            }
            ImmutableCollection needSecondPhase = inconclusive.build();
            if (needSecondPhase.isEmpty()) {
                phaseOneQueryInfo = PhaseOneQueryInfo.conclusive(RequestAuthorizationResponse.AUTHORIZED);
                return phaseOneQueryInfo;
            }
            phaseOneQueryInfo = PhaseOneQueryInfo.inconclusive((ImmutableList)needSecondPhase);
            return phaseOneQueryInfo;
        }
    }

    private RequestAuthorizationResponse runFirstPhase(AuthRuleEvaluator evaluator, RuleContextBuilderAndResource contextBuilderAndResource) {
        Trackable tracker = contextBuilderAndResource.datastoreRuleContextBuilder.trackDynamicCalls();
        if (contextBuilderAndResource.resourcePath != null) {
            tracker = Trackables.of(contextBuilderAndResource.datastoreRuleContextBuilder.trackResourceAccess(), tracker);
        } else if (contextBuilderAndResource.resource != null) {
            contextBuilderAndResource.datastoreRuleContextBuilder.supplyResource(contextBuilderAndResource.resource);
        }
        return TwoPhaseRulesAuthorizer.evaluateRequest(evaluator, contextBuilderAndResource.datastoreRuleContextBuilder.build(Constants.ActionIds.LIST), tracker);
    }

    private PhaseOneCommitInfo checkCommitPhaseOne(RulesRequestContext requestContext, Write write, AuthRuleEvaluator evaluator) {
        try (GenericStats.StatsAutoCloseable tracker = requestContext.stats().stat(RulesStats.Phase.EVALUATION).enter();){
            PhaseOneCommitInfo phaseOneCommitInfo;
            ImmutableMap.Builder<EntityRef, SinglePhaseRulesAuthorizer.CommitAuthorizationInfo> authorizationStatesBuilder = ImmutableMap.builder();
            for (Mutation mutation : write.mutations()) {
                RequestAuthorizationResponse response = null;
                switch (mutation.op()) {
                    case DELETE: 
                    case DELETE_MUST_NOT_EXIST: 
                    case DELETE_MUST_EXIST: {
                        response = this.evaluateDeleteMutation(requestContext, evaluator, mutation);
                        break;
                    }
                    case INSERT: {
                        if (mutation.allocateKey()) {
                            Preconditions.checkState(V3Paths.hasIncompleteLastElement(mutation.key()), "For auto ids the authorization should happen before id assignment. This is likely because the retry logic do not set proper retry point to skip the authorization in the case of rpc failure.");
                        }
                        response = this.evaluateInsertMutation(requestContext, evaluator, mutation);
                        break;
                    }
                    case UPDATE: {
                        response = this.evaluateUpdateMutation(requestContext, evaluator, mutation);
                        break;
                    }
                    case UPSERT: {
                        response = this.evaluateUpsertMutation(requestContext, evaluator, mutation);
                        break;
                    }
                    case VERIFY_MUST_EXIST: 
                    case VERIFY_MUST_NOT_EXIST: {
                        response = this.evaluateVerifyMutation(requestContext, evaluator, mutation);
                    }
                }
                if (TwoPhaseRulesAuthorizer.canConclusivelyRejectInPhaseOne(response)) {
                    PhaseOneCommitInfo phaseOneCommitInfo2 = PhaseOneCommitInfo.conclusive(response);
                    return phaseOneCommitInfo2;
                }
                authorizationStatesBuilder.put(AppEngV3ResourceRefToRepConverter.convertValidEntityRef(mutation.key(), null), new SinglePhaseRulesAuthorizer.CommitAuthorizationInfo(response, mutation));
            }
            ImmutableMap authorizationStates = authorizationStatesBuilder.build();
            if (authorizationStates.values().stream().allMatch(SinglePhaseRulesAuthorizer.CommitAuthorizationInfo::isAuthorized)) {
                phaseOneCommitInfo = PhaseOneCommitInfo.conclusive(RequestAuthorizationResponse.AUTHORIZED);
                return phaseOneCommitInfo;
            }
            phaseOneCommitInfo = PhaseOneCommitInfo.inconclusive(authorizationStates);
            return phaseOneCommitInfo;
        }
    }

    private RequestAuthorizationResponse evaluateUpdateMutation(RulesRequestContext requestContext, AuthRuleEvaluator evaluator, Mutation mutation) {
        Preconditions.checkArgument(mutation.op().equals((Object)Mutation.Op.UPDATE) || mutation.op().equals((Object)Mutation.Op.UPSERT));
        ImmutableList.Builder<Trackable> trackables = ImmutableList.builder();
        DatastoreRuleContextBuilder contextBuilder = this.makeWriteContext(requestContext, mutation);
        ((ImmutableList.Builder)trackables.add((Object)contextBuilder.trackDynamicCalls())).add(contextBuilder.trackResourceAccess());
        TwoPhaseRulesAuthorizer.addRequestResourceForWrite(mutation, trackables, contextBuilder);
        Trackable trackable = Trackables.of((ImmutableList<Trackable>)trackables.build());
        return TwoPhaseRulesAuthorizer.evaluateRequest(evaluator, contextBuilder.build(Constants.ActionIds.UPDATE), trackable);
    }

    private RequestAuthorizationResponse evaluateInsertMutation(RulesRequestContext requestContext, AuthRuleEvaluator evaluator, Mutation mutation) {
        Preconditions.checkArgument(mutation.op().equals((Object)Mutation.Op.INSERT) || mutation.op().equals((Object)Mutation.Op.UPSERT));
        ImmutableList.Builder<Trackable> trackables = ImmutableList.builder();
        DatastoreRuleContextBuilder contextBuilder = this.makeWriteContext(requestContext, mutation);
        TwoPhaseRulesAuthorizer.addRequestResourceForWrite(mutation, trackables, contextBuilder);
        ((ImmutableList.Builder)trackables.add((Object)contextBuilder.trackDynamicCalls())).add(contextBuilder.trackResourceAccess());
        Trackable trackable = Trackables.of((ImmutableList<Trackable>)trackables.build());
        return TwoPhaseRulesAuthorizer.evaluateRequest(evaluator, contextBuilder.build(Constants.ActionIds.CREATE), trackable);
    }

    private RequestAuthorizationResponse evaluateUpsertMutation(RulesRequestContext requestContext, AuthRuleEvaluator evaluator, Mutation mutation) {
        RequestAuthorizationResponse insert = this.evaluateInsertMutation(requestContext, evaluator, mutation);
        RequestAuthorizationResponse update = this.evaluateUpdateMutation(requestContext, evaluator, mutation);
        if (insert == RequestAuthorizationResponse.AUTHORIZED && update == RequestAuthorizationResponse.AUTHORIZED) {
            return RequestAuthorizationResponse.AUTHORIZED;
        }
        if (insert == RequestAuthorizationResponse.UNAUTHORIZED && update == RequestAuthorizationResponse.UNAUTHORIZED) {
            return RequestAuthorizationResponse.UNAUTHORIZED;
        }
        return RequestAuthorizationResponse.AUTHORIZATION_UNKNOWN;
    }

    private RequestAuthorizationResponse evaluateDeleteMutation(RulesRequestContext requestContext, AuthRuleEvaluator evaluator, Mutation mutation) {
        Preconditions.checkArgument(mutation.op().isDelete());
        ImmutableList.Builder<Trackable> trackables = ImmutableList.builder();
        DatastoreRuleContextBuilder contextBuilder = this.makeWriteContext(requestContext, mutation);
        ((ImmutableList.Builder)trackables.add((Object)contextBuilder.trackDynamicCalls())).add(contextBuilder.trackResourceAccess());
        TwoPhaseRulesAuthorizer.addRequestResourceForWrite(mutation, trackables, contextBuilder);
        Trackable trackable = Trackables.of((ImmutableList<Trackable>)trackables.build());
        return TwoPhaseRulesAuthorizer.evaluateRequest(evaluator, contextBuilder.build(Constants.ActionIds.DELETE), trackable);
    }

    private RequestAuthorizationResponse evaluateVerifyMutation(RulesRequestContext requestContext, AuthRuleEvaluator evaluator, Mutation mutation) {
        Preconditions.checkArgument(mutation.op().isVerify());
        DatastoreRuleContextBuilder rulesContextBuilder = this.makeGetRuleContext(requestContext, PropertyMask.FULL, AppEngV3ResourceRefToRepConverter.convertValidEntityRef(mutation.key(), null));
        Trackable dataAccessTracker = Trackables.of(rulesContextBuilder.trackDynamicCalls(), rulesContextBuilder.trackResourceAccess());
        return TwoPhaseRulesAuthorizer.evaluateRequest(evaluator, rulesContextBuilder.build(Constants.ActionIds.GET), dataAccessTracker);
    }

    private static void addRequestResourceForWrite(Mutation mutation, ImmutableList.Builder<Trackable> trackables, DatastoreRuleContextBuilder contextBuilder) {
        if (mutation.ignoresExistingEntityData()) {
            contextBuilder.supplyRequestResource(mutation.entity());
        } else {
            contextBuilder.supplyRequestField(Constants.RequestFields.RESOURCE, EXPECTED_UNDEFINED);
            trackables.add((Object)contextBuilder.trackRequestVariableAccess());
        }
    }

    private static RequestAuthorizationResponse evaluateRequest(AuthRuleEvaluator evaluator, AuthRuleEvaluator.RuleContext ruleContext, Trackable trackable) {
        try {
            AuthRuleEvaluator.RuleResult result = (AuthRuleEvaluator.RuleResult)evaluator.evaluate(ruleContext).get();
            if (result.permit()) {
                return RequestAuthorizationResponse.AUTHORIZED;
            }
            return RequestAuthorizationResponse.UNAUTHORIZED;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            return trackable.isCalled() ? RequestAuthorizationResponse.AUTHORIZATION_UNKNOWN : RequestAuthorizationResponse.EVALUATION_ERROR;
        }
    }

    private static boolean canConclusivelyRejectInPhaseOne(RequestAuthorizationResponse response) {
        switch (response) {
            case AUTHORIZED: 
            case AUTHORIZATION_UNKNOWN: {
                return false;
            }
            case UNAUTHORIZED: 
            case EVALUATION_ERROR: {
                return true;
            }
        }
        throw new AssertionError((Object)"unreachable");
    }

    private static void logFirstPhaseStat(RulesRequestContext requestContext, RequestAuthorizationResponse result) {
        RulesStats.RuleEvaluationOutcome stat = null;
        switch (result) {
            case AUTHORIZED: {
                stat = RulesStats.RuleEvaluationOutcome.RULES_FIRST_PHASE_ALLOWED;
                break;
            }
            case UNAUTHORIZED: {
                stat = RulesStats.RuleEvaluationOutcome.RULES_FIRST_PHASE_DENIED;
                break;
            }
            case EVALUATION_ERROR: {
                stat = RulesStats.RuleEvaluationOutcome.RULES_FIRST_PHASE_ERROR;
                break;
            }
        }
        if (stat != null) {
            requestContext.stats().stat(RulesStats.Label.RULE_EVALUATION_OUTCOME).set((Object)stat);
        }
    }

    @AutoValue
    static abstract class PhaseOneCommitInfo {
        PhaseOneCommitInfo() {
        }

        abstract RequestAuthorizationResponse requestAuthorizationResponse();

        abstract ImmutableMap<EntityRef, SinglePhaseRulesAuthorizer.CommitAuthorizationInfo> authorizationStates();

        private static PhaseOneCommitInfo conclusive(RequestAuthorizationResponse requestAuthorizationResponse) {
            return new AutoValue_TwoPhaseRulesAuthorizer_PhaseOneCommitInfo(requestAuthorizationResponse, ImmutableMap.of());
        }

        private static PhaseOneCommitInfo inconclusive(ImmutableMap<EntityRef, SinglePhaseRulesAuthorizer.CommitAuthorizationInfo> authorizationStates) {
            return new AutoValue_TwoPhaseRulesAuthorizer_PhaseOneCommitInfo(RequestAuthorizationResponse.AUTHORIZATION_UNKNOWN, authorizationStates);
        }
    }

    @AutoValue
    static abstract class PhaseOneQueryInfo {
        PhaseOneQueryInfo() {
        }

        abstract RequestAuthorizationResponse requestAuthorizationResponse();

        abstract ImmutableList<RuleContextBuilderAndResource> needSecondPhase();

        private static PhaseOneQueryInfo conclusive(RequestAuthorizationResponse requestAuthorizationResponse) {
            return new AutoValue_TwoPhaseRulesAuthorizer_PhaseOneQueryInfo(requestAuthorizationResponse, ImmutableList.of());
        }

        private static PhaseOneQueryInfo inconclusive(ImmutableList<RuleContextBuilderAndResource> needSecondPhase) {
            return new AutoValue_TwoPhaseRulesAuthorizer_PhaseOneQueryInfo(RequestAuthorizationResponse.AUTHORIZATION_UNKNOWN, needSecondPhase);
        }
    }

    @AutoValue
    static abstract class PhaseOneLookupInfo {
        PhaseOneLookupInfo() {
        }

        abstract RequestAuthorizationResponse requestAuthorizationResponse();

        abstract ImmutableMap<EntityRef, RequestAuthorizationResponse> authorizationStates();

        private static PhaseOneLookupInfo conclusive(RequestAuthorizationResponse requestAuthorizationResponse) {
            return new AutoValue_TwoPhaseRulesAuthorizer_PhaseOneLookupInfo(requestAuthorizationResponse, ImmutableMap.of());
        }

        private static PhaseOneLookupInfo inconclusive(ImmutableMap<EntityRef, RequestAuthorizationResponse> authorizationStates) {
            return new AutoValue_TwoPhaseRulesAuthorizer_PhaseOneLookupInfo(RequestAuthorizationResponse.AUTHORIZATION_UNKNOWN, authorizationStates);
        }
    }
}

