/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.cloudv1;

import com.google.cloud.datastore.core.exception.ValidationException;
import com.google.cloud.datastore.core.extractor.Extractor;
import com.google.cloud.datastore.core.rep.DatabaseRef;
import com.google.cloud.datastore.core.rep.validator.DatabaseRefValidator;
import com.google.datastore.v1.AllocateIdsRequest;
import com.google.datastore.v1.BeginTransactionRequest;
import com.google.datastore.v1.CommitRequest;
import com.google.datastore.v1.LookupRequest;
import com.google.datastore.v1.ReserveIdsRequest;
import com.google.datastore.v1.RollbackRequest;
import com.google.datastore.v1.RunQueryRequest;
import com.google.datastore.v1.StreamingWriteRequest;

public class CloudV1DatabaseRefExtractor
extends Extractor<DatabaseRef> {
    public static final CloudV1DatabaseRefExtractor INSTANCE = new CloudV1DatabaseRefExtractor();

    private CloudV1DatabaseRefExtractor() {
    }

    public DatabaseRef extract(BeginTransactionRequest req) throws ValidationException {
        return DatabaseRefValidator.INSTANCE.createAndValidateDatabaseRef(req.getProjectId(), req.getDatabaseId());
    }

    public DatabaseRef extract(RunQueryRequest req) throws ValidationException {
        return DatabaseRefValidator.INSTANCE.createAndValidateDatabaseRef(req.getProjectId(), req.getDatabaseId());
    }

    public DatabaseRef extract(AllocateIdsRequest req) throws ValidationException {
        return DatabaseRefValidator.INSTANCE.createAndValidateDatabaseRef(req.getProjectId(), req.getDatabaseId());
    }

    public DatabaseRef extract(ReserveIdsRequest req) throws ValidationException {
        return DatabaseRefValidator.INSTANCE.createAndValidateDatabaseRef(req.getProjectId(), req.getDatabaseId());
    }

    public DatabaseRef extract(LookupRequest req) throws ValidationException {
        return DatabaseRefValidator.INSTANCE.createAndValidateDatabaseRef(req.getProjectId(), req.getDatabaseId());
    }

    public DatabaseRef extract(RollbackRequest req) throws ValidationException {
        return DatabaseRefValidator.INSTANCE.createAndValidateDatabaseRef(req.getProjectId(), req.getDatabaseId());
    }

    public DatabaseRef extract(CommitRequest req) throws ValidationException {
        return DatabaseRefValidator.INSTANCE.createAndValidateDatabaseRef(req.getProjectId(), req.getDatabaseId());
    }

    public DatabaseRef extract(StreamingWriteRequest req) throws ValidationException {
        return DatabaseRefValidator.INSTANCE.createAndValidateDatabaseRef(req.getProjectId(), req.getDatabaseId());
    }

    public static LookupRequest.Builder set(LookupRequest.Builder request, DatabaseRef internalDatabase) {
        request.setProjectId(internalDatabase.projectId());
        if (!internalDatabase.databaseId().isEmpty()) {
            request.setDatabaseId(internalDatabase.databaseId());
        }
        return request;
    }

    public static CommitRequest.Builder set(CommitRequest.Builder request, DatabaseRef internalDatabase) {
        request.setProjectId(internalDatabase.projectId());
        if (!internalDatabase.databaseId().isEmpty()) {
            request.setDatabaseId(internalDatabase.databaseId());
        }
        return request;
    }

    public static RunQueryRequest.Builder set(RunQueryRequest.Builder request, DatabaseRef internalDatabase) {
        request.setProjectId(internalDatabase.projectId());
        if (!internalDatabase.databaseId().isEmpty()) {
            request.setDatabaseId(internalDatabase.databaseId());
        }
        return request;
    }

    public static BeginTransactionRequest.Builder set(BeginTransactionRequest.Builder request, DatabaseRef internalDatabase) {
        request.setProjectId(internalDatabase.projectId());
        if (!internalDatabase.databaseId().isEmpty()) {
            request.setDatabaseId(internalDatabase.databaseId());
        }
        return request;
    }

    public static RollbackRequest.Builder set(RollbackRequest.Builder request, DatabaseRef internalDatabase) {
        request.setProjectId(internalDatabase.projectId());
        if (!internalDatabase.databaseId().isEmpty()) {
            request.setDatabaseId(internalDatabase.databaseId());
        }
        return request;
    }

    public static AllocateIdsRequest.Builder set(AllocateIdsRequest.Builder request, DatabaseRef internalDatabase) {
        request.setProjectId(internalDatabase.projectId());
        if (!internalDatabase.databaseId().isEmpty()) {
            request.setDatabaseId(internalDatabase.databaseId());
        }
        return request;
    }

    public static ReserveIdsRequest.Builder set(ReserveIdsRequest.Builder request, DatabaseRef internalDatabase) {
        request.setProjectId(internalDatabase.projectId());
        if (!internalDatabase.databaseId().isEmpty()) {
            request.setDatabaseId(internalDatabase.databaseId());
        }
        return request;
    }
}

