/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.cloudv1;

import com.google.cloud.datastore.core.exception.ValidationException;
import com.google.cloud.datastore.core.extractor.Extractor;
import com.google.cloud.datastore.core.internal.Transactions;
import com.google.datastore.v1.AllocateIdsRequest;
import com.google.datastore.v1.BeginTransactionRequest;
import com.google.datastore.v1.CommitRequest;
import com.google.datastore.v1.LookupRequest;
import com.google.datastore.v1.ReadOptions;
import com.google.datastore.v1.ReserveIdsRequest;
import com.google.datastore.v1.RollbackRequest;
import com.google.datastore.v1.RunQueryRequest;
import com.google.datastore.v1.StreamingWriteRequest;
import javax.annotation.Nullable;

public class CloudV1TransactionExtractor
extends Extractor<Long> {
    public static final CloudV1TransactionExtractor INSTANCE = new CloudV1TransactionExtractor();

    private CloudV1TransactionExtractor() {
    }

    @Nullable
    public Long extract(BeginTransactionRequest req) throws ValidationException {
        return null;
    }

    @Nullable
    public Long extract(RunQueryRequest req) throws ValidationException {
        if (req.getReadOptions().getConsistencyTypeCase().equals(ReadOptions.ConsistencyTypeCase.TRANSACTION)) {
            return Transactions.getTransactionHandleLegacy(req.getReadOptions().getTransaction());
        }
        return null;
    }

    @Nullable
    public Long extract(AllocateIdsRequest req) throws ValidationException {
        return null;
    }

    @Nullable
    public Long extract(ReserveIdsRequest req) throws ValidationException {
        return null;
    }

    @Nullable
    public Long extract(LookupRequest req) throws ValidationException {
        if (req.getReadOptions().getConsistencyTypeCase().equals(ReadOptions.ConsistencyTypeCase.TRANSACTION)) {
            return Transactions.getTransactionHandleLegacy(req.getReadOptions().getTransaction());
        }
        return null;
    }

    @Nullable
    public Long extract(RollbackRequest req) throws ValidationException {
        return Transactions.getTransactionHandleLegacy(req.getTransaction());
    }

    @Nullable
    public Long extract(CommitRequest req) throws ValidationException {
        if (req.getTransactionSelectorCase().equals(CommitRequest.TransactionSelectorCase.TRANSACTION)) {
            return Transactions.getTransactionHandleLegacy(req.getTransaction());
        }
        return null;
    }

    @Nullable
    public Long extract(StreamingWriteRequest req) throws ValidationException {
        return null;
    }
}

