/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.cloudv1;

import com.google.cloud.datastore.core.rep.ReservedName;
import com.google.datastore.v1.CompositeFilter;
import com.google.datastore.v1.Filter;
import com.google.datastore.v1.FilterOrBuilder;
import com.google.datastore.v1.Key;
import com.google.datastore.v1.PropertyFilter;
import com.google.datastore.v1.PropertyFilterOrBuilder;
import com.google.datastore.v1.QueryOrBuilder;
import com.google.datastore.v1.Value;

public final class QueryHelper {
    public static boolean hasAncestorOrParent(QueryOrBuilder query) {
        return QueryHelper.getFirstAncestorOrParentKey(query.getFilter()) != null;
    }

    private static Key getFirstAncestorOrParentKey(FilterOrBuilder filter) {
        switch (filter.getFilterTypeCase()) {
            case PROPERTY_FILTER: {
                PropertyFilterOrBuilder propFilter = filter.getPropertyFilterOrBuilder();
                if (propFilter.getPropertyOrBuilder().getName().equals(ReservedName.KEY.asString()) && propFilter.getValue().getValueTypeCase() == Value.ValueTypeCase.KEY_VALUE && (propFilter.getOp() == PropertyFilter.Operator.HAS_ANCESTOR || propFilter.getOp() == PropertyFilter.Operator.HAS_PARENT)) {
                    return propFilter.getValue().getKeyValue();
                }
                return null;
            }
            case COMPOSITE_FILTER: {
                if (filter.getCompositeFilter().getOp() == CompositeFilter.Operator.AND) {
                    for (Filter subFilter : filter.getCompositeFilter().getFiltersList()) {
                        Key ancestor = QueryHelper.getFirstAncestorOrParentKey(subFilter);
                        if (ancestor == null) continue;
                        return ancestor;
                    }
                }
                return null;
            }
            case FILTERTYPE_NOT_SET: {
                return null;
            }
        }
        String string = String.valueOf(filter.getFilterTypeCase());
        throw new IllegalArgumentException(new StringBuilder(26 + String.valueOf(string).length()).append("Unrecognized filter_type: ").append(string).toString());
    }

    private QueryHelper() {
    }
}

