/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.cloudv1.converter;

import com.google.apphosting.datastore.DatastoreV3Pb;
import com.google.cloud.datastore.core.appengv3.LocalTransactionConverter;
import com.google.cloud.datastore.core.cloudv1.converter.AppEngV3ToCloudDatastoreV1Converter;
import com.google.cloud.datastore.core.cloudv1.converter.CloudDatastoreV1ToAppEngV3Converter;
import com.google.cloud.datastore.core.cloudv1.converter.EntityV3V1Converter;
import com.google.cloud.datastore.core.exception.InvalidConversionException;
import com.google.cloud.datastore.core.names.ProjectIdAppIdResolver;
import com.google.common.base.Preconditions;
import com.google.datastore.v1.EntityResult;
import com.google.datastore.v1.Key;
import com.google.datastore.v1.LookupRequestOrBuilder;
import com.google.datastore.v1.LookupResponse;
import com.google.datastore.v1.ReadOptions;
import com.google.datastore.v1.RunQueryRequestOrBuilder;
import com.google.protobuf.ByteString;
import com.google.storage.onestore.v3.OnestoreEntity;
import javax.annotation.Nullable;

public abstract class BaseCloudDatastoreV1Converter {
    public static final String UNKNOWN_PROJECT_ID = "__unknown__";
    protected final LocalTransactionConverter transactionConverter;
    protected final CloudDatastoreV1ToAppEngV3Converter cloudDatastoreV1ToAppEngV3Converter;
    protected final AppEngV3ToCloudDatastoreV1Converter appEngV3ToCloudDatastoreV1Converter;

    public BaseCloudDatastoreV1Converter(LocalTransactionConverter transactionConverter, CloudDatastoreV1ToAppEngV3Converter cloudDatastoreV1ToAppEngV3Converter, AppEngV3ToCloudDatastoreV1Converter appEngV3ToCloudDatastoreV1Converter) {
        this.transactionConverter = transactionConverter;
        this.cloudDatastoreV1ToAppEngV3Converter = cloudDatastoreV1ToAppEngV3Converter;
        this.appEngV3ToCloudDatastoreV1Converter = appEngV3ToCloudDatastoreV1Converter;
    }

    public DatastoreV3Pb.GetRequest toV3GetRequest(ProjectIdAppIdResolver resolver, LookupRequestOrBuilder req, @Nullable ByteString newTxnBytes, String appId, String databaseId) throws InvalidConversionException {
        ReadOptions.ConsistencyTypeCase consistencyType = req.getReadOptions().getConsistencyTypeCase();
        Preconditions.checkArgument(newTxnBytes != null == (consistencyType == ReadOptions.ConsistencyTypeCase.NEW_TRANSACTION));
        DatastoreV3Pb.GetRequest get = new DatastoreV3Pb.GetRequest();
        get.setAllowDeferred(true);
        block0 : switch (consistencyType) {
            case CONSISTENCYTYPE_NOT_SET: {
                break;
            }
            case NEW_TRANSACTION: {
                get.setTransaction(this.transactionConverter.toV3Transaction(newTxnBytes, appId, databaseId));
                break;
            }
            case TRANSACTION: {
                get.setTransaction(this.transactionConverter.toV3Transaction(req.getReadOptions().getTransaction(), appId, databaseId));
                break;
            }
            case READ_CONSISTENCY: {
                ReadOptions.ReadConsistency readConsistency = req.getReadOptionsOrBuilder().getReadConsistency();
                switch (readConsistency) {
                    case READ_CONSISTENCY_UNSPECIFIED: {
                        break block0;
                    }
                    case STRONG: {
                        get.setStrong(true);
                        break block0;
                    }
                    case EVENTUAL: {
                        get.setStrong(false);
                        get.setFailoverMs(-1L);
                        break block0;
                    }
                    case UNRECOGNIZED: {
                        throw new IllegalArgumentException(String.format("Unhandled read consistency: %s", readConsistency.name()));
                    }
                }
            }
        }
        for (Key key : req.getKeysList()) {
            get.addKey(EntityV3V1Converter.INSTANCE.toV3Reference(resolver, key));
        }
        return get;
    }

    public LookupResponse.Builder toV1LookupResponse(ProjectIdAppIdResolver resolver, DatastoreV3Pb.GetResponse res, @Nullable ByteString adHocTxn) throws InvalidConversionException {
        LookupResponse.Builder builder = LookupResponse.newBuilder();
        if (adHocTxn != null) {
            builder.setTransaction(adHocTxn);
        }
        for (OnestoreEntity.Reference key : res.deferreds()) {
            builder.addDeferred(EntityV3V1Converter.INSTANCE.toV1Key(resolver, key));
        }
        for (DatastoreV3Pb.GetResponse.Entity entity : res.entitys()) {
            EntityResult.Builder entityResult = this.appEngV3ToCloudDatastoreV1Converter.toV1EntityResult(resolver, entity);
            if (entity.hasEntity()) {
                builder.addFound(entityResult);
            }
            if (!entity.hasKey()) continue;
            builder.addMissing(entityResult);
        }
        return builder;
    }

    public DatastoreV3Pb.Query toV3Query(ProjectIdAppIdResolver resolver, RunQueryRequestOrBuilder request, @Nullable ByteString newTxnBytes, boolean allowInMemoryOperations) throws InvalidConversionException {
        ReadOptions.ConsistencyTypeCase consistencyType = request.getReadOptions().getConsistencyTypeCase();
        Preconditions.checkArgument(newTxnBytes != null == (consistencyType == ReadOptions.ConsistencyTypeCase.NEW_TRANSACTION));
        DatastoreV3Pb.Query result = this.cloudDatastoreV1ToAppEngV3Converter.toV3Query(resolver, request.getPartitionIdOrBuilder(), request.getQuery());
        result.setCount(Integer.MAX_VALUE);
        result.setRequirePerfectPlan(!allowInMemoryOperations);
        block0 : switch (consistencyType) {
            case CONSISTENCYTYPE_NOT_SET: {
                break;
            }
            case NEW_TRANSACTION: {
                result.setTransaction(this.transactionConverter.toV3Transaction(newTxnBytes, result.getApp(), result.getDatabaseId()));
                break;
            }
            case TRANSACTION: {
                result.setTransaction(this.transactionConverter.toV3Transaction(request.getReadOptions().getTransaction(), result.getApp(), result.getDatabaseId()));
                break;
            }
            case READ_CONSISTENCY: {
                ReadOptions.ReadConsistency readConsistency = request.getReadOptionsOrBuilder().getReadConsistency();
                switch (readConsistency) {
                    case READ_CONSISTENCY_UNSPECIFIED: {
                        break block0;
                    }
                    case STRONG: {
                        result.setStrong(true);
                        break block0;
                    }
                    case EVENTUAL: {
                        result.setStrong(false);
                        result.setFailoverMs(-1L);
                        break block0;
                    }
                    case UNRECOGNIZED: {
                        throw new IllegalArgumentException(String.format("Unhandled read consistency: %s", readConsistency.name()));
                    }
                }
            }
        }
        return result;
    }
}

