/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.cloudv1.converter;

import com.google.cloud.datastore.core.rep.PropertyMask;
import com.google.cloud.datastore.core.rep.PropertyName;
import com.google.common.collect.ImmutableSet;
import javax.annotation.Nullable;

public class CloudDatastoreV1PropertyPathFromRepConverter {
    public static final CloudDatastoreV1PropertyPathFromRepConverter INSTANCE = new CloudDatastoreV1PropertyPathFromRepConverter();

    private CloudDatastoreV1PropertyPathFromRepConverter() {
    }

    @Nullable
    public ImmutableSet<String> convertPropertyMaskToPropertyPathStringSet(PropertyMask propertyMask) {
        if (propertyMask.equals(PropertyMask.FULL)) {
            return null;
        }
        ImmutableSet.Builder<String> propertyPathStringSetBuilder = ImmutableSet.builder();
        StringBuilder stringBuilder = new StringBuilder();
        this.convertPropertyMaskToPropertyPathStringSetHelper(propertyPathStringSetBuilder, stringBuilder, propertyMask);
        return propertyPathStringSetBuilder.build();
    }

    private void convertPropertyMaskToPropertyPathStringSetHelper(ImmutableSet.Builder<String> propertyPathStringSetBuilder, StringBuilder stringBuilder, PropertyMask propertyMask) {
        int saveStringBuilderLength = stringBuilder.length();
        for (PropertyName propertyName : propertyMask.propertyNames()) {
            this.convertPropertyNameHelper(stringBuilder, propertyName);
            PropertyMask nestedMask = propertyMask.nestedMask(propertyName);
            if (nestedMask.equals(PropertyMask.FULL)) {
                propertyPathStringSetBuilder.add((Object)stringBuilder.toString());
            } else {
                stringBuilder.append('.');
                this.convertPropertyMaskToPropertyPathStringSetHelper(propertyPathStringSetBuilder, stringBuilder, nestedMask);
            }
            stringBuilder.setLength(saveStringBuilderLength);
        }
    }

    public String convertPropertyName(PropertyName propertyName) {
        StringBuilder stringBuilder = new StringBuilder();
        this.convertPropertyNameHelper(stringBuilder, propertyName);
        return stringBuilder.toString();
    }

    private void convertPropertyNameHelper(StringBuilder stringBuilder, PropertyName propertyName) {
        String stringPropertyName = propertyName.string();
        int numChars = stringPropertyName.length();
        for (int index = 0; index < numChars; ++index) {
            char character = stringPropertyName.charAt(index);
            if (character == '.' || character == '\\') {
                stringBuilder.append('\\');
            }
            stringBuilder.append(character);
        }
    }
}

