/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.cloudv1.converter;

import com.google.cloud.datastore.core.exception.InvalidConversionException;
import com.google.cloud.datastore.core.rep.PropertyMask;
import com.google.cloud.datastore.core.rep.PropertyName;
import com.google.cloud.datastore.core.rep.PropertyPath;
import com.google.cloud.datastore.core.rep.PropertyPathSegment;
import com.google.cloud.datastore.core.rep.SpecialPropertyDescriptor;
import com.google.cloud.datastore.core.rep.converter.PropertyPathToMaskConverter;
import com.google.cloud.datastore.core.rep.validator.ValidationConstraint;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;

public class CloudDatastoreV1PropertyPathToRepConverter {
    private final PropertyPathToMaskConverter propertyPathToMaskConverter;

    public CloudDatastoreV1PropertyPathToRepConverter(PropertyPathToMaskConverter propertyPathToMaskConverter) {
        this.propertyPathToMaskConverter = Preconditions.checkNotNull(propertyPathToMaskConverter);
    }

    public PropertyMask convertPropertyMask(com.google.datastore.v1.PropertyMask apiPropertyMask, ValidationConstraint constraint) throws InvalidConversionException {
        ArrayList<PropertyPath> propertyPaths = new ArrayList<PropertyPath>();
        for (String apiPropertyPath : apiPropertyMask.getPathsList()) {
            PropertyPath propertyPath = this.convertPropertyPath(apiPropertyPath);
            if (propertyPath.isKey()) continue;
            propertyPaths.add(propertyPath);
        }
        return this.propertyPathToMaskConverter.validateAndConvertPathsToMask(propertyPaths, constraint);
    }

    public PropertyPath convertPropertyPath(String apiPropertyPath) throws InvalidConversionException {
        int numPropertyPathChars = apiPropertyPath.length();
        InvalidConversionException.checkConversion(numPropertyPathChars != 0, "a property path must not be empty.", new Object[0]);
        ArrayList<PropertyPathSegment> segments = new ArrayList<PropertyPathSegment>();
        StringBuilder propertyNameBuilder = new StringBuilder();
        for (int apiPropertyPathIndex = 0; apiPropertyPathIndex < numPropertyPathChars; ++apiPropertyPathIndex) {
            char c = apiPropertyPath.charAt(apiPropertyPathIndex);
            if (c == '.') {
                this.addPropertyName(segments, propertyNameBuilder);
                continue;
            }
            if (c == '\\') {
                InvalidConversionException.checkConversion(++apiPropertyPathIndex < numPropertyPathChars, "property path ends in %c", Character.valueOf('\\'));
                c = apiPropertyPath.charAt(apiPropertyPathIndex);
                InvalidConversionException.checkConversion(c == '.' || c == '\\', "unnown escaped character %c in property path", Character.valueOf(c));
            }
            propertyNameBuilder.append(c);
        }
        this.addPropertyName(segments, propertyNameBuilder);
        return PropertyPath.createFromSegments(segments);
    }

    private void addPropertyName(List<PropertyPathSegment> segments, StringBuilder propertyNameBuilder) throws InvalidConversionException {
        InvalidConversionException.checkConversion(propertyNameBuilder.length() > 0, "property path contains empty name", new Object[0]);
        PropertyName propertyName = PropertyName.create(propertyNameBuilder.toString());
        SpecialPropertyDescriptor special = propertyName.special();
        InvalidConversionException.checkConversion(special != SpecialPropertyDescriptor.KIND && special != SpecialPropertyDescriptor.SCATTER && special != SpecialPropertyDescriptor.SPLITS && special != SpecialPropertyDescriptor.UNAPPLIED_LOG_TIMESTAMP_US, "property path contains reserved name", new Object[0]);
        propertyNameBuilder.setLength(0);
        segments.add(PropertyPathSegment.Member.create(propertyName));
    }
}

