/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.cloudv1.converter;

import com.google.cloud.datastore.core.common.DatastoreCoreConfig;
import com.google.cloud.datastore.core.rep.DatabaseRef;
import com.google.cloud.datastore.core.rep.EntityRef;
import com.google.cloud.datastore.core.rep.PartitionRef;
import com.google.cloud.datastore.core.rep.Value;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.datastore.v1.ArrayValue;
import com.google.datastore.v1.Entity;
import com.google.datastore.v1.Key;
import com.google.datastore.v1.PartitionId;
import com.google.datastore.v1.Value;
import com.google.protobuf.NullValue;
import java.util.Map;

public class CloudV1EntityFromRepConverter {
    public static final CloudV1EntityFromRepConverter INSTANCE = new CloudV1EntityFromRepConverter();

    private CloudV1EntityFromRepConverter() {
    }

    public Entity convertEntity(com.google.cloud.datastore.core.rep.Entity entity) {
        Entity.Builder apiEntityBuilder = this.partConvertPropertyMap(entity.propertyMap());
        apiEntityBuilder.setKey(this.convertEntityRef(entity.ref()));
        return apiEntityBuilder.build();
    }

    private Entity.Builder partConvertPropertyMap(ImmutableMap<String, Value> propertyMap) {
        Entity.Builder apiEntityBuilder = Entity.newBuilder();
        for (Map.Entry entry : propertyMap.entrySet()) {
            String propertyName = (String)entry.getKey();
            Value value = (Value)entry.getValue();
            apiEntityBuilder.putProperties(propertyName, this.convertValue(value));
        }
        return apiEntityBuilder;
    }

    public Key convertEntityRef(EntityRef entityRef) {
        Key.Builder apiEntityRefBuilder = Key.newBuilder();
        apiEntityRefBuilder.setPartitionId(this.convertPartitionRef(entityRef.partitionRef()));
        for (EntityRef.PathElement entityRefPathElement : entityRef.path().elements()) {
            apiEntityRefBuilder.addPath(this.convertEntityRefPathElement(entityRefPathElement));
        }
        return apiEntityRefBuilder.build();
    }

    private PartitionId convertPartitionRef(PartitionRef partitionRef) {
        DatabaseRef databaseRef = partitionRef.databaseRef();
        return PartitionId.newBuilder().setProjectId(databaseRef.projectId()).setDatabaseId(databaseRef.databaseId()).setNamespaceId(partitionRef.namespace()).build();
    }

    private Key.PathElement convertEntityRefPathElement(EntityRef.PathElement entityRefPathElement) {
        Key.PathElement.Builder apiEntityRefPathElementBuilder = Key.PathElement.newBuilder();
        apiEntityRefPathElementBuilder.setKind(entityRefPathElement.collectionId());
        EntityRef.ResourceId resourceId = entityRefPathElement.resourceId();
        if (resourceId != null) {
            if (resourceId.isString()) {
                apiEntityRefPathElementBuilder.setName(resourceId.asString());
            } else if (resourceId.isLong()) {
                apiEntityRefPathElementBuilder.setId(resourceId.asLong());
            }
        }
        return apiEntityRefPathElementBuilder.build();
    }

    public com.google.datastore.v1.Value convertValue(Value value) {
        Value.Builder apiValueBuilder = com.google.datastore.v1.Value.newBuilder();
        Value.Meaning meaning = value.meaning();
        int apiMeaning = meaning.ordinal();
        block0 : switch (value.type()) {
            case NULL: {
                apiValueBuilder.setNullValue(NullValue.NULL_VALUE);
                break;
            }
            case BOOLEAN: {
                apiValueBuilder.setBooleanValue(value.asBoolean());
                break;
            }
            case LONG: {
                apiValueBuilder.setIntegerValue(value.asLong());
                break;
            }
            case DOUBLE: {
                apiValueBuilder.setDoubleValue(value.asDouble());
                break;
            }
            case TIMESTAMP: {
                apiValueBuilder.setTimestampValue(value.asTimestamp());
                break;
            }
            case STRING: {
                apiValueBuilder.setStringValue(value.asString());
                break;
            }
            case BYTES: {
                apiValueBuilder.setBlobValue(value.asBytes());
                if (DatastoreCoreConfig.cloudV1EnableNonUtf8StringMeanings) break;
                switch (meaning) {
                    case INVALID_ENTITY_PROTO_BYTES: 
                    case NON_UTF8_BLOB_WITH_APP_ENG_V3_MEANING_NONE: {
                        apiMeaning = 0;
                        break block0;
                    }
                    case NON_UTF8_BLOB_WITH_APP_ENG_V3_MEANING_TEXT: {
                        apiMeaning = Value.Meaning.BYTESTRING.ordinal();
                        break block0;
                    }
                }
                break;
            }
            case ENTITY_REF: {
                apiValueBuilder.setKeyValue(this.convertEntityRef(value.asEntityRef()));
                break;
            }
            case GEO_POINT: {
                apiValueBuilder.setGeoPointValue(value.asGeoPoint());
                break;
            }
            case ARRAY: {
                apiValueBuilder.setArrayValue(this.convertArray(value.asArray()));
                break;
            }
            case MAP: {
                apiValueBuilder.setEntityValue(this.partConvertPropertyMap(value.asMap()).build());
                break;
            }
            case ENTITY: {
                apiValueBuilder.setEntityValue(this.convertEntity(value.asEntity()));
                break;
            }
            case LEGACY_USER: {
                Preconditions.checkArgument(apiMeaning == 0, "Legacy user value has unexpected meaning.");
                apiMeaning = Value.Meaning.LEGACY_USER_ENTITY.ordinal();
                apiValueBuilder.setEntityValue(this.convertLegacyUser(value.asLegacyUser()));
                break;
            }
            case LEGACY_TIMESTAMP_MICROSECONDS: {
                Preconditions.checkArgument(apiMeaning == 0, "Legacy timestamp microseconds value has unexpected meaning.");
                apiMeaning = Value.Meaning.GD_WHEN.ordinal();
                apiValueBuilder.setIntegerValue(value.asLegacyTimestampMicroseconds());
                break;
            }
            default: {
                throw new IllegalArgumentException("Value has unexpected type.");
            }
        }
        apiValueBuilder.setMeaning(apiMeaning);
        switch (value.datastoreIndexing()) {
            case INCLUDE: {
                apiValueBuilder.setExcludeFromIndexes(false);
                break;
            }
            case EXCLUDE: {
                apiValueBuilder.setExcludeFromIndexes(true);
                break;
            }
            default: {
                throw new IllegalArgumentException("Value has unexpected datastore indexing.");
            }
        }
        return apiValueBuilder.build();
    }

    private ArrayValue convertArray(ImmutableList<Value> elements) {
        ArrayValue.Builder apiArrayValueBuilder = ArrayValue.newBuilder();
        for (Value element : elements) {
            apiArrayValueBuilder.addValues(this.convertValue(element));
        }
        return apiArrayValueBuilder.build();
    }

    private Entity convertLegacyUser(Value.LegacyUser legacyUser) {
        String federatedProvider;
        String federatedIdentity;
        Entity.Builder apiEntityBuilder = Entity.newBuilder();
        apiEntityBuilder.putProperties("email", this.cloudV1ValueWrapLegacyUserString(legacyUser.email()));
        apiEntityBuilder.putProperties("auth_domain", this.cloudV1ValueWrapLegacyUserString(legacyUser.authDomain()));
        String obfuscatedGaiaId = legacyUser.obfuscatedGaiaId();
        if (!obfuscatedGaiaId.isEmpty()) {
            apiEntityBuilder.putProperties("user_id", this.cloudV1ValueWrapLegacyUserString(obfuscatedGaiaId));
        }
        if ((federatedIdentity = legacyUser.federatedIdentity()) != null) {
            apiEntityBuilder.putProperties("federated_identity", this.cloudV1ValueWrapLegacyUserString(federatedIdentity));
        }
        if ((federatedProvider = legacyUser.federatedProvider()) != null) {
            apiEntityBuilder.putProperties("federated_provider", this.cloudV1ValueWrapLegacyUserString(federatedProvider));
        }
        return apiEntityBuilder.build();
    }

    private com.google.datastore.v1.Value cloudV1ValueWrapLegacyUserString(String string) {
        return com.google.datastore.v1.Value.newBuilder().setStringValue(string).setExcludeFromIndexes(true).build();
    }
}

