/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.cloudv1.converter;

import com.google.cloud.datastore.core.common.DatastoreCoreConfig;
import com.google.cloud.datastore.core.exception.InvalidConversionException;
import com.google.cloud.datastore.core.names.ProjectIdAppIdResolver;
import com.google.cloud.datastore.core.rep.DatabaseRef;
import com.google.cloud.datastore.core.rep.EntityRef;
import com.google.cloud.datastore.core.rep.PartitionRef;
import com.google.cloud.datastore.core.rep.Value;
import com.google.cloud.datastore.core.rep.converter.ConverterHelper;
import com.google.cloud.datastore.core.rep.converter.UserIdObfuscator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.datastore.v1.ArrayValue;
import com.google.datastore.v1.Entity;
import com.google.datastore.v1.Key;
import com.google.datastore.v1.PartitionId;
import com.google.datastore.v1.Value;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class CloudV1EntityToRepConverter {
    private final ProjectIdAppIdResolver projectAppIdResolver;
    private final UserIdObfuscator userIdObfuscator;
    private static final ImmutableSet<String> LEGACY_USER_PROPERTY_NAMES = ImmutableSet.of("email", "auth_domain", "user_id", "internal_id", "federated_identity", "federated_provider", new String[0]);

    public CloudV1EntityToRepConverter(ProjectIdAppIdResolver projectAppIdResolver, UserIdObfuscator userIdObfuscator) {
        this.projectAppIdResolver = projectAppIdResolver;
        this.userIdObfuscator = userIdObfuscator;
    }

    public com.google.cloud.datastore.core.rep.Entity convertEntity(Entity apiEntity) throws InvalidConversionException {
        return com.google.cloud.datastore.core.rep.Entity.create(this.convertEntityRef(apiEntity.getKey()), this.convertMap(apiEntity.getProperties()));
    }

    public EntityRef convertEntityRef(Key apiEntityRef) throws InvalidConversionException {
        return EntityRef.create(this.convertPartitionRef(apiEntityRef.getPartitionId()), this.convertEntityRefPathElements(apiEntityRef.getPathList()));
    }

    private PartitionRef convertPartitionRef(PartitionId apiPartitionId) throws InvalidConversionException {
        String projectId = apiPartitionId.getProjectId();
        String appId = projectId.isEmpty() ? "" : this.projectAppIdResolver.toAppId(projectId);
        return PartitionRef.createFromDatabaseRefAndNamespace(DatabaseRef.createForApp(appId, apiPartitionId.getDatabaseId()), apiPartitionId.getNamespaceId());
    }

    private ImmutableList<EntityRef.PathElement> convertEntityRefPathElements(List<Key.PathElement> apiEntityRefPathElements) throws InvalidConversionException {
        InvalidConversionException.checkConversion(!apiEntityRefPathElements.isEmpty(), "Empty entity key path.", new Object[0]);
        ImmutableList.Builder entityRefPathElements = ImmutableList.builder();
        for (Key.PathElement apiEntityRefPathElement : apiEntityRefPathElements) {
            entityRefPathElements.add(this.convertEntityRefPathElement(apiEntityRefPathElement));
        }
        return entityRefPathElements.build();
    }

    private EntityRef.PathElement convertEntityRefPathElement(Key.PathElement apiEntityRefPathElement) throws InvalidConversionException {
        EntityRef.ResourceId resourceId;
        String collectionId = apiEntityRefPathElement.getKind();
        switch (apiEntityRefPathElement.getIdTypeCase()) {
            case IDTYPE_NOT_SET: {
                resourceId = null;
                break;
            }
            case ID: {
                resourceId = EntityRef.ResourceId.createLong(apiEntityRefPathElement.getId());
                break;
            }
            case NAME: {
                resourceId = EntityRef.ResourceId.createString(apiEntityRefPathElement.getName());
                break;
            }
            default: {
                throw new InvalidConversionException("Unknown property path Key.PathElement id_type.");
            }
        }
        return EntityRef.PathElement.create(collectionId, resourceId);
    }

    public Value convertValue(com.google.datastore.v1.Value apiValue) throws InvalidConversionException {
        Value value;
        int apiMeaning = apiValue.getMeaning();
        Value.ValueTypeCase apiValueTypeCase = apiValue.getValueTypeCase();
        switch (apiValueTypeCase) {
            case NULL_VALUE: {
                value = Value.NULL;
                break;
            }
            case BOOLEAN_VALUE: {
                value = Value.createBoolean(apiValue.getBooleanValue());
                break;
            }
            case INTEGER_VALUE: {
                long longValue = apiValue.getIntegerValue();
                if (apiMeaning == Value.Meaning.GD_WHEN.ordinal()) {
                    apiMeaning = 0;
                    value = Value.createLegacyTimestampMicroseconds(longValue);
                    break;
                }
                value = Value.createLong(longValue);
                break;
            }
            case DOUBLE_VALUE: {
                value = Value.createDouble(apiValue.getDoubleValue());
                break;
            }
            case TIMESTAMP_VALUE: {
                value = Value.createTimestamp(apiValue.getTimestampValue());
                break;
            }
            case KEY_VALUE: {
                value = Value.createEntityRef(this.convertEntityRef(apiValue.getKeyValue()));
                break;
            }
            case STRING_VALUE: {
                value = Value.createString(apiValue.getStringValue());
                break;
            }
            case BLOB_VALUE: {
                if (!DatastoreCoreConfig.cloudV1EnableNonUtf8StringMeanings) {
                    InvalidConversionException.checkConversion(apiMeaning != Value.Meaning.NON_UTF8_BLOB_WITH_APP_ENG_V3_MEANING_NONE.ordinal() && apiMeaning != Value.Meaning.NON_UTF8_BLOB_WITH_APP_ENG_V3_MEANING_TEXT.ordinal(), "Blob value has non-UTF-8 meaning but that feature is not enabled for Cloud V1.", new Object[0]);
                    InvalidConversionException.checkConversion(apiMeaning != Value.Meaning.INVALID_ENTITY_PROTO_BYTES.ordinal(), "Blob value has invalid entity proto meaning but that feature is not enabled for Cloud V1.", new Object[0]);
                }
                value = Value.createBytes(apiValue.getBlobValue());
                break;
            }
            case GEO_POINT_VALUE: {
                value = Value.createGeoPoint(apiValue.getGeoPointValue());
                break;
            }
            case ENTITY_VALUE: {
                boolean isLegacyUser;
                Entity apiEntity = apiValue.getEntityValue();
                boolean bl = isLegacyUser = apiMeaning == Value.Meaning.LEGACY_USER_ENTITY.ordinal();
                if (apiEntity.getKey().equals(Key.getDefaultInstance())) {
                    Map<String, com.google.datastore.v1.Value> apiProperties = apiEntity.getProperties();
                    if (isLegacyUser) {
                        apiMeaning = 0;
                        value = Value.createLegacyUser(this.convertLegacyUser(apiProperties));
                        break;
                    }
                    value = Value.createMap(this.convertMap(apiProperties));
                    break;
                }
                InvalidConversionException.checkConversion(!isLegacyUser, "Entity has meaning legacy user and a non-default key.", new Object[0]);
                value = Value.createEntity(this.convertEntity(apiEntity));
                break;
            }
            case ARRAY_VALUE: {
                InvalidConversionException.checkConversion(!apiValue.getExcludeFromIndexes(), "Array value excluded from indexes.", new Object[0]);
                value = Value.createArray(this.convertArray(apiValue.getArrayValue()));
                break;
            }
            default: {
                String string = String.valueOf(apiValueTypeCase);
                throw new InvalidConversionException(new StringBuilder(25 + String.valueOf(string).length()).append("Unrecognized value_type: ").append(string).toString());
            }
        }
        Value.DatastoreIndexing datastoreIndexing = apiValue.getExcludeFromIndexes() ? Value.DatastoreIndexing.EXCLUDE : Value.DatastoreIndexing.INCLUDE;
        return ConverterHelper.valueAddLongMeaning(value, apiMeaning).withDatastoreIndexing(datastoreIndexing);
    }

    private ImmutableList<Value> convertArray(ArrayValue apiArrayValue) throws InvalidConversionException {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        for (com.google.datastore.v1.Value apiElementValue : apiArrayValue.getValuesList()) {
            listBuilder.add(this.convertValue(apiElementValue));
        }
        return listBuilder.build();
    }

    private ImmutableMap<String, Value> convertMap(Map<String, com.google.datastore.v1.Value> apiMap) throws InvalidConversionException {
        ImmutableMap.Builder<String, Value> mapBuilder = ImmutableMap.builder();
        for (Map.Entry<String, com.google.datastore.v1.Value> entry : apiMap.entrySet()) {
            String name = entry.getKey();
            com.google.datastore.v1.Value apiValue = entry.getValue();
            mapBuilder.put(name, this.convertValue(apiValue));
        }
        return mapBuilder.build();
    }

    private Value.LegacyUser convertLegacyUser(Map<String, com.google.datastore.v1.Value> legacyUserProperties) throws InvalidConversionException {
        HashSet<String> propertyNameSet = new HashSet<String>(legacyUserProperties.keySet());
        propertyNameSet.removeAll(LEGACY_USER_PROPERTY_NAMES);
        if (!propertyNameSet.isEmpty()) {
            throw new InvalidConversionException(String.format("Legacy user value contains unexpected property %s.", propertyNameSet.iterator().next()));
        }
        String email = this.legacyUserValueRequiredStringProperty(legacyUserProperties, "email");
        String authDomain = this.legacyUserValueRequiredStringProperty(legacyUserProperties, "auth_domain");
        String userId = this.legacyUserValueOptionalStringProperty(legacyUserProperties, "user_id");
        String federatedId = this.legacyUserValueOptionalStringProperty(legacyUserProperties, "federated_identity");
        String federatedProvider = this.legacyUserValueOptionalStringProperty(legacyUserProperties, "federated_provider");
        if (userId != null) {
            long gaiaId = this.userIdObfuscator.unobfuscate(userId);
            return Value.LegacyUser.create(email, authDomain, gaiaId, userId, federatedId, federatedProvider);
        }
        return Value.LegacyUser.create(email, authDomain, 0L, "", federatedId, federatedProvider);
    }

    private String legacyUserValueRequiredStringProperty(Map<String, com.google.datastore.v1.Value> legacyUserProperties, String propertyName) throws InvalidConversionException {
        String apiValue = this.legacyUserValueOptionalStringProperty(legacyUserProperties, propertyName);
        InvalidConversionException.checkConversion(apiValue != null, "Legacy user value missing property %s.", propertyName);
        return apiValue;
    }

    @Nullable
    private String legacyUserValueOptionalStringProperty(Map<String, com.google.datastore.v1.Value> legacyUserProperties, String propertyName) throws InvalidConversionException {
        com.google.datastore.v1.Value apiValue = legacyUserProperties.get(propertyName);
        if (apiValue == null) {
            return null;
        }
        InvalidConversionException.checkConversion(apiValue.getValueTypeCase() == Value.ValueTypeCase.STRING_VALUE, "Legacy user value property %s is not a string.", propertyName);
        int apiMeaning = apiValue.getMeaning();
        InvalidConversionException.checkConversion(apiMeaning == 0, "Legacy user value property %s has unexpected meaning %d.", propertyName, apiMeaning);
        InvalidConversionException.checkConversion(apiValue.getExcludeFromIndexes(), "Legacy user value property %s does not set exclude_from_indexes.", propertyName);
        return apiValue.getStringValue();
    }
}

