/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.config;

import com.google.apphosting.datastore.shared.Config;
import com.google.cloud.datastore.core.config.proto1api.DatastoreCustomizableConfigPb;
import com.google.common.base.Suppliers;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public final class DatastoreCustomizableConfigUtils {
    public static final Supplier<DatastoreCustomizableConfigPb.DatastoreCustomizableConfig> PERMISSIVE_INSTANCE = Suppliers.memoize(DatastoreCustomizableConfigUtils::createPermissiveInstance);
    public static final Supplier<DatastoreCustomizableConfigPb.DatastoreCustomizableConfig> STRICT_VALIDATION_INSTANCE = Suppliers.memoize(DatastoreCustomizableConfigUtils::createStrictValidationInstance);

    private DatastoreCustomizableConfigUtils() {
    }

    public static DatastoreCustomizableConfigPb.DatastoreCustomizableConfig getCustomizableConfig(Config.DatastoreConfig config, @Nullable DatastoreCustomizableConfigPb.DatastoreCustomizableConfig configOverrides) {
        if (configOverrides == null) {
            return config.getCustomizableConfig();
        }
        return config.getCustomizableConfig().toBuilder().mergeFrom(configOverrides).build();
    }

    private static DatastoreCustomizableConfigPb.DatastoreCustomizableConfig createPermissiveInstance() {
        return DatastoreCustomizableConfigPb.DatastoreCustomizableConfig.newBuilder().setEnableAppEngV3ValidateEntityRefIntraPartition(false).setEnableAppEngV3ValidateGeoPoint(false).setEnableAppEngV3ValidateKeyNameUtf8(false).setEnableAppEngV3ValidateKindUtf8(false).setEnableAppEngV3ValidateValueStringUtf8(false).setEnableAppEngV3ValidateValueStringUtf8WithMeaning(false).setEnableAppEngV3ValidatorValidateValueMeaningMatchesType(false).setEnableValidateGeoPointSameMeaning(false).setMaxEntityKeySizeBytes(0).setMaxIndexEntriesCountPerEntity(0).setMaxIndexEntriesBytesPerEntity(0).build();
    }

    private static DatastoreCustomizableConfigPb.DatastoreCustomizableConfig createStrictValidationInstance() {
        return DatastoreCustomizableConfigPb.DatastoreCustomizableConfig.newBuilder().setEnableAppEngV3ValidateEntityRefIntraPartition(true).setEnableAppEngV3ValidateGeoPoint(true).setEnableAppEngV3ValidateKeyNameUtf8(true).setEnableAppEngV3ValidateKindUtf8(true).setEnableAppEngV3ValidateValueStringUtf8(true).setEnableAppEngV3ValidateValueStringUtf8WithMeaning(true).setEnableAppEngV3ValidatorValidateValueMeaningMatchesType(true).setEnableValidateGeoPointSameMeaning(true).setMaxEntityKeySizeBytes(0).setMaxIndexEntriesCountPerEntity(40000).setMaxIndexEntriesBytesPerEntity(0x800000).build();
    }
}

