/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.extractor;

import com.google.cloud.datastore.core.exception.DatastoreException;
import com.google.cloud.datastore.core.exception.DatastoreExceptionHelper;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.MessageLite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.annotation.Nullable;

public abstract class Extractor<T> {
    private final Class<T> returnType;
    private final ImmutableMap<Class<? extends MessageLite>, MethodHandle> extractors;

    protected Extractor() {
        Class inferredType;
        Class<?> subclass = this.getClass();
        while (!subclass.getSuperclass().equals(Extractor.class)) {
            subclass = subclass.getSuperclass();
        }
        Type superclass = subclass.getGenericSuperclass();
        this.returnType = inferredType = (Class)((ParameterizedType)superclass).getActualTypeArguments()[0];
        ImmutableMap.Builder<Class<MessageLite>, MethodHandle> mapBuilder = ImmutableMap.builder();
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        MethodType adaptedType = MethodType.methodType(Object.class, Extractor.class, MessageLite.class);
        for (Method method : this.getClass().getMethods()) {
            if (!method.getReturnType().equals(this.returnType) || !method.getName().equals("extract") || method.getParameterTypes().length != 1 || !MessageLite.class.isAssignableFrom(method.getParameterTypes()[0])) continue;
            Preconditions.checkArgument(!Modifier.isStatic(method.getModifiers()));
            try {
                MethodHandle handle = lookup.unreflect(method).asType(adaptedType);
                mapBuilder.put(method.getParameterTypes()[0].asSubclass(MessageLite.class), handle);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        this.extractors = mapBuilder.build();
    }

    @Nullable
    public T extract(MessageLite request) throws DatastoreException {
        MethodHandle method = this.extractors.get(request.getClass());
        if (method == null) {
            return null;
        }
        try {
            return this.returnType.cast(method.invokeExact(this, request));
        }
        catch (Throwable e) {
            Throwables.propagateIfPossible(e, DatastoreException.class);
            throw DatastoreExceptionHelper.internalError("Extractor invoke error", e);
        }
    }

    @Nullable
    public T extractValidated(MessageLite request) {
        try {
            return this.extract(request);
        }
        catch (DatastoreException e) {
            throw new RuntimeException(e);
        }
    }
}

