/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.firestorev1.converter;

import com.google.cloud.datastore.core.appengv3.converter.AppEngV3EntityToRepConverter;
import com.google.cloud.datastore.core.config.proto1api.DatastoreCustomizableConfigPb;
import com.google.cloud.datastore.core.exception.InvalidConversionException;
import com.google.cloud.datastore.core.firestorev1.converter.FirestoreV1ResourceRefFromRepConverter;
import com.google.cloud.datastore.core.rep.Entity;
import com.google.cloud.datastore.core.rep.ReadResult;
import com.google.cloud.datastore.core.rep.Value;
import com.google.cloud.datastore.core.rep.converter.ConverterHelper;
import com.google.cloud.datastore.core.rep.converter.ValueToLegacyMapValueConverter;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.firestore.v1.ArrayValue;
import com.google.firestore.v1.Document;
import com.google.firestore.v1.MapValue;
import com.google.firestore.v1.Value;
import com.google.protobuf.NullValue;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.Map;
import javax.annotation.Nullable;

public class FirestoreV1EntityFromRepConverter {
    private static final ValueToLegacyMapValueConverter VALUE_TO_LEGACY_MAP_VALUE_CONVERTER = new ValueToLegacyMapValueConverter();
    private final AppEngV3EntityToRepConverter v3EntityToRepConverter;

    public FirestoreV1EntityFromRepConverter(AppEngV3EntityToRepConverter v3EntityToRepConverter) {
        this.v3EntityToRepConverter = Preconditions.checkNotNull(v3EntityToRepConverter);
    }

    @Nullable
    Document convertReadResultToDocument(ReadResult queryResult, @Nullable DatastoreCustomizableConfigPb.DatastoreCustomizableConfig configOverrides) throws InvalidConversionException {
        OnestoreEntity.EntityProto appEngV3Entity = queryResult.entity();
        if (appEngV3Entity == null) {
            return null;
        }
        long createVersion = queryResult.createVersion();
        long updateVersion = queryResult.updateVersion();
        Entity entity = this.v3EntityToRepConverter.convertEntity(appEngV3Entity, configOverrides);
        if (entity.ref().collectionId().equals("__document__")) {
            if (entity.propertyMap().containsKey("created")) {
                createVersion = entity.propertyMap().get("created").asLong();
                updateVersion = entity.propertyMap().get("updated").asLong();
                entity = Entity.create(entity.propertyMap().get("document_key").asEntityRef(), entity.propertyMap().getOrDefault("document", Value.EMPTY_MAP).asMap());
            } else if (entity.propertyMap().containsKey("document_key")) {
                createVersion = 0L;
                updateVersion = 0L;
                entity = Entity.create(entity.propertyMap().get("document_key").asEntityRef(), ImmutableMap.of());
            } else {
                throw new IllegalArgumentException("invalid __document__ format");
            }
        }
        return this.convertEntityToDocument(entity, createVersion, updateVersion);
    }

    public Document convertEntityProtoToDocument(OnestoreEntity.EntityProto v3Entity, long createVersion, long updateVersion, @Nullable DatastoreCustomizableConfigPb.DatastoreCustomizableConfig configOverrides) throws InvalidConversionException {
        Entity entity = this.v3EntityToRepConverter.convertEntity(v3Entity, configOverrides);
        return this.convertEntityToDocument(entity, createVersion, updateVersion);
    }

    public Document convertEntityToDocument(Entity entity, long createVersion, long updateVersion) throws InvalidConversionException {
        String name = FirestoreV1ResourceRefFromRepConverter.INSTANCE.convertEntityRefServiceRelative(entity.ref());
        Document.Builder documentBuilder = Document.newBuilder().setName(name);
        if (createVersion > 0L) {
            documentBuilder.setCreateTime(ConverterHelper.microsecondsToTimestamp(createVersion));
        }
        if (updateVersion > 0L) {
            documentBuilder.setUpdateTime(ConverterHelper.microsecondsToTimestamp(updateVersion));
        }
        ImmutableMap<String, Value> propertyMap = entity.propertyMap();
        for (Map.Entry entry : propertyMap.entrySet()) {
            documentBuilder.putFields((String)entry.getKey(), this.convertValue((Value)entry.getValue()));
        }
        return documentBuilder.build();
    }

    public com.google.firestore.v1.Value convertValue(Value value) throws InvalidConversionException {
        value = VALUE_TO_LEGACY_MAP_VALUE_CONVERTER.shallowConvertValue(value);
        Value.Builder apiValueBuilder = com.google.firestore.v1.Value.newBuilder();
        switch (value.type()) {
            case NULL: {
                apiValueBuilder.setNullValue(NullValue.NULL_VALUE);
                break;
            }
            case BOOLEAN: {
                apiValueBuilder.setBooleanValue(value.asBoolean());
                break;
            }
            case LONG: {
                apiValueBuilder.setIntegerValue(value.asLong());
                break;
            }
            case DOUBLE: {
                apiValueBuilder.setDoubleValue(value.asDouble());
                break;
            }
            case TIMESTAMP: {
                apiValueBuilder.setTimestampValue(value.asTimestamp());
                break;
            }
            case ENTITY_REF: {
                apiValueBuilder.setReferenceValue(FirestoreV1ResourceRefFromRepConverter.INSTANCE.convertResourceRef(value.asEntityRef()));
                break;
            }
            case RESOURCE_REF: {
                apiValueBuilder.setReferenceValue(FirestoreV1ResourceRefFromRepConverter.INSTANCE.convertResourceRef(value.asResourceRef()));
                break;
            }
            case STRING: {
                apiValueBuilder.setStringValue(value.asString());
                break;
            }
            case BYTES: {
                apiValueBuilder.setBytesValue(value.asBytes());
                break;
            }
            case GEO_POINT: {
                apiValueBuilder.setGeoPointValue(value.asGeoPoint());
                break;
            }
            case ARRAY: {
                apiValueBuilder.setArrayValue(this.convertArray(value.asArray()));
                break;
            }
            case MAP: {
                apiValueBuilder.setMapValue(this.convertMap(value.asMap()));
                break;
            }
            default: {
                throw new InvalidConversionException("Unhandled firestore.v1.Value type.");
            }
        }
        return apiValueBuilder.build();
    }

    private ArrayValue convertArray(ImmutableList<Value> array) throws InvalidConversionException {
        ArrayValue.Builder apiArrayValueBuilder = ArrayValue.newBuilder();
        for (Value value : array) {
            apiArrayValueBuilder.addValues(this.convertValue(value));
        }
        return apiArrayValueBuilder.build();
    }

    private MapValue convertMap(ImmutableMap<String, Value> map) throws InvalidConversionException {
        MapValue.Builder apiMapValueBuilder = MapValue.newBuilder();
        for (Map.Entry entry : map.entrySet()) {
            String name = (String)entry.getKey();
            Value value = (Value)entry.getValue();
            com.google.firestore.v1.Value apiValue = this.convertValue(value);
            apiMapValueBuilder.putFields(name, apiValue);
        }
        return apiMapValueBuilder.build();
    }
}

