/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.firestorev1.converter;

import com.google.cloud.datastore.core.exception.InvalidConversionException;
import com.google.cloud.datastore.core.firestorev1.converter.FirestoreV1ResourceRefToRepConverter;
import com.google.cloud.datastore.core.names.Names;
import com.google.cloud.datastore.core.names.ProjectIdAppIdResolver;
import com.google.cloud.datastore.core.rep.DatabaseIndexGroup;
import com.google.cloud.datastore.core.rep.Entity;
import com.google.cloud.datastore.core.rep.EntityRef;
import com.google.cloud.datastore.core.rep.RepHelper;
import com.google.cloud.datastore.core.rep.ReservedName;
import com.google.cloud.datastore.core.rep.ResourceRef;
import com.google.cloud.datastore.core.rep.Value;
import com.google.cloud.datastore.core.rep.converter.LegacyMapValueToValueConverter;
import com.google.cloud.datastore.core.rep.converter.UserIdObfuscator;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.firestore.v1.ArrayValue;
import com.google.firestore.v1.Document;
import com.google.protobuf.Timestamp;
import java.util.Map;

public class FirestoreV1EntityToRepConverter {
    private final LegacyMapValueToValueConverter legacyMapValueToValueConverter;
    private final FirestoreV1ResourceRefToRepConverter resourceRefToRepConverter;

    public FirestoreV1EntityToRepConverter(FirestoreV1ResourceRefToRepConverter resourceRefToRepConverter, UserIdObfuscator userIdObfuscator) {
        this.resourceRefToRepConverter = Preconditions.checkNotNull(resourceRefToRepConverter);
        this.legacyMapValueToValueConverter = new LegacyMapValueToValueConverter(userIdObfuscator);
    }

    public Entity convertEntity(ProjectIdAppIdResolver resolver, DatabaseIndexGroup databaseIndexGroup, Document document) throws InvalidConversionException {
        EntityRef entityRef = this.resourceRefToRepConverter.convertEntityRefServiceRelative(resolver, document.getName());
        ImmutableMap<String, Value> propertyMap = this.convertMap(resolver, databaseIndexGroup, document.getFieldsMap(), true);
        return Entity.create(entityRef, propertyMap);
    }

    ImmutableMap<String, Value> convertDocumentFields(ProjectIdAppIdResolver resolver, DatabaseIndexGroup databaseIndexGroup, Document document) throws InvalidConversionException {
        return this.convertMap(resolver, databaseIndexGroup, document.getFieldsMap(), true);
    }

    public Value convertValue(ProjectIdAppIdResolver resolver, com.google.firestore.v1.Value apiValue) throws InvalidConversionException {
        return this.convertValue(resolver, DatabaseIndexGroup.NO_INDEXES, apiValue);
    }

    public Value convertValue(ProjectIdAppIdResolver resolver, DatabaseIndexGroup databaseIndexGroup, com.google.firestore.v1.Value apiValue) throws InvalidConversionException {
        Value value = this.convertValueHelperWithIsIndexed(resolver, databaseIndexGroup, apiValue);
        if (value.type() != Value.Type.ARRAY) {
            Value.DatastoreIndexing datastoreIndexing = databaseIndexGroup.datastoreIndexing();
            value = value.withDatastoreIndexing(datastoreIndexing);
        }
        return value;
    }

    private Value convertValueHelperWithIsIndexed(ProjectIdAppIdResolver resolver, DatabaseIndexGroup databaseIndexGroup, com.google.firestore.v1.Value apiValue) throws InvalidConversionException {
        Value value = this.convertValueHelperWithoutIsIndexed(resolver, databaseIndexGroup, apiValue);
        return this.legacyMapValueToValueConverter.convertValue(value);
    }

    private Value convertValueHelperWithoutIsIndexed(ProjectIdAppIdResolver resolver, DatabaseIndexGroup databaseIndexGroup, com.google.firestore.v1.Value apiValue) throws InvalidConversionException {
        switch (apiValue.getValueTypeCase()) {
            case NULL_VALUE: {
                return Value.NULL;
            }
            case BOOLEAN_VALUE: {
                return Value.createBoolean(apiValue.getBooleanValue());
            }
            case INTEGER_VALUE: {
                return Value.createLong(apiValue.getIntegerValue());
            }
            case DOUBLE_VALUE: {
                return Value.createDouble(apiValue.getDoubleValue());
            }
            case TIMESTAMP_VALUE: {
                Timestamp apiTimestamp = apiValue.getTimestampValue();
                InvalidConversionException.checkConversion(apiTimestamp.getNanos() >= 0 && apiTimestamp.getNanos() < 1000000000, "Timestamp nanos exceeds limit for field.", new Object[0]);
                InvalidConversionException.checkConversion(RepHelper.isSecondsInTimestampBounds(apiTimestamp.getSeconds()), "Timestamp seconds exceeds limit for field.", new Object[0]);
                return Value.createTimestamp(apiTimestamp);
            }
            case STRING_VALUE: {
                return Value.createString(apiValue.getStringValue());
            }
            case BYTES_VALUE: {
                return Value.createBytes(apiValue.getBytesValue());
            }
            case REFERENCE_VALUE: {
                ResourceRef resourceRef = this.resourceRefToRepConverter.convertResourceRefAllowFirestoreRelative(resolver, apiValue.getReferenceValue());
                if (resourceRef instanceof EntityRef) {
                    EntityRef entityRef = (EntityRef)resourceRef;
                    return Value.createEntityRef(entityRef);
                }
                return Value.createResourceRef(resourceRef);
            }
            case GEO_POINT_VALUE: {
                InvalidConversionException.checkConversion(Math.abs(apiValue.getGeoPointValue().getLatitude()) <= 90.0, "Geo point latitude outside permitted range -90.0 to 90.0.", new Object[0]);
                InvalidConversionException.checkConversion(Math.abs(apiValue.getGeoPointValue().getLongitude()) <= 180.0, "Geo point longitude outside permitted range -180.0 to 180.0.", new Object[0]);
                return Value.createGeoPoint(apiValue.getGeoPointValue());
            }
            case MAP_VALUE: {
                return Value.createMap(this.convertMap(resolver, databaseIndexGroup, apiValue.getMapValue().getFieldsMap(), false));
            }
            case ARRAY_VALUE: {
                return Value.createArray(this.convertArrayValue(resolver, databaseIndexGroup, apiValue.getArrayValue()));
            }
            case VALUETYPE_NOT_SET: {
                throw new InvalidConversionException("Cannot convert firestore.v1.Value with type unset.");
            }
        }
        throw new AssertionError((Object)"Unhandled apiValue.getValueTypeCase()");
    }

    private ImmutableList<Value> convertArrayValue(ProjectIdAppIdResolver resolver, DatabaseIndexGroup databaseIndexGroup, ArrayValue apiArrayValue) throws InvalidConversionException {
        ImmutableList.Builder arrayBuilder = ImmutableList.builder();
        for (com.google.firestore.v1.Value apiValue : apiArrayValue.getValuesList()) {
            arrayBuilder.add(this.convertValue(resolver, databaseIndexGroup, apiValue));
        }
        return arrayBuilder.build();
    }

    private ImmutableMap<String, Value> convertMap(ProjectIdAppIdResolver resolver, DatabaseIndexGroup databaseIndexGroup, Map<String, com.google.firestore.v1.Value> apiMap, boolean topLevel) throws InvalidConversionException {
        ImmutableMap.Builder<String, Value> mapBuilder = ImmutableMap.builder();
        for (Map.Entry<String, com.google.firestore.v1.Value> entry : apiMap.entrySet()) {
            String name = entry.getKey();
            com.google.firestore.v1.Value apiValue = entry.getValue();
            if (Names.isNameReserved(name)) {
                InvalidConversionException.checkConversion(!topLevel && apiMap.containsKey(ReservedName.TYPE.asString()), "field name %s is reserved", name);
            }
            Value value = this.convertValue(resolver, databaseIndexGroup, apiValue);
            mapBuilder.put(name, value);
        }
        return mapBuilder.build();
    }
}

