/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.firestorev1.converter;

import com.google.cloud.datastore.core.rep.IndexValue;
import com.google.cloud.datastore.core.rep.proto.IndexValue;
import com.google.protobuf.Empty;
import com.google.protobuf.NullValue;
import java.util.Map;

public class FirestoreV1IndexValueFromRepConverter {
    public static final FirestoreV1IndexValueFromRepConverter INSTANCE = new FirestoreV1IndexValueFromRepConverter();
    private static final com.google.cloud.datastore.core.rep.proto.IndexValue API_NULL = com.google.cloud.datastore.core.rep.proto.IndexValue.newBuilder().setNullValue(NullValue.NULL_VALUE).build();
    private static final com.google.cloud.datastore.core.rep.proto.IndexValue API_FALSE = com.google.cloud.datastore.core.rep.proto.IndexValue.newBuilder().setBooleanValue(false).build();
    private static final com.google.cloud.datastore.core.rep.proto.IndexValue API_TRUE = com.google.cloud.datastore.core.rep.proto.IndexValue.newBuilder().setBooleanValue(true).build();
    private static final com.google.cloud.datastore.core.rep.proto.IndexValue API_NAN = com.google.cloud.datastore.core.rep.proto.IndexValue.newBuilder().setNanValue(Empty.getDefaultInstance()).build();

    private FirestoreV1IndexValueFromRepConverter() {
    }

    com.google.cloud.datastore.core.rep.proto.IndexValue convertEntityRefRelDatabase(IndexValue.EntityRef indexValueEntityRef) {
        return this.convertIndexValueEntityRef(true, indexValueEntityRef);
    }

    public com.google.cloud.datastore.core.rep.proto.IndexValue convertIndexValue(IndexValue indexValue) {
        switch (indexValue.type()) {
            case NULL: {
                return API_NULL;
            }
            case BOOLEAN: {
                return indexValue.asBoolean() ? API_TRUE : API_FALSE;
            }
            case NUMBER: {
                if (indexValue.equals(IndexValue.NAN)) {
                    return API_NAN;
                }
                IndexValue.NumberValue.Builder apiNumberValueBuilder = IndexValue.NumberValue.newBuilder();
                if (indexValue.isNumberDouble()) {
                    apiNumberValueBuilder.setDoubleValue(indexValue.asNumberDouble());
                } else {
                    apiNumberValueBuilder.setLongValue(indexValue.asNumberLong());
                }
                return com.google.cloud.datastore.core.rep.proto.IndexValue.newBuilder().setNumberValue(apiNumberValueBuilder.build()).build();
            }
            case TIMESTAMP: {
                return com.google.cloud.datastore.core.rep.proto.IndexValue.newBuilder().setTimestampValue(indexValue.asTimestamp()).build();
            }
            case STRING: {
                return com.google.cloud.datastore.core.rep.proto.IndexValue.newBuilder().setStringValue(this.partConvertStringIndexValue(indexValue)).build();
            }
            case BYTES: {
                return com.google.cloud.datastore.core.rep.proto.IndexValue.newBuilder().setBytesValue(IndexValue.BytesValue.newBuilder().setValue(indexValue.asBytes()).setTruncated(indexValue.isShallowTruncated()).build()).build();
            }
            case ENTITY_REF: {
                return this.convertIndexValueEntityRef(false, indexValue.asEntityRef());
            }
            case GEO_POINT: {
                return com.google.cloud.datastore.core.rep.proto.IndexValue.newBuilder().setGeoPointValue(indexValue.asGeoPoint()).build();
            }
            case ARRAY: {
                return this.convertArrayIndexValue(indexValue);
            }
            case MAP: {
                return this.convertMapIndexValue(indexValue);
            }
            case LEGACY_USER: 
            case ABSENT_TYPE: {
                throw new IllegalArgumentException();
            }
        }
        throw new AssertionError((Object)"Unhandled indexValue.type()");
    }

    private com.google.cloud.datastore.core.rep.proto.IndexValue convertIndexValueEntityRef(boolean relDatabase, IndexValue.EntityRef entityRef) {
        IndexValue.DocumentResourceName.Builder apiDocumentResourceNameBuilder = IndexValue.DocumentResourceName.newBuilder();
        if (!relDatabase) {
            apiDocumentResourceNameBuilder.setProjectId(this.partConvertString(entityRef.databaseRef.projectId())).setDatabaseId(this.partConvertString(entityRef.databaseRef.databaseId()));
        }
        if (entityRef.namespaceId != IndexValue.ABSENT) {
            boolean isDocumentResourceNameTruncated;
            apiDocumentResourceNameBuilder.setNamespaceId(this.partConvertStringIndexValue(entityRef.namespaceId));
            if (entityRef.segments == IndexValue.ABSENT) {
                isDocumentResourceNameTruncated = !entityRef.namespaceId.isShallowTruncated();
            } else {
                for (IndexValue segment : entityRef.segments.asArray()) {
                    IndexValue.DocumentResourceName.Segment.Builder apiSegmentBuilder = IndexValue.DocumentResourceName.Segment.newBuilder();
                    if (segment.type() == IndexValue.Type.STRING) {
                        apiSegmentBuilder.setStringId(this.partConvertStringIndexValue(segment));
                    } else {
                        apiSegmentBuilder.setIntegerId(segment.asNumberLong());
                    }
                    apiDocumentResourceNameBuilder.addSegments(apiSegmentBuilder.build());
                }
                isDocumentResourceNameTruncated = entityRef.segments.isShallowTruncated();
            }
            apiDocumentResourceNameBuilder.setTruncated(isDocumentResourceNameTruncated);
        }
        return com.google.cloud.datastore.core.rep.proto.IndexValue.newBuilder().setResourceNameValue(IndexValue.ResourceName.newBuilder().setDocumentResourceName(apiDocumentResourceNameBuilder.build()).build()).build();
    }

    private com.google.cloud.datastore.core.rep.proto.IndexValue convertArrayIndexValue(IndexValue arrayIndexValue) {
        IndexValue.ArrayValue.Builder apiArrayValueBuilder = IndexValue.ArrayValue.newBuilder();
        for (IndexValue elementIndexValue : arrayIndexValue.asArray()) {
            apiArrayValueBuilder.addValues(this.convertIndexValue(elementIndexValue));
        }
        apiArrayValueBuilder.setTruncated(arrayIndexValue.isShallowTruncated());
        return com.google.cloud.datastore.core.rep.proto.IndexValue.newBuilder().setArrayValue(apiArrayValueBuilder.build()).build();
    }

    private com.google.cloud.datastore.core.rep.proto.IndexValue convertMapIndexValue(IndexValue mapIndexValue) {
        IndexValue.MapValue.Builder apiMapValueBuilder = IndexValue.MapValue.newBuilder();
        for (Map.Entry mapEntry : mapIndexValue.asMap().entrySet()) {
            IndexValue keyIndexValue = (IndexValue)mapEntry.getKey();
            IndexValue valueIndexValue = (IndexValue)mapEntry.getValue();
            IndexValue.MapValue.MapEntry.Builder apiMapEntryBuilder = IndexValue.MapValue.MapEntry.newBuilder().setKey(this.partConvertStringIndexValue(keyIndexValue));
            if (valueIndexValue != IndexValue.ABSENT) {
                apiMapEntryBuilder.setValue(this.convertIndexValue(valueIndexValue));
            }
            apiMapValueBuilder.addEntries(apiMapEntryBuilder.build());
        }
        apiMapValueBuilder.setTruncated(mapIndexValue.isShallowTruncated());
        return com.google.cloud.datastore.core.rep.proto.IndexValue.newBuilder().setMapValue(apiMapValueBuilder.build()).build();
    }

    private IndexValue.StringValue partConvertStringIndexValue(IndexValue stringIndexValue) {
        return IndexValue.StringValue.newBuilder().setValue(stringIndexValue.asString()).setTruncated(stringIndexValue.isShallowTruncated()).build();
    }

    private IndexValue.StringValue partConvertString(String string) {
        return IndexValue.StringValue.newBuilder().setValue(string).setTruncated(false).build();
    }
}

