/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.firestorev1.converter;

import com.google.cloud.datastore.core.exception.DatastoreException;
import com.google.cloud.datastore.core.exception.DatastoreExceptionHelper;
import com.google.cloud.datastore.core.rep.proto.QueryResumeToken;
import com.google.protobuf.InvalidProtocolBufferException;

public interface FirestoreV1KeystoreClient {
    public static final FirestoreV1KeystoreClient NO_OP = new FirestoreV1KeystoreClient(){

        @Override
        public byte[] encrypt(QueryResumeToken token) {
            return token.toByteArray();
        }

        @Override
        public QueryResumeToken decryptQueryResumeToken(byte[] encrypted) throws DatastoreException {
            try {
                return QueryResumeToken.parseFrom(encrypted);
            }
            catch (InvalidProtocolBufferException e) {
                throw DatastoreExceptionHelper.internalError(e);
            }
        }
    };

    public byte[] encrypt(QueryResumeToken var1) throws DatastoreException;

    public QueryResumeToken decryptQueryResumeToken(byte[] var1) throws DatastoreException;
}

