/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.firestorev1.converter;

import com.google.cloud.datastore.core.exception.InvalidConversionException;
import com.google.cloud.datastore.core.rep.Direction;
import com.google.cloud.datastore.core.rep.PropertyMask;
import com.google.cloud.datastore.core.rep.PropertyName;
import com.google.cloud.datastore.core.rep.PropertyPath;
import com.google.cloud.datastore.core.rep.PropertyPathSegment;
import com.google.cloud.datastore.core.rep.PropertyPathWithDirection;
import com.google.cloud.datastore.core.rep.ReservedName;
import com.google.cloud.datastore.core.rep.converter.GoogleSqlPropertyPathToRepConverter;
import com.google.cloud.datastore.core.rep.converter.PropertyPathToMaskConverter;
import com.google.cloud.datastore.core.rep.converter.TildeEscapedPropertyPathToRepConverter;
import com.google.cloud.datastore.core.rep.validator.ValidationConstraint;
import com.google.cloud.datastore.internal.InternalHeader;
import com.google.common.base.Ascii;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.firestore.v1.DocumentMask;
import com.google.firestore.v1.StructuredQuery;
import com.google.re2j.Matcher;
import com.google.re2j.Pattern;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class FirestoreV1PropertyPathToRepConverter {
    private static final TildeEscapedPropertyPathToRepConverter TILDE_ESCAPED_PROPERTY_PATH_TO_REP_CONVERTER = new TildeEscapedPropertyPathToRepConverter(ReservedName.NAME.asString());
    private static final String ILL_FORMED_ORDER_BY_STRING_MESSAGE = "Invalid order by clause \"%s\".";
    private static final String DIRECTION_ASC_STRING = "ASC";
    private static final String DIRECTION_DESC_STRING = "DESC";
    private static final String DIRECTION_REGEX_STRING = String.format("((?i)%s|%s(?-i))", "ASC", "DESC");
    private static final String PROPERTY_PATH_WITH_DIRECTION_REGEX_STRING = String.format("(?:(%s)\\s*%s?)", GoogleSqlPropertyPathToRepConverter.PROPERTY_PATH_REGEX_STRING, DIRECTION_REGEX_STRING);
    private static final Pattern FIRST_ORDER_BY_REGEX = Pattern.compile(PROPERTY_PATH_WITH_DIRECTION_REGEX_STRING, 2);
    private static final Pattern REMAINING_ORDER_BY_REGEX = Pattern.compile(String.format("\\s*,\\s*%s", PROPERTY_PATH_WITH_DIRECTION_REGEX_STRING), 2);
    private static final int PROPERTY_PATH_GROUP = 1;
    private static final int DIRECTION_GROUP = 7;
    private final PropertyPathToMaskConverter propertyPathToMaskConverter;

    public FirestoreV1PropertyPathToRepConverter(PropertyPathToMaskConverter propertyPathToMaskConverter) {
        this.propertyPathToMaskConverter = Preconditions.checkNotNull(propertyPathToMaskConverter);
    }

    public PropertyPath convertFieldPathToPropertyPath(InternalHeader.ApiVersion apiVersion, String apiPath) throws InvalidConversionException {
        PropertyPath converted;
        for (PropertyPath path = converted = GoogleSqlPropertyPathToRepConverter.NAME_INSTANCE.convertPropertyPath(apiPath); path != null; path = path.next()) {
            PropertyPathSegment segment = path.segment();
            if (!(segment instanceof PropertyPathSegment.Member)) continue;
            PropertyName name = ((PropertyPathSegment.Member)segment).name();
            InvalidConversionException.checkConversion(!name.isReserved() || name.equals(ReservedName.TYPE.asPropertyName()) || name.isKey(), "invalid reserved name in field path %s", apiPath);
        }
        return converted;
    }

    public PropertyMask convertPropertyMask(InternalHeader.ApiVersion apiVersion, DocumentMask apiDocumentMask, ValidationConstraint constraint) throws InvalidConversionException {
        List<PropertyPath> propertyPaths = this.extractPropertyPaths(apiVersion, apiDocumentMask);
        return this.propertyPathToMaskConverter.validateAndConvertPathsToMask(propertyPaths, constraint);
    }

    PropertyMask convertPropertyMask(InternalHeader.ApiVersion apiVersion, StructuredQuery.Projection projection) throws InvalidConversionException {
        List<PropertyPath> propertyPaths = this.extractPropertyPaths(apiVersion, projection);
        return this.propertyPathToMaskConverter.validateAndConvertPathsToMask(propertyPaths, ValidationConstraint.QUERY.withContext(ValidationConstraint.Context.FIRESTORE));
    }

    private List<PropertyPath> extractPropertyPaths(InternalHeader.ApiVersion apiVersion, DocumentMask apiDocumentMask) throws InvalidConversionException {
        ArrayList<PropertyPath> propertyPaths = new ArrayList<PropertyPath>();
        for (String apiPropertyPathString : apiDocumentMask.getFieldPathsList()) {
            PropertyPath path = this.convertFieldPathToPropertyPath(apiVersion, apiPropertyPathString);
            if (path.isKey()) continue;
            propertyPaths.add(path);
        }
        return propertyPaths;
    }

    private List<PropertyPath> extractPropertyPaths(InternalHeader.ApiVersion apiVersion, StructuredQuery.Projection projection) throws InvalidConversionException {
        ArrayList<PropertyPath> propertyPaths = new ArrayList<PropertyPath>();
        for (StructuredQuery.FieldReference fieldRef : projection.getFieldsList()) {
            PropertyPath path = this.convertFieldPathToPropertyPath(apiVersion, fieldRef.getFieldPath());
            if (path.isKey()) continue;
            propertyPaths.add(path);
        }
        return propertyPaths;
    }

    public ImmutableList<PropertyPathWithDirection> convertOrderBy(InternalHeader.ApiVersion apiVersion, String orderBy) throws InvalidConversionException {
        ImmutableList.Builder builder = ImmutableList.builder();
        int endOrderByIndex = orderBy.length();
        Matcher orderMatcher = FIRST_ORDER_BY_REGEX.matcher(orderBy);
        boolean foundMatch = orderMatcher.lookingAt();
        InvalidConversionException.checkConversion(foundMatch, ILL_FORMED_ORDER_BY_STRING_MESSAGE, orderBy);
        builder.add(PropertyPathWithDirection.create(this.convertFieldPathToPropertyPath(apiVersion, orderMatcher.group(1)), this.convertDirection(orderMatcher.group(7))));
        int startNextOrderByIndex = orderMatcher.end();
        if (startNextOrderByIndex < endOrderByIndex) {
            orderMatcher = REMAINING_ORDER_BY_REGEX.matcher(orderBy);
            do {
                foundMatch = orderMatcher.find(startNextOrderByIndex) && orderMatcher.start() == startNextOrderByIndex;
                InvalidConversionException.checkConversion(foundMatch, ILL_FORMED_ORDER_BY_STRING_MESSAGE, orderBy);
                builder.add(PropertyPathWithDirection.create(this.convertFieldPathToPropertyPath(apiVersion, orderMatcher.group(1)), this.convertDirection(orderMatcher.group(7))));
            } while ((startNextOrderByIndex = orderMatcher.end()) < endOrderByIndex);
        }
        return builder.build();
    }

    private Direction convertDirection(@Nullable String directionString) throws InvalidConversionException {
        if (directionString == null || Ascii.equalsIgnoreCase(directionString, DIRECTION_ASC_STRING)) {
            return Direction.ASCENDING;
        }
        if (Ascii.equalsIgnoreCase(directionString, DIRECTION_DESC_STRING)) {
            return Direction.DESCENDING;
        }
        String string = String.valueOf(directionString);
        throw new InvalidConversionException(string.length() != 0 ? "Invalid order by direction: ".concat(string) : new String("Invalid order by direction: "));
    }
}

