/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.firestorev1.converter;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.firestore.v1.ListDocumentsRequest;
import java.nio.charset.StandardCharsets;

public class FirestoreV1QueryFingerprinter {
    private final HashFunction hashFunction;

    public FirestoreV1QueryFingerprinter(HashFunction hashFunction) {
        this.hashFunction = hashFunction;
    }

    public long fingerprintFor(ListDocumentsRequest request) {
        Hasher hasher = this.hashFunction.newHasher();
        hasher.putString(request.getParent(), StandardCharsets.UTF_8);
        hasher.putString(request.getCollectionId(), StandardCharsets.UTF_8);
        hasher.putBoolean(request.getShowMissing());
        hasher.putString(request.getOrderBy(), StandardCharsets.UTF_8);
        if (request.hasMask()) {
            hasher.putBytes(request.getMask().toByteArray());
        }
        return hasher.hash().asLong();
    }
}

