/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.firestorev1.converter;

import com.google.cloud.datastore.core.firestorev1.converter.FirestoreV1IndexValueFromRepConverter;
import com.google.cloud.datastore.core.index.firestore.ValueToFirestoreIndexValueConverter;
import com.google.cloud.datastore.core.rep.Cursor;
import com.google.cloud.datastore.core.rep.EntityRef;
import com.google.cloud.datastore.core.rep.IndexValue;
import com.google.cloud.datastore.core.rep.UnifiedIndexValue;
import com.google.cloud.datastore.core.rep.proto.IndexValue;
import com.google.cloud.datastore.core.rep.proto.QueryResumeToken;
import com.google.common.base.Preconditions;
import com.google.protobuf.Int32Value;

public class FirestoreV1QueryFromRepConverter {
    public static final FirestoreV1QueryFromRepConverter INSTANCE = new FirestoreV1QueryFromRepConverter();

    private FirestoreV1QueryFromRepConverter() {
    }

    public QueryResumeToken convertQueryResumeState(long queryFingerprint, Cursor cursor, int offsetRemaining, int limitRemaining) {
        EntityRef keyEntityRef = cursor.key();
        Preconditions.checkArgument(cursor.isRegular(), "Expected regular cursor.");
        Preconditions.checkArgument(!cursor.before(), "Expected after cursor.");
        Preconditions.checkArgument(keyEntityRef != null, "Expected cursor with key.");
        QueryResumeToken.V1.Builder apiQrtV1Builder = QueryResumeToken.V1.newBuilder().setFingerprint(queryFingerprint);
        for (UnifiedIndexValue indexValue : cursor.indexValues()) {
            IndexValue apiIndexValue = FirestoreV1IndexValueFromRepConverter.INSTANCE.convertIndexValue(indexValue.indexValue());
            apiQrtV1Builder.addIndexValues(apiIndexValue);
        }
        IndexValue.EntityRef keyEntityRefIndexValue = ValueToFirestoreIndexValueConverter.DEFAULT.partConvertEntityRefIgnoreThreshold(keyEntityRef);
        IndexValue apiKeyEntityRefIndexValue = FirestoreV1IndexValueFromRepConverter.INSTANCE.convertEntityRefRelDatabase(keyEntityRefIndexValue);
        apiQrtV1Builder.addIndexValues(apiKeyEntityRefIndexValue).setOffsetRemaining(offsetRemaining);
        if (limitRemaining >= 0 && offsetRemaining == 0) {
            Int32Value limitRemainingInt32Value = Int32Value.of(limitRemaining);
            apiQrtV1Builder.setLimitRemaining(limitRemainingInt32Value);
        }
        return QueryResumeToken.newBuilder().setV1(apiQrtV1Builder.build()).build();
    }
}

