/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.firestorev1.converter;

import com.google.cloud.datastore.core.exception.InvalidConversionException;
import com.google.cloud.datastore.core.firestorev1.converter.FirestoreV1EntityToRepConverter;
import com.google.cloud.datastore.core.firestorev1.converter.FirestoreV1IndexValueToRepConverter;
import com.google.cloud.datastore.core.firestorev1.converter.FirestoreV1PropertyPathToRepConverter;
import com.google.cloud.datastore.core.firestorev1.converter.FirestoreV1ResourceRefToRepConverter;
import com.google.cloud.datastore.core.index.firestore.FirestoreIndexValueToValueConverter;
import com.google.cloud.datastore.core.index.firestore.ValueToFirestoreIndexValueConverter;
import com.google.cloud.datastore.core.names.ProjectIdAppIdResolver;
import com.google.cloud.datastore.core.rep.Condition;
import com.google.cloud.datastore.core.rep.DatabaseRef;
import com.google.cloud.datastore.core.rep.Direction;
import com.google.cloud.datastore.core.rep.EntityRef;
import com.google.cloud.datastore.core.rep.IndexValue;
import com.google.cloud.datastore.core.rep.LogicalCondition;
import com.google.cloud.datastore.core.rep.PropertyPath;
import com.google.cloud.datastore.core.rep.PropertyPathSegment;
import com.google.cloud.datastore.core.rep.PropertyPathWithDirection;
import com.google.cloud.datastore.core.rep.PropertyValueCondition;
import com.google.cloud.datastore.core.rep.Query;
import com.google.cloud.datastore.core.rep.QueryScope;
import com.google.cloud.datastore.core.rep.ReservedName;
import com.google.cloud.datastore.core.rep.UnifiedIndexValue;
import com.google.cloud.datastore.core.rep.Value;
import com.google.cloud.datastore.core.rep.proto.QueryResumeToken;
import com.google.cloud.datastore.internal.InternalHeader;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.firestore.v1.Cursor;
import com.google.firestore.v1.StructuredQuery;
import java.util.List;
import javax.annotation.Nullable;

public class FirestoreV1QueryToRepConverter {
    private static final ImmutableSet<StructuredQuery.FieldFilter.Operator> ARRAY_OPERATORS = ImmutableSet.of(StructuredQuery.FieldFilter.Operator.ARRAY_CONTAINS, StructuredQuery.FieldFilter.Operator.ARRAY_CONTAINS_ANY);
    private final FirestoreV1PropertyPathToRepConverter propertyPathToRepConverter;
    private final FirestoreV1EntityToRepConverter entityToRepConverter;
    private final boolean enableDisjunctiveQueries;

    public FirestoreV1QueryToRepConverter(FirestoreV1PropertyPathToRepConverter propertyPathToRepConverter, FirestoreV1EntityToRepConverter entityToRepConverter, boolean enableDisjunctiveQueries) {
        this.propertyPathToRepConverter = Preconditions.checkNotNull(propertyPathToRepConverter);
        this.entityToRepConverter = Preconditions.checkNotNull(entityToRepConverter);
        this.enableDisjunctiveQueries = enableDisjunctiveQueries;
    }

    public Query convertQueryResumeState(Query baseQuery, long baseQueryFingerprint, QueryResumeToken queryResumeToken) throws InvalidConversionException {
        InvalidConversionException.checkConversion(queryResumeToken.getVersionCase() == QueryResumeToken.VersionCase.V1, "unexpected QueryResumeToken version", new Object[0]);
        QueryResumeToken.V1 apiQrtV1 = queryResumeToken.getV1();
        long apiFingerprint = apiQrtV1.getFingerprint();
        InvalidConversionException.checkConversion(apiFingerprint != 0L, "Query resume token lacks fingerprint.", new Object[0]);
        InvalidConversionException.checkConversion(apiFingerprint == baseQueryFingerprint, "Query resume token fingerprint does not match query.", new Object[0]);
        com.google.cloud.datastore.core.rep.Cursor resumeCursor = this.convertQueryResumeTokenToCursor(queryResumeToken, baseQuery.scope().partition().databaseRef());
        Query.Builder newQueryBuilder = baseQuery.toBuilder();
        newQueryBuilder.startCursor(null);
        newQueryBuilder.resumeCursor(resumeCursor);
        newQueryBuilder.offset(apiQrtV1.getOffsetRemaining());
        if (apiQrtV1.hasLimitRemaining()) {
            newQueryBuilder.limit(apiQrtV1.getLimitRemaining().getValue());
        }
        return newQueryBuilder.build();
    }

    public com.google.cloud.datastore.core.rep.Cursor convertQueryResumeTokenToCursor(QueryResumeToken queryResumeToken, DatabaseRef databaseRef) throws InvalidConversionException {
        QueryResumeToken.V1 apiQrtV1 = queryResumeToken.getV1();
        List<com.google.cloud.datastore.core.rep.proto.IndexValue> apiIndexValues = apiQrtV1.getIndexValuesList();
        int keyIndex = apiIndexValues.size() - 1;
        com.google.cloud.datastore.core.rep.proto.IndexValue apiIndexValueEntityRef = apiIndexValues.get(keyIndex);
        EntityRef keyEntityRef = FirestoreIndexValueToValueConverter.INSTANCE.convertEntityRef(databaseRef.partitionId(), FirestoreV1IndexValueToRepConverter.INSTANCE.convertEntityRefRelDatabase(databaseRef, apiIndexValueEntityRef));
        ImmutableList.Builder indexValuesBuilder = ImmutableList.builder();
        for (int index = 0; index < keyIndex; ++index) {
            com.google.cloud.datastore.core.rep.proto.IndexValue apiIndexValue = apiIndexValues.get(index);
            IndexValue indexValue = FirestoreV1IndexValueToRepConverter.INSTANCE.convertIndexValue(databaseRef, apiIndexValue);
            UnifiedIndexValue unifiedIndexValue = UnifiedIndexValue.create(indexValue);
            indexValuesBuilder.add(unifiedIndexValue);
        }
        return com.google.cloud.datastore.core.rep.Cursor.after(keyEntityRef, null, (ImmutableList<UnifiedIndexValue>)indexValuesBuilder.build());
    }

    public Query convertStructuredQuery(InternalHeader.ApiVersion apiVersion, ProjectIdAppIdResolver resolver, QueryScope scope, @Nullable EntityRef rootEntity, StructuredQuery apiQuery) throws InvalidConversionException {
        int apiOffset;
        List<StructuredQuery.Order> apiOrderBys;
        Query.Builder queryBuilder = Query.builder();
        queryBuilder.scope(scope);
        queryBuilder.semantics(Query.Semantics.FIRESTORE);
        queryBuilder.ancestor(rootEntity);
        queryBuilder.isShallow(true);
        List<StructuredQuery.CollectionSelector> apiFroms = apiQuery.getFromList();
        if (!apiFroms.isEmpty()) {
            InvalidConversionException.checkConversion(apiFroms.size() == 1, "StructuredQuery.from cannot have more than one collection selector.", new Object[0]);
            StructuredQuery.CollectionSelector collectionSelector = apiFroms.get(0);
            String apiCollectionId = collectionSelector.getCollectionId();
            if (!apiCollectionId.isEmpty()) {
                queryBuilder.kind(FirestoreV1ResourceRefToRepConverter.convertEntityCollectionId(apiCollectionId));
            }
            queryBuilder.isShallow(!collectionSelector.getAllDescendants());
            if (collectionSelector.getAllDescendants() && rootEntity != null) {
                Value ancestorValue = Value.createEntityRef(rootEntity);
                queryBuilder.addCondition(PropertyValueCondition.create(Condition.Op.GT, PropertyPath.KEY, ancestorValue));
            }
        }
        if (apiQuery.hasWhere()) {
            queryBuilder.addCondition(this.convertCondition(apiVersion, resolver, apiQuery.getWhere()));
        }
        if (apiQuery.hasSelect()) {
            queryBuilder.propertyMask(this.propertyPathToRepConverter.convertPropertyMask(apiVersion, apiQuery.getSelect()));
        }
        ImmutableList<PropertyPathWithDirection> orderBys = (apiOrderBys = apiQuery.getOrderByList()).isEmpty() ? ImmutableList.of() : this.convertOrders(apiVersion, apiOrderBys);
        queryBuilder.orderBy(orderBys);
        if (apiQuery.hasStartAt() || apiQuery.hasEndAt()) {
            ImmutableList<PropertyPath> cursorPropertyPaths = this.makeCursorPropertyPaths(orderBys);
            if (apiQuery.hasStartAt()) {
                queryBuilder.startCursor(this.convertCursor(resolver, cursorPropertyPaths, apiQuery.getStartAt()));
            }
            if (apiQuery.hasEndAt()) {
                queryBuilder.endCursor(this.convertCursor(resolver, cursorPropertyPaths, apiQuery.getEndAt()));
            }
        }
        if ((apiOffset = apiQuery.getOffset()) != 0) {
            queryBuilder.offset(apiOffset);
        }
        if (apiQuery.hasLimit()) {
            queryBuilder.limit(apiQuery.getLimit().getValue());
        }
        return queryBuilder.build();
    }

    private ImmutableList<Condition> convertConditions(InternalHeader.ApiVersion apiVersion, ProjectIdAppIdResolver resolver, List<StructuredQuery.Filter> apiFilters) throws InvalidConversionException {
        ImmutableList.Builder conditionsBuilder = ImmutableList.builder();
        for (StructuredQuery.Filter apiFilter : apiFilters) {
            conditionsBuilder.add(this.convertCondition(apiVersion, resolver, apiFilter));
        }
        return conditionsBuilder.build();
    }

    private Condition convertCondition(InternalHeader.ApiVersion apiVersion, ProjectIdAppIdResolver resolver, StructuredQuery.Filter apiFilter) throws InvalidConversionException {
        switch (apiFilter.getFilterTypeCase()) {
            case COMPOSITE_FILTER: {
                return this.convertCondition(apiVersion, resolver, apiFilter.getCompositeFilter());
            }
            case FIELD_FILTER: {
                return this.convertCondition(apiVersion, resolver, apiFilter.getFieldFilter());
            }
            case UNARY_FILTER: {
                return this.convertCondition(apiVersion, apiFilter.getUnaryFilter());
            }
        }
        throw new InvalidConversionException("Unknown Filter type.");
    }

    private Condition convertCondition(InternalHeader.ApiVersion apiVersion, ProjectIdAppIdResolver resolver, StructuredQuery.CompositeFilter apiFilter) throws InvalidConversionException {
        switch (apiFilter.getOp()) {
            case AND: {
                return LogicalCondition.create(Condition.Op.AND, this.convertConditions(apiVersion, resolver, apiFilter.getFiltersList()));
            }
        }
        throw new InvalidConversionException("Unsupported CompositeFilter operator.");
    }

    private Condition convertCondition(InternalHeader.ApiVersion apiVersion, ProjectIdAppIdResolver resolver, StructuredQuery.FieldFilter apiFilter) throws InvalidConversionException {
        PropertyPath propertyPath = this.convertPropertyRef(apiVersion, apiFilter.getField());
        StructuredQuery.FieldFilter.Operator apiOperator = apiFilter.getOp();
        if (ARRAY_OPERATORS.contains(apiFilter.getOp())) {
            propertyPath = PropertyPath.create(propertyPath, PropertyPathSegment.AllArrayElements.create());
        }
        Condition.Op op = this.convertOperator(apiVersion, apiOperator);
        Value value = this.entityToRepConverter.convertValue(resolver, apiFilter.getValue()).withDatastoreIndexing(Value.DatastoreIndexing.INCLUDE);
        if (op == Condition.Op.OR) {
            InvalidConversionException.checkConversion(value.type() == Value.Type.ARRAY && !value.asArray().isEmpty(), "%s requires that value is a non-empty ArrayValue.", apiOperator);
            return this.makeInCondition(propertyPath, value.asArray());
        }
        if (value.isNull()) {
            return this.makeFalseCondition(propertyPath);
        }
        return PropertyValueCondition.create(op, propertyPath, value);
    }

    private Condition makeInCondition(PropertyPath propertyPath, ImmutableList<Value> values) {
        ImmutableList.Builder disjunctions = ImmutableList.builder();
        for (Value value : values) {
            if (value.isNull()) {
                disjunctions.add(this.makeFalseCondition(propertyPath));
                continue;
            }
            disjunctions.add(PropertyValueCondition.create(Condition.Op.EQ, propertyPath, value.withDatastoreIndexing(Value.DatastoreIndexing.INCLUDE)));
        }
        return LogicalCondition.create(Condition.Op.OR, (ImmutableList<Condition>)disjunctions.build());
    }

    private Condition convertCondition(InternalHeader.ApiVersion apiVersion, StructuredQuery.UnaryFilter apiFilter) throws InvalidConversionException {
        if (apiFilter.getOperandTypeCase() != StructuredQuery.UnaryFilter.OperandTypeCase.FIELD) {
            throw new InvalidConversionException("Unsupported UnaryFilter operand type (non-FIELD).");
        }
        PropertyPath propertyPath = this.convertPropertyRef(apiVersion, apiFilter.getField());
        switch (apiFilter.getOp()) {
            case IS_NULL: {
                return PropertyValueCondition.create(Condition.Op.EQ, propertyPath, Value.NULL);
            }
            case IS_NAN: {
                return PropertyValueCondition.create(Condition.Op.REALLY_EQUALS, propertyPath, Value.NAN);
            }
        }
        throw new InvalidConversionException("Unknown UnaryFilter operator.");
    }

    private Condition.Op convertOperator(InternalHeader.ApiVersion apiVersion, StructuredQuery.FieldFilter.Operator apiOperator) throws InvalidConversionException {
        switch (apiOperator) {
            case LESS_THAN: {
                return Condition.Op.LT;
            }
            case LESS_THAN_OR_EQUAL: {
                return Condition.Op.LE;
            }
            case GREATER_THAN: {
                return Condition.Op.GT;
            }
            case GREATER_THAN_OR_EQUAL: {
                return Condition.Op.GE;
            }
            case EQUAL: {
                return Condition.Op.EQ;
            }
            case ARRAY_CONTAINS: {
                return Condition.Op.EQ;
            }
            case IN: 
            case ARRAY_CONTAINS_ANY: {
                InvalidConversionException.checkConversion(this.enableDisjunctiveQueries, "'%s' filters are not supported.", apiOperator);
                InvalidConversionException.checkConversion(apiVersion != InternalHeader.ApiVersion.FIRESTORE_V1BETA1, "'%s' filters are not supported in Firestore v1beta1, please upgrade to v1.", apiOperator);
                return Condition.Op.OR;
            }
        }
        throw new InvalidConversionException("Unknown FieldFilter operator.");
    }

    private Condition makeFalseCondition(PropertyPath path) {
        if (path.isArrayElements()) {
            return PropertyValueCondition.create(Condition.Op.EQ, path, Value.EMPTY_ARRAY);
        }
        return LogicalCondition.create(Condition.Op.AND, PropertyValueCondition.create(Condition.Op.EQ, path, Value.TRUE), PropertyValueCondition.create(Condition.Op.EQ, path, Value.FALSE));
    }

    private ImmutableList<PropertyPathWithDirection> convertOrders(InternalHeader.ApiVersion apiVersion, List<StructuredQuery.Order> apiOrderBys) throws InvalidConversionException {
        ImmutableList.Builder projectionPropertyPathWithDirections = ImmutableList.builder();
        for (StructuredQuery.Order apiOrderBy : apiOrderBys) {
            PropertyPath propertyPath = this.convertPropertyRef(apiVersion, apiOrderBy.getField());
            Direction direction = apiOrderBy.getDirection() == StructuredQuery.Direction.DESCENDING ? Direction.DESCENDING : Direction.ASCENDING;
            projectionPropertyPathWithDirections.add(PropertyPathWithDirection.create(propertyPath, direction));
        }
        return projectionPropertyPathWithDirections.build();
    }

    private ImmutableList<PropertyPath> makeCursorPropertyPaths(ImmutableList<PropertyPathWithDirection> orderBys) {
        ImmutableList.Builder cursorPropertyPathsBuilder = ImmutableList.builder();
        for (PropertyPathWithDirection orderBy : orderBys) {
            cursorPropertyPathsBuilder.add(orderBy.propertyPath());
        }
        return cursorPropertyPathsBuilder.build();
    }

    com.google.cloud.datastore.core.rep.Cursor convertCursor(ProjectIdAppIdResolver resolver, ImmutableList<PropertyPath> propertyPaths, Cursor apiPosition) throws InvalidConversionException {
        int numProperties = propertyPaths.size();
        List<com.google.firestore.v1.Value> apiValueList = apiPosition.getValuesList();
        int numValues = apiValueList.size();
        InvalidConversionException.checkConversion(numValues <= numProperties, "Cursor has too many values.", new Object[0]);
        EntityRef key = null;
        ImmutableList.Builder indexValuesBuilder = ImmutableList.builder();
        for (int index = 0; index < numValues; ++index) {
            PropertyPath propertyPath = (PropertyPath)propertyPaths.get(index);
            com.google.firestore.v1.Value apiValue = apiValueList.get(index);
            Value value = this.entityToRepConverter.convertValue(resolver, apiValue);
            if (propertyPath.isKey()) {
                InvalidConversionException.checkConversion(value.type() == Value.Type.ENTITY_REF, "Cursor %s value is not a document reference.", ReservedName.KEY.asString());
                key = value.asEntityRef();
                break;
            }
            IndexValue indexValue = ValueToFirestoreIndexValueConverter.DEFAULT.convertValueTruncateIfThresholdExceeded(value);
            UnifiedIndexValue unifiedIndexValue = UnifiedIndexValue.create(indexValue);
            indexValuesBuilder.add(unifiedIndexValue);
        }
        return com.google.cloud.datastore.core.rep.Cursor.create(key, propertyPaths, (ImmutableList<UnifiedIndexValue>)indexValuesBuilder.build(), apiPosition.getBefore());
    }

    private PropertyPath convertPropertyRef(InternalHeader.ApiVersion apiVersion, StructuredQuery.FieldReference apiFieldReference) throws InvalidConversionException {
        return this.propertyPathToRepConverter.convertFieldPathToPropertyPath(apiVersion, apiFieldReference.getFieldPath());
    }
}

