/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.firestorev1.converter;

import com.google.cloud.datastore.core.exception.InvalidConversionException;

public class FirestoreV1ResourceNameParser {
    static final String SERVICE_RESOURCE_NAME_PREFIX = "//firestore.googleapis.com/";
    static final String PROJECT_COLLECTION_ID = "projects";
    static final String DATABASE_COLLECTION_ID = "databases";
    static final String DEFAULT_DATABASE_ID = "(default)";
    static final String NAMESPACE_COLLECTION_ID = "namespaces";
    static final String DEFAULT_NAMESPACE_ID = "(default)";
    static final String DOCUMENT_SPECIFIER = "documents";
    static final char NAMESPACE_DELIMITER_CHAR = '@';
    private static final String INVALID_TRAILING_SLASH_ERROR_MSG = "%s name \"%s\" has invalid trailing \"/\".";
    static final String NONE_RESOURCE_ID = "__none__";
    private final String resourceFlavor;
    private final String text;
    private int index;

    FirestoreV1ResourceNameParser(boolean withServicePrefix, String resourceFlavor, String text) throws InvalidConversionException {
        this.resourceFlavor = resourceFlavor;
        this.text = text;
        if (withServicePrefix) {
            InvalidConversionException.checkConversion(text.startsWith(SERVICE_RESOURCE_NAME_PREFIX), "%s \"%s\" does not start with \"%s\".", resourceFlavor, text, SERVICE_RESOURCE_NAME_PREFIX);
            this.index = SERVICE_RESOURCE_NAME_PREFIX.length();
        } else {
            this.index = 0;
        }
    }

    String resourceFlavor() {
        return this.resourceFlavor;
    }

    public String text() {
        return this.text;
    }

    public boolean isEnd() {
        return this.index == this.text.length();
    }

    public boolean peek(String expectedId) {
        int expectedIdLength = expectedId.length();
        int terminatorIndex = this.index + expectedIdLength;
        return this.text.regionMatches(this.index, expectedId, 0, expectedIdLength) && (this.text.length() == terminatorIndex || this.text.charAt(terminatorIndex) == '/');
    }

    boolean peekPrefix(String expectedPrefix) {
        return this.text.regionMatches(this.index, expectedPrefix, 0, expectedPrefix.length());
    }

    void parseCollectionId(String expectedCollectionId) throws InvalidConversionException {
        int expectedCollectionIdLength = expectedCollectionId.length();
        InvalidConversionException.checkConversion(this.text.regionMatches(this.index, expectedCollectionId, 0, expectedCollectionIdLength), "%s name \"%s\" lacks \"%s\" at index %d.", this.resourceFlavor, this.text, expectedCollectionId, this.index);
        this.index += expectedCollectionIdLength;
    }

    String parseId(String expectedIdFlavor) throws InvalidConversionException {
        int idTermIndex = this.text.indexOf(47, this.index);
        if (idTermIndex < 0) {
            idTermIndex = this.text.length();
        }
        InvalidConversionException.checkConversion(idTermIndex > this.index, "%s name \"%s\" lacks %s at index %d.", this.resourceFlavor, this.text, expectedIdFlavor, this.index);
        String id = this.text.substring(this.index, idTermIndex);
        InvalidConversionException.checkConversion(!id.equals(".") && !id.equals(".."), "%s name \"%s\" contains %s \"%s\" at index %d.", this.resourceFlavor, this.text, expectedIdFlavor, id, this.index);
        this.index = idTermIndex;
        return id;
    }

    void parseSlash() throws InvalidConversionException {
        this.parseSlashAllowTrailing();
        InvalidConversionException.checkConversion(!this.isEnd(), INVALID_TRAILING_SLASH_ERROR_MSG, this.resourceFlavor, this.text);
    }

    void parseSlashAllowTrailing() throws InvalidConversionException {
        InvalidConversionException.checkConversion(this.index < this.text.length() && this.text.charAt(this.index) == '/', "%s name \"%s\" lacks \"/\" at index %d.", this.resourceFlavor, this.text, this.index);
        ++this.index;
    }

    public void end() throws InvalidConversionException {
        if (this.isEnd()) {
            return;
        }
        if (this.text.charAt(this.index) == '/' && this.index + 1 == this.text.length()) {
            throw new InvalidConversionException(String.format(INVALID_TRAILING_SLASH_ERROR_MSG, this.resourceFlavor, this.text));
        }
        throw new InvalidConversionException(String.format("%s name \"%s\" has extra characters at index %d.", this.resourceFlavor, this.text, this.index));
    }
}

