/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.firestorev1.converter;

import com.google.cloud.datastore.core.exception.InvalidConversionException;
import com.google.cloud.datastore.core.firestorev1.converter.FirestoreV1EntityToRepConverter;
import com.google.cloud.datastore.core.firestorev1.converter.FirestoreV1PropertyPathToRepConverter;
import com.google.cloud.datastore.core.names.ProjectIdAppIdResolver;
import com.google.cloud.datastore.core.rep.DatabaseIndexGroup;
import com.google.cloud.datastore.core.rep.EntityTransformation;
import com.google.cloud.datastore.core.rep.PropertyName;
import com.google.cloud.datastore.core.rep.PropertyPath;
import com.google.cloud.datastore.core.rep.PropertyPathSegment;
import com.google.cloud.datastore.core.rep.TransformationFunctions;
import com.google.cloud.datastore.core.rep.Value;
import com.google.cloud.datastore.core.rep.ValueOrder;
import com.google.cloud.datastore.internal.InternalHeader;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.firestore.v1.ArrayValue;
import com.google.firestore.v1.DocumentTransform;
import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Timestamps;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class FirestoreV1TransformationToRepConverter {
    private final ValueOrder valueOrder;
    private final FirestoreV1PropertyPathToRepConverter propertyPathToRepConverter;
    private final FirestoreV1EntityToRepConverter entityToRepConverter;
    private final boolean enableNumericTransforms;

    public FirestoreV1TransformationToRepConverter(ValueOrder valueOrder, FirestoreV1PropertyPathToRepConverter propertyPathToRepConverter, FirestoreV1EntityToRepConverter entityToRepConverter, boolean enableNumericTransforms) {
        this.valueOrder = Preconditions.checkNotNull(valueOrder);
        this.propertyPathToRepConverter = Preconditions.checkNotNull(propertyPathToRepConverter);
        this.entityToRepConverter = Preconditions.checkNotNull(entityToRepConverter);
        this.enableNumericTransforms = enableNumericTransforms;
    }

    public EntityTransformation convertTransformation(ProjectIdAppIdResolver resolver, DatabaseIndexGroup databaseIndexGroup, InternalHeader.ApiVersion apiVersion, DocumentTransform transform, Timestamp requestTime) throws InvalidConversionException {
        List<DocumentTransform.FieldTransform> fieldTransforms = transform.getFieldTransformsList();
        InvalidConversionException.checkConversion(!fieldTransforms.isEmpty(), "The list of FieldTransform must not be empty.", new Object[0]);
        ImmutableList.Builder propertyTransformations = ImmutableList.builder();
        HashSet<PropertyPath> examinedPaths = new HashSet<PropertyPath>();
        TransformationPathTree tree = new TransformationPathTree();
        for (DocumentTransform.FieldTransform fieldTransform : fieldTransforms) {
            EntityTransformation.PropertyTransformation propertyTransformation = this.convertFieldTransform(resolver, databaseIndexGroup, apiVersion, fieldTransform, requestTime);
            if (!examinedPaths.contains(propertyTransformation.propertyPath())) {
                tree.addPath(propertyTransformation.propertyPath());
                examinedPaths.add(propertyTransformation.propertyPath());
            }
            propertyTransformations.add(propertyTransformation);
        }
        return EntityTransformation.create((ImmutableList<EntityTransformation.PropertyTransformation>)propertyTransformations.build());
    }

    private EntityTransformation.PropertyTransformation convertFieldTransform(ProjectIdAppIdResolver resolver, DatabaseIndexGroup databaseIndexGroup, InternalHeader.ApiVersion apiVersion, DocumentTransform.FieldTransform fieldTransform, Timestamp requestTime) throws InvalidConversionException {
        String fieldPath = fieldTransform.getFieldPath();
        PropertyPath propertyPath = this.propertyPathToRepConverter.convertFieldPathToPropertyPath(apiVersion, fieldPath);
        switch (fieldTransform.getTransformTypeCase()) {
            case SET_TO_SERVER_VALUE: {
                DocumentTransform.FieldTransform.ServerValue serverValue = fieldTransform.getSetToServerValue();
                switch (serverValue) {
                    case REQUEST_TIME: {
                        Timestamp requestTimeMs = Timestamps.fromMillis(Timestamps.toMillis(requestTime));
                        com.google.firestore.v1.Value requestTimeV1Value = com.google.firestore.v1.Value.newBuilder().setTimestampValue(requestTimeMs).build();
                        Value requestTimeValue = this.entityToRepConverter.convertValue(resolver, databaseIndexGroup, requestTimeV1Value);
                        return EntityTransformation.PropertyTransformation.create(propertyPath, TransformationFunctions.setToConstant(requestTimeValue));
                    }
                }
                throw new InvalidConversionException("ServerValue type must be specified for set_to_server_value transformation.");
            }
            case INCREMENT: {
                if (!this.enableNumericTransforms) {
                    throw new InvalidConversionException("Operation not allowed.");
                }
                Value addOperand = this.entityToRepConverter.convertValue(resolver, databaseIndexGroup, fieldTransform.getIncrement());
                InvalidConversionException.checkConversion(TransformationFunctions.isValueNumberOrNaN(addOperand), "Input must be int64 or double.", new Object[0]);
                return EntityTransformation.PropertyTransformation.create(propertyPath, TransformationFunctions.increment(addOperand));
            }
            case MAXIMUM: {
                if (!this.enableNumericTransforms) {
                    throw new InvalidConversionException("Operation not allowed.");
                }
                Value maxOperand = this.entityToRepConverter.convertValue(resolver, databaseIndexGroup, fieldTransform.getMaximum());
                InvalidConversionException.checkConversion(TransformationFunctions.isValueNumberOrNaN(maxOperand), "Input must be int64 or double.", new Object[0]);
                return EntityTransformation.PropertyTransformation.create(propertyPath, TransformationFunctions.maximum(this.valueOrder, maxOperand));
            }
            case MINIMUM: {
                if (!this.enableNumericTransforms) {
                    throw new InvalidConversionException("Operation not allowed.");
                }
                Value minOperand = this.entityToRepConverter.convertValue(resolver, databaseIndexGroup, fieldTransform.getMinimum());
                InvalidConversionException.checkConversion(TransformationFunctions.isValueNumberOrNaN(minOperand), "Input must be int64 or double.", new Object[0]);
                return EntityTransformation.PropertyTransformation.create(propertyPath, TransformationFunctions.minimum(this.valueOrder, minOperand));
            }
            case APPEND_MISSING_ELEMENTS: {
                Value toAppend = this.convertArrayValue(resolver, databaseIndexGroup, fieldTransform.getAppendMissingElements());
                return EntityTransformation.PropertyTransformation.create(propertyPath, TransformationFunctions.appendMissingElements(this.valueOrder, toAppend));
            }
            case REMOVE_ALL_FROM_ARRAY: {
                Value removeAllFromArrayOperand = this.convertArrayValue(resolver, databaseIndexGroup, fieldTransform.getRemoveAllFromArray());
                return EntityTransformation.PropertyTransformation.create(propertyPath, TransformationFunctions.removeAllFromArray(this.valueOrder, removeAllFromArrayOperand));
            }
        }
        throw new InvalidConversionException("Operation type must be specified for field transformation.");
    }

    private Value convertArrayValue(ProjectIdAppIdResolver resolver, DatabaseIndexGroup databaseIndexGroup, ArrayValue v1Array) throws InvalidConversionException {
        com.google.firestore.v1.Value v1Value = com.google.firestore.v1.Value.newBuilder().setArrayValue(v1Array).build();
        return this.entityToRepConverter.convertValue(resolver, databaseIndexGroup, v1Value);
    }

    private class TransformationPathTree {
        private PropertyPath fullPath = null;
        private final Map<PropertyName, TransformationPathTree> subTrees = new HashMap<PropertyName, TransformationPathTree>();

        TransformationPathTree() {
        }

        public void addPath(PropertyPath path) throws InvalidConversionException {
            this.addPath(path, path);
        }

        private void addPath(PropertyPath path, PropertyPath fullPath) throws InvalidConversionException {
            if (path == null && !this.subTrees.isEmpty() || path != null && this.fullPath != null) {
                throw new InvalidConversionException(String.format("Cannot transform property %s and its nested property at the same time.", path == null ? fullPath.toString() : this.fullPath.toString()));
            }
            if (path == null) {
                this.fullPath = fullPath;
                return;
            }
            PropertyPathSegment segment = path.segment();
            InvalidConversionException.checkConversion(segment instanceof PropertyPathSegment.Member, "Field transformation paths currently support only \".\".", new Object[0]);
            PropertyName name = ((PropertyPathSegment.Member)segment).name();
            this.subTrees.computeIfAbsent(name, k -> new TransformationPathTree());
            this.subTrees.get(name).addPath(path.next(), fullPath);
        }
    }
}

