/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.firestorev1.converter;

import com.google.apphosting.datastore.DatastoreV3Pb;
import com.google.cloud.datastore.core.appengv3.converter.AppEngV3EntityFromRepConverter;
import com.google.cloud.datastore.core.appengv3.converter.AppEngV3ResourceRefFromRepConverter;
import com.google.cloud.datastore.core.appengv3.converter.AppEngV3ToRepConverter;
import com.google.cloud.datastore.core.config.proto1api.DatastoreCustomizableConfigPb;
import com.google.cloud.datastore.core.exception.DatastoreException;
import com.google.cloud.datastore.core.exception.DatastoreExceptionHelper;
import com.google.cloud.datastore.core.exception.InvalidConversionException;
import com.google.cloud.datastore.core.firestorev1.converter.FirestoreV1EntityToRepConverter;
import com.google.cloud.datastore.core.firestorev1.converter.FirestoreV1KeystoreClient;
import com.google.cloud.datastore.core.firestorev1.converter.FirestoreV1PropertyPathToRepConverter;
import com.google.cloud.datastore.core.firestorev1.converter.FirestoreV1QueryToRepConverter;
import com.google.cloud.datastore.core.firestorev1.converter.FirestoreV1ResourceRefToRepConverter;
import com.google.cloud.datastore.core.firestorev1.converter.FirestoreV1TransformationToRepConverter;
import com.google.cloud.datastore.core.internal.Transactions;
import com.google.cloud.datastore.core.names.Names;
import com.google.cloud.datastore.core.names.ProjectIdAppIdResolver;
import com.google.cloud.datastore.core.rep.Cursor;
import com.google.cloud.datastore.core.rep.DatabaseIndexGroup;
import com.google.cloud.datastore.core.rep.DatabaseRef;
import com.google.cloud.datastore.core.rep.Entity;
import com.google.cloud.datastore.core.rep.EntityRef;
import com.google.cloud.datastore.core.rep.EntityTransformation;
import com.google.cloud.datastore.core.rep.IdAllocationPolicy;
import com.google.cloud.datastore.core.rep.Lookup;
import com.google.cloud.datastore.core.rep.Mutation;
import com.google.cloud.datastore.core.rep.PartitionRef;
import com.google.cloud.datastore.core.rep.PropertyMask;
import com.google.cloud.datastore.core.rep.PropertyName;
import com.google.cloud.datastore.core.rep.Query;
import com.google.cloud.datastore.core.rep.QueryScope;
import com.google.cloud.datastore.core.rep.ResourceRef;
import com.google.cloud.datastore.core.rep.ShardQueryRequest;
import com.google.cloud.datastore.core.rep.TransactionOptions;
import com.google.cloud.datastore.core.rep.Value;
import com.google.cloud.datastore.core.rep.Write;
import com.google.cloud.datastore.core.rep.WriteHelper;
import com.google.cloud.datastore.core.rep.converter.ConverterHelper;
import com.google.cloud.datastore.core.rep.converter.EquivalentMessageConverter;
import com.google.cloud.datastore.core.rep.proto.QueryResumeToken;
import com.google.cloud.datastore.core.rep.validator.ValidationConstraint;
import com.google.cloud.datastore.internal.InternalHeader;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.firestore.v1.BatchGetDocumentsRequest;
import com.google.firestore.v1.BatchWriteRequest;
import com.google.firestore.v1.CommitRequest;
import com.google.firestore.v1.CreateDocumentRequest;
import com.google.firestore.v1.DeleteDocumentRequest;
import com.google.firestore.v1.Document;
import com.google.firestore.v1.DocumentMask;
import com.google.firestore.v1.DocumentTransform;
import com.google.firestore.v1.GetDocumentRequest;
import com.google.firestore.v1.ListCollectionIdsRequest;
import com.google.firestore.v1.ListDocumentsRequest;
import com.google.firestore.v1.PartitionQueryRequest;
import com.google.firestore.v1.Precondition;
import com.google.firestore.v1.RunQueryRequest;
import com.google.firestore.v1.StructuredQuery;
import com.google.firestore.v1.TransactionOptions;
import com.google.firestore.v1.UpdateDocumentRequest;
import com.google.firestore.v1.Write;
import com.google.protobuf.ByteString;
import com.google.protobuf.Timestamp;
import com.google.storage.onestore.v3.OnestoreEntity;
import com.google.storage.onestore.v3.proto2api.OnestoreEntity;
import java.util.Base64;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;

public class NewFirestoreV1RequestToRepConverter {
    private static final PropertyName DOCUMENT_KIND_DOCUMENT_KEY_PROPERTY_NAME = PropertyName.create("document_key");
    private static final PropertyName DOCUMENT_KIND_DOCUMENT_FIELDS_PROPERTY_NAME = PropertyName.create("document");
    private static final PropertyName DOCUMENT_KIND_CREATED_VERSION_PROPERTY_NAME = PropertyName.create("created");
    private static final PropertyName DOCUMENT_KIND_UPDATED_VERSION_PROPERTY_NAME = PropertyName.create("updated");
    private static final Function<OnestoreEntity.IndexPostfix, OnestoreEntity.IndexPostfix> INDEX_POSTFIX_PROTO_2_TO_1_CONVERTER = EquivalentMessageConverter.create(OnestoreEntity.IndexPostfix.parser());
    private final AppEngV3EntityFromRepConverter v3EntityFromRepConverter;
    private final AppEngV3ToRepConverter v3ToRepConverter;
    private final FirestoreV1EntityToRepConverter entityToRepConverter;
    private final FirestoreV1PropertyPathToRepConverter propertyPathToRepConverter;
    private final FirestoreV1ResourceRefToRepConverter resourceRefToRepConverter;
    private final FirestoreV1QueryToRepConverter queryToRepConverter;
    private final FirestoreV1TransformationToRepConverter transformationToRepConverter;
    private final FirestoreV1KeystoreClient firestoreV1KeystoreClient;
    private final boolean verifyEnabled;

    public NewFirestoreV1RequestToRepConverter(FirestoreV1EntityToRepConverter entityToRepConverter, FirestoreV1ResourceRefToRepConverter resourceRefToRepConverter, FirestoreV1PropertyPathToRepConverter propertyPathToRepConverter, FirestoreV1TransformationToRepConverter transformationToRepConverter, AppEngV3EntityFromRepConverter v3EntityFromRepConverter, AppEngV3ToRepConverter v3ToRepConverter, FirestoreV1QueryToRepConverter queryToRepConverter, FirestoreV1KeystoreClient firestoreV1KeystoreClient, boolean verifyEnabled) {
        this.entityToRepConverter = Preconditions.checkNotNull(entityToRepConverter);
        this.resourceRefToRepConverter = Preconditions.checkNotNull(resourceRefToRepConverter);
        this.propertyPathToRepConverter = Preconditions.checkNotNull(propertyPathToRepConverter);
        this.transformationToRepConverter = Preconditions.checkNotNull(transformationToRepConverter);
        this.v3EntityFromRepConverter = Preconditions.checkNotNull(v3EntityFromRepConverter);
        this.v3ToRepConverter = Preconditions.checkNotNull(v3ToRepConverter);
        this.queryToRepConverter = Preconditions.checkNotNull(queryToRepConverter);
        this.firestoreV1KeystoreClient = Preconditions.checkNotNull(firestoreV1KeystoreClient);
        this.verifyEnabled = verifyEnabled;
    }

    public com.google.cloud.datastore.core.rep.Write toWrite(InternalHeader.ApiVersion apiVersion, ProjectIdAppIdResolver resolver, DatabaseIndexGroup databaseIndexGroupSupplier, CreateDocumentRequest request) throws DatastoreException {
        EntityRef ref = this.constructNewEntityRef(apiVersion, resolver, request);
        ImmutableMap<String, Value> fields = this.entityToRepConverter.convertDocumentFields(resolver, databaseIndexGroupSupplier, request.getDocument());
        Entity entity = Entity.create(ref, fields);
        OnestoreEntity.EntityProto entityProto = this.v3EntityFromRepConverter.convertEntity(entity);
        PropertyMask readMask = request.hasMask() ? this.propertyPathToRepConverter.convertPropertyMask(apiVersion, request.getMask(), ValidationConstraint.LOOKUP.withContext(ValidationConstraint.Context.FIRESTORE)) : PropertyMask.FULL;
        return com.google.cloud.datastore.core.rep.Write.builder().idPolicy(IdAllocationPolicy.FIRESTORE_V1_AUTO).mutations(Collections.singleton(Mutation.insert(entityProto).readPropertyMask(readMask).build())).build();
    }

    public com.google.cloud.datastore.core.rep.Write toWrite(ProjectIdAppIdResolver resolver, DeleteDocumentRequest request) throws InvalidConversionException {
        Mutation mutation = this.toDeleteMutation(resolver, request.getName(), request.getCurrentDocument());
        return com.google.cloud.datastore.core.rep.Write.builder().mutations(Collections.singleton(mutation)).build();
    }

    public com.google.cloud.datastore.core.rep.Write toWrite(InternalHeader.ApiVersion apiVersion, ProjectIdAppIdResolver resolver, DatabaseIndexGroup databaseIndexGroup, UpdateDocumentRequest request) throws DatastoreException {
        PropertyMask readMask = request.hasMask() ? this.propertyPathToRepConverter.convertPropertyMask(apiVersion, request.getMask(), ValidationConstraint.LOOKUP.withContext(ValidationConstraint.Context.FIRESTORE)) : PropertyMask.FULL;
        Mutation mutation = this.toUpdateMutationBuilder(apiVersion, resolver, databaseIndexGroup, request.getDocument(), request.hasUpdateMask() ? request.getUpdateMask() : null, request.getCurrentDocument()).readPropertyMask(readMask).build();
        return com.google.cloud.datastore.core.rep.Write.builder().mutations(Collections.singleton(mutation)).build();
    }

    public com.google.cloud.datastore.core.rep.Write toWrite(InternalHeader.ApiVersion apiVersion, ProjectIdAppIdResolver resolver, DatabaseIndexGroup databaseIndexGroup, CommitRequest request, Timestamp requestTime) throws InvalidConversionException {
        ImmutableList.Builder mutations = ImmutableList.builder();
        for (Write write : request.getWritesList()) {
            Mutation mutation = this.toMutation(apiVersion, resolver, databaseIndexGroup, write, requestTime);
            mutations.add(mutation);
        }
        Write.Builder builder = WriteHelper.toWrite(false, false, (List<Mutation>)((Object)mutations.build()));
        return builder.build();
    }

    public com.google.cloud.datastore.core.rep.Write toWrite(InternalHeader.ApiVersion apiVersion, ProjectIdAppIdResolver resolver, DatabaseIndexGroup databaseIndexGroup, BatchWriteRequest request, Timestamp requestTime) throws InvalidConversionException {
        ImmutableList.Builder mutations = ImmutableList.builder();
        for (Write write : request.getWritesList()) {
            Mutation mutation = this.toMutation(apiVersion, resolver, databaseIndexGroup, write, requestTime);
            mutations.add(mutation);
        }
        Write.Builder builder = WriteHelper.toWrite(false, false, (List<Mutation>)((Object)mutations.build()));
        return builder.build();
    }

    public Lookup toLookup(InternalHeader.ApiVersion apiVersion, ProjectIdAppIdResolver resolver, GetDocumentRequest request) throws InvalidConversionException {
        EntityRef repEntityRef = this.resourceRefToRepConverter.convertEntityRefServiceRelative(resolver, request.getName());
        OnestoreEntity.Reference v3Ref = AppEngV3ResourceRefFromRepConverter.INSTANCE.convertEntityRef(repEntityRef);
        Lookup.Builder lookup = Lookup.builder().keys(ImmutableList.of(v3Ref));
        switch (request.getConsistencySelectorCase()) {
            case READ_TIME: {
                long readTimestampMicros = ConverterHelper.timestampsToMicroseconds(request.getReadTime());
                InvalidConversionException.checkConversion(readTimestampMicros > 0L, "Only timestamps past epoch are supported.", new Object[0]);
                lookup.readTimestamp(readTimestampMicros);
                break;
            }
        }
        if (request.hasMask()) {
            lookup.propertyMask(this.propertyPathToRepConverter.convertPropertyMask(apiVersion, request.getMask(), ValidationConstraint.LOOKUP.withContext(ValidationConstraint.Context.FIRESTORE)));
        }
        return lookup.build();
    }

    public Mutation toMutation(InternalHeader.ApiVersion apiVersion, ProjectIdAppIdResolver resolver, DatabaseIndexGroup databaseIndexGroup, Write write, Timestamp requestTime) throws InvalidConversionException {
        switch (write.getOperationCase()) {
            case OPERATION_NOT_SET: {
                throw new InvalidConversionException("empty write operation");
            }
            case DELETE: {
                InvalidConversionException.checkConversion(!write.hasUpdateMask(), "a delete must not specify a document mask.", new Object[0]);
                return this.toDeleteMutation(resolver, write.getDelete(), write.getCurrentDocument());
            }
            case UPDATE: {
                return this.toUpdateMutationBuilder(apiVersion, resolver, databaseIndexGroup, write.getUpdate(), write.hasUpdateMask() ? write.getUpdateMask() : null, write.getCurrentDocument()).build();
            }
            case TRANSFORM: {
                InvalidConversionException.checkConversion(!write.hasUpdateMask(), "a transform must not specify a document mask.", new Object[0]);
                return this.toTransformMutation(apiVersion, resolver, databaseIndexGroup, write.getTransform(), write.getCurrentDocument(), requestTime);
            }
            case VERIFY: {
                InvalidConversionException.checkConversion(this.verifyEnabled, "verify is not supported.", new Object[0]);
                InvalidConversionException.checkConversion(apiVersion != InternalHeader.ApiVersion.FIRESTORE_V1BETA1, "verify is not supported in Firestore v1beta1, please upgrade to v1. %s", apiVersion);
                InvalidConversionException.checkConversion(!write.hasUpdateMask(), "a verify must not specify a document mask.", new Object[0]);
                return this.toVerifyMutation(resolver, write.getVerify(), write.getCurrentDocument());
            }
        }
        String string = String.valueOf(write.getOperationCase());
        throw new IllegalArgumentException(new StringBuilder(23 + String.valueOf(string).length()).append("invalid operation type ").append(string).toString());
    }

    private Mutation.Builder toUpdateMutationBuilder(InternalHeader.ApiVersion apiVersion, ProjectIdAppIdResolver resolver, DatabaseIndexGroup databaseIndexGroup, Document document, @Nullable DocumentMask writeDocumentMask, Precondition precondition) throws InvalidConversionException {
        Entity entity = this.entityToRepConverter.convertEntity(resolver, databaseIndexGroup, document);
        PropertyMask writeMask = writeDocumentMask == null ? PropertyMask.FULL : this.propertyPathToRepConverter.convertPropertyMask(apiVersion, writeDocumentMask, ValidationConstraint.UPSERT.withContext(ValidationConstraint.Context.FIRESTORE));
        OnestoreEntity.EntityProto v3Entity = this.v3EntityFromRepConverter.convertEntity(entity);
        switch (precondition.getConditionTypeCase()) {
            case CONDITIONTYPE_NOT_SET: {
                return Mutation.upsert(v3Entity).writePropertyMask(writeMask);
            }
            case EXISTS: {
                Mutation.Op op = precondition.getExists() ? Mutation.Op.UPDATE : Mutation.Op.INSERT;
                return Mutation.builder().op(op).key(v3Entity.getKey()).entity(v3Entity).writePropertyMask(writeMask);
            }
            case UPDATE_TIME: {
                Mutation.Builder mutationBuilder = Mutation.builder().entityAndFullMask(v3Entity).writePropertyMask(writeMask);
                NewFirestoreV1RequestToRepConverter.implyExistencePreconditionFromUpdateTime(mutationBuilder, Mutation.Operation.WRITE, precondition.getUpdateTime());
                return mutationBuilder;
            }
        }
        throw new AssertionError((Object)"unreachable");
    }

    private Mutation toDeleteMutation(ProjectIdAppIdResolver resolver, String name, Precondition precondition) throws InvalidConversionException {
        EntityRef ref = this.resourceRefToRepConverter.convertEntityRefServiceRelative(resolver, name);
        OnestoreEntity.Reference v3Ref = AppEngV3ResourceRefFromRepConverter.INSTANCE.convertEntityRef(ref);
        switch (precondition.getConditionTypeCase()) {
            case CONDITIONTYPE_NOT_SET: {
                return Mutation.delete(v3Ref).build();
            }
            case EXISTS: {
                Mutation.Op op = precondition.getExists() ? Mutation.Op.DELETE_MUST_EXIST : Mutation.Op.DELETE_MUST_NOT_EXIST;
                return Mutation.builder().op(op).key(v3Ref).build();
            }
            case UPDATE_TIME: {
                return Mutation.delete(v3Ref).baseVersion(ConverterHelper.timestampsToMicroseconds(precondition.getUpdateTime())).conflictResolutionStrategy(Mutation.ConflictResolutionStrategy.FAIL).build();
            }
        }
        throw new AssertionError((Object)"unreachable");
    }

    private Mutation toVerifyMutation(ProjectIdAppIdResolver resolver, String name, Precondition precondition) throws InvalidConversionException {
        EntityRef ref = this.resourceRefToRepConverter.convertEntityRefServiceRelative(resolver, name);
        OnestoreEntity.Reference v3Ref = AppEngV3ResourceRefFromRepConverter.INSTANCE.convertEntityRef(ref);
        switch (precondition.getConditionTypeCase()) {
            case CONDITIONTYPE_NOT_SET: {
                throw new InvalidConversionException("a verify must contain a precondition");
            }
            case EXISTS: {
                Mutation.Op op = precondition.getExists() ? Mutation.Op.VERIFY_MUST_EXIST : Mutation.Op.VERIFY_MUST_NOT_EXIST;
                return Mutation.builder().op(op).key(v3Ref).build();
            }
            case UPDATE_TIME: {
                Mutation.Builder mutationBuilder = Mutation.builder().key(v3Ref);
                NewFirestoreV1RequestToRepConverter.implyExistencePreconditionFromUpdateTime(mutationBuilder, Mutation.Operation.VERIFY, precondition.getUpdateTime());
                return mutationBuilder.build();
            }
        }
        throw new AssertionError((Object)"unreachable");
    }

    private Mutation toTransformMutation(InternalHeader.ApiVersion apiVersion, ProjectIdAppIdResolver resolver, DatabaseIndexGroup databaseIndexGroup, DocumentTransform docTransform, Precondition precondition, Timestamp requestTime) throws InvalidConversionException {
        EntityRef ref = this.resourceRefToRepConverter.convertEntityRefServiceRelative(resolver, docTransform.getDocument());
        Entity emptyEntity = Entity.create(ref, ImmutableMap.of());
        OnestoreEntity.EntityProto v3Entity = this.v3EntityFromRepConverter.convertEntity(emptyEntity);
        PropertyMask emptyMask = new PropertyMask(ImmutableMap.of());
        EntityTransformation entityTransformation = this.transformationToRepConverter.convertTransformation(resolver, databaseIndexGroup, apiVersion, docTransform, requestTime);
        Mutation.Builder mutationBuilder = Mutation.builder().entityAndFullMask(v3Entity).writePropertyMask(emptyMask).transformation(entityTransformation).transformationOnly(true);
        switch (precondition.getConditionTypeCase()) {
            case CONDITIONTYPE_NOT_SET: {
                return mutationBuilder.op(Mutation.Op.UPSERT).build();
            }
            case EXISTS: {
                Mutation.Op op = precondition.getExists() ? Mutation.Op.UPDATE : Mutation.Op.INSERT;
                return mutationBuilder.op(op).build();
            }
            case UPDATE_TIME: {
                NewFirestoreV1RequestToRepConverter.implyExistencePreconditionFromUpdateTime(mutationBuilder, Mutation.Operation.WRITE, precondition.getUpdateTime());
                return mutationBuilder.build();
            }
        }
        throw new AssertionError((Object)"unreachable");
    }

    private static void implyExistencePreconditionFromUpdateTime(Mutation.Builder builder, Mutation.Operation operation, Timestamp timestamp) throws InvalidConversionException {
        long baseVersion = ConverterHelper.timestampsToMicroseconds(timestamp);
        Mutation.ExistencePrecondition impliedExistencePrecondition = baseVersion == 0L ? Mutation.ExistencePrecondition.MUST_NOT_EXIST : Mutation.ExistencePrecondition.MUST_EXIST;
        builder.baseVersion(baseVersion).conflictResolutionStrategy(Mutation.ConflictResolutionStrategy.FAIL).op(Mutation.Op.from(operation, impliedExistencePrecondition));
    }

    public EntityRef constructNewEntityRef(InternalHeader.ApiVersion apiVersion, ProjectIdAppIdResolver resolver, CreateDocumentRequest request) throws DatastoreException {
        PartitionRef partitionRef;
        String collectionId = FirestoreV1ResourceRefToRepConverter.convertEntityCollectionId(request.getCollectionId());
        String documentId = request.getDocumentId();
        ResourceRef resourceRef = this.resourceRefToRepConverter.convertEntityParentRefAllowFirestoreRelative(apiVersion, resolver, request.getParent());
        ImmutableList.Builder newEntityRefPathBuilder = ImmutableList.builder();
        if (resourceRef instanceof EntityRef) {
            EntityRef entityRef = (EntityRef)resourceRef;
            partitionRef = entityRef.partitionRef();
            newEntityRefPathBuilder.addAll(entityRef.pathElements());
        } else if (resourceRef instanceof DatabaseRef) {
            partitionRef = PartitionRef.createFromDatabaseRef((DatabaseRef)resourceRef);
        } else if (resourceRef instanceof PartitionRef) {
            partitionRef = (PartitionRef)resourceRef;
        } else {
            throw new InvalidConversionException("invalid parent");
        }
        newEntityRefPathBuilder.add(EntityRef.PathElement.create(collectionId, documentId.isEmpty() ? null : this.resourceRefToRepConverter.convertEntityResourceId(documentId)));
        return EntityRef.create(partitionRef, (List<EntityRef.PathElement>)((Object)newEntityRefPathBuilder.build()));
    }

    public Query toQuery(InternalHeader.ApiVersion apiVersion, ProjectIdAppIdResolver resolver, RunQueryRequest request, long newTransactionId) throws DatastoreException {
        Preconditions.checkArgument(request.getConsistencySelectorCase() == RunQueryRequest.ConsistencySelectorCase.NEW_TRANSACTION == (newTransactionId != 0L));
        InvalidConversionException.checkConversion(request.getQueryTypeCase().equals(RunQueryRequest.QueryTypeCase.STRUCTURED_QUERY), "only structured queries are supported", new Object[0]);
        QueryScope.Builder queryScopeBuilder = QueryScope.builder();
        switch (request.getConsistencySelectorCase()) {
            case CONSISTENCYSELECTOR_NOT_SET: 
            case NEW_TRANSACTION: 
            case TRANSACTION: {
                queryScopeBuilder.isStrong(true);
                break;
            }
            case READ_TIME: {
                long readTimestampMicros = ConverterHelper.timestampsToMicroseconds(request.getReadTime());
                InvalidConversionException.checkConversion(readTimestampMicros > 0L, "Only timestamps past epoch are supported.", new Object[0]);
                queryScopeBuilder.readTimestamp(readTimestampMicros);
            }
        }
        EntityRef parent = this.parseParent(apiVersion, resolver, request.getParent());
        queryScopeBuilder.partition(parent.partitionRef());
        return this.queryToRepConverter.convertStructuredQuery(apiVersion, resolver, queryScopeBuilder.build(), parent.pathElements().isEmpty() ? null : parent, request.getStructuredQuery());
    }

    public Query toQuery(InternalHeader.ApiVersion apiVersion, ProjectIdAppIdResolver resolver, String parent, StructuredQuery structuredQuery) throws DatastoreException {
        EntityRef parentRef = this.parseParent(apiVersion, resolver, parent);
        QueryScope newQueryScope = QueryScope.builder().partition(parentRef.partitionRef()).build();
        return this.queryToRepConverter.convertStructuredQuery(apiVersion, resolver, newQueryScope, parentRef.pathElements().isEmpty() ? null : parentRef, structuredQuery);
    }

    public EntityRef parseParent(InternalHeader.ApiVersion apiVersion, ProjectIdAppIdResolver resolver, String parentName) throws DatastoreException {
        ResourceRef resourceRef = this.resourceRefToRepConverter.convertEntityParentRefAllowFirestoreRelative(apiVersion, resolver, parentName);
        if (resourceRef instanceof EntityRef) {
            return (EntityRef)resourceRef;
        }
        if (resourceRef instanceof PartitionRef) {
            return EntityRef.createEmpty((PartitionRef)resourceRef);
        }
        throw new InvalidConversionException("invalid parent");
    }

    private QueryResumeToken toQueryResumeToken(String pageToken) throws DatastoreException {
        byte[] encrypted;
        try {
            encrypted = Base64.getUrlDecoder().decode(pageToken);
        }
        catch (IllegalArgumentException e) {
            throw DatastoreExceptionHelper.badRequest(e, "invalid page token", new Object[0]);
        }
        return this.firestoreV1KeystoreClient.decryptQueryResumeToken(encrypted);
    }

    private Query.Builder toBaseListDocumentsQuery(InternalHeader.ApiVersion apiVersion, ProjectIdAppIdResolver resolver, ListDocumentsRequest request) throws DatastoreException {
        String parentResourceName = request.getParent();
        String apiCollectionId = request.getCollectionId();
        String orderBy = request.getOrderBy();
        DocumentMask mask = request.hasMask() ? request.getMask() : null;
        Query.Builder baseQueryBuilder = this.toBaseQueryBuilder(apiVersion, resolver, parentResourceName, null, request.getPageSize());
        if (!apiCollectionId.isEmpty()) {
            String collectionId = FirestoreV1ResourceRefToRepConverter.convertEntityCollectionId(apiCollectionId);
            InvalidConversionException.checkConversion(!Names.isNameReserved(collectionId), "a collection id cannot be a reserved name.", new Object[0]);
            baseQueryBuilder.kind(collectionId);
        }
        if (mask != null) {
            baseQueryBuilder.propertyMask(this.propertyPathToRepConverter.convertPropertyMask(apiVersion, mask, ValidationConstraint.QUERY.withContext(ValidationConstraint.Context.FIRESTORE)));
        }
        if (!orderBy.isEmpty()) {
            baseQueryBuilder.orderBy(this.propertyPathToRepConverter.convertOrderBy(apiVersion, orderBy));
        }
        return baseQueryBuilder;
    }

    private Query.Builder toBaseQueryBuilder(InternalHeader.ApiVersion apiVersion, ProjectIdAppIdResolver resolver, String parentName, @Nullable Cursor startCursor, int pageSize) throws DatastoreException {
        EntityRef parent = this.parseParent(apiVersion, resolver, parentName);
        Query.Builder queryBuilder = Query.builder();
        queryBuilder.scopeBuilder().isStrong(true).partition(parent.partitionRef());
        queryBuilder.semantics(Query.Semantics.FIRESTORE);
        queryBuilder.isShallow(true);
        if (!parent.pathElements().isEmpty()) {
            queryBuilder.ancestor(parent);
        }
        if (startCursor != null) {
            queryBuilder.startCursor(startCursor);
        }
        if (pageSize != 0) {
            queryBuilder.limit(pageSize);
        }
        return queryBuilder;
    }

    private Query.Builder toBaseShowMissingListDocumentsQuery(InternalHeader.ApiVersion apiVersion, ProjectIdAppIdResolver resolver, ListDocumentsRequest request) throws DatastoreException {
        String collectionId = FirestoreV1ResourceRefToRepConverter.convertEntityCollectionId(request.getCollectionId());
        InvalidConversionException.checkConversion(!collectionId.isEmpty(), "collection id must be set when show_missing is true", new Object[0]);
        InvalidConversionException.checkConversion(!Names.isNameReserved(collectionId), "a collection id cannot be a reserved name.", new Object[0]);
        InvalidConversionException.checkConversion(request.getOrderBy().isEmpty(), "cannot specify an order when show_missing is true", new Object[0]);
        EntityRef parent = this.parseParent(apiVersion, resolver, request.getParent());
        ImmutableList.Builder parentPath = ImmutableList.builder();
        parentPath.addAll(parent.pathElements());
        parentPath.add(EntityRef.PathElement.create("__collection__", EntityRef.ResourceId.createString(collectionId)));
        parent = EntityRef.create(parent.partitionRef(), (List<EntityRef.PathElement>)((Object)parentPath.build()));
        Query.Builder queryBuilder = Query.builder();
        queryBuilder.scopeBuilder().partition(parent.partitionRef());
        queryBuilder.semantics(Query.Semantics.DATASTORE);
        queryBuilder.kind("__document__");
        queryBuilder.isShallow(true);
        queryBuilder.ancestor(parent);
        if (request.getPageSize() > 0) {
            queryBuilder.limit(request.getPageSize());
        }
        if (request.hasMask()) {
            PropertyMask mask = this.propertyPathToRepConverter.convertPropertyMask(apiVersion, request.getMask(), ValidationConstraint.QUERY.withContext(ValidationConstraint.Context.FIRESTORE));
            queryBuilder.propertyMask(new PropertyMask(ImmutableMap.of(DOCUMENT_KIND_CREATED_VERSION_PROPERTY_NAME, PropertyMask.FULL, DOCUMENT_KIND_UPDATED_VERSION_PROPERTY_NAME, PropertyMask.FULL, DOCUMENT_KIND_DOCUMENT_KEY_PROPERTY_NAME, PropertyMask.FULL, DOCUMENT_KIND_DOCUMENT_FIELDS_PROPERTY_NAME, mask)));
        }
        return queryBuilder;
    }

    @Nullable
    private Cursor toCursorForListCollectionIds(String pageToken, @Nullable DatastoreCustomizableConfigPb.DatastoreCustomizableConfig configOverrides) throws DatastoreException {
        QueryResumeToken queryResumeToken = this.toQueryResumeToken(pageToken);
        if (queryResumeToken.getVersionCase() != QueryResumeToken.VersionCase.DATASTORE_LEGACY_CURSOR) {
            throw DatastoreExceptionHelper.badRequest("QueryResumeToken does not match ListCollectionIdsRequest", new Object[0]);
        }
        OnestoreEntity.IndexPostfix indexPostfix = INDEX_POSTFIX_PROTO_2_TO_1_CONVERTER.apply(queryResumeToken.getDatastoreLegacyCursor());
        return this.v3ToRepConverter.convertPostfixCursor(new DatastoreV3Pb.CompiledCursor().setPostfixPosition(indexPostfix), configOverrides);
    }

    public Query toListCollectionIdsQuery(InternalHeader.ApiVersion apiVersion, ProjectIdAppIdResolver resolver, ListCollectionIdsRequest request, @Nullable DatastoreCustomizableConfigPb.DatastoreCustomizableConfig configOverrides) throws DatastoreException {
        String pageToken = request.getPageToken();
        Cursor startCursor = pageToken.isEmpty() ? null : this.toCursorForListCollectionIds(pageToken, configOverrides);
        Query.Builder query = this.toBaseQueryBuilder(apiVersion, resolver, request.getParent(), startCursor, request.getPageSize());
        query.scopeBuilder().isStrong(true);
        return query.kind("__collection__").selectOnlyKeys(true).semantics(Query.Semantics.DATASTORE).build();
    }

    public Query toListDocumentsQuery(InternalHeader.ApiVersion apiVersion, ProjectIdAppIdResolver resolver, ListDocumentsRequest request, long queryFingerprint) throws DatastoreException {
        Query.Builder baseQuery = request.getShowMissing() ? this.toBaseShowMissingListDocumentsQuery(apiVersion, resolver, request) : this.toBaseListDocumentsQuery(apiVersion, resolver, request);
        switch (request.getConsistencySelectorCase()) {
            case CONSISTENCYSELECTOR_NOT_SET: 
            case TRANSACTION: {
                baseQuery.scopeBuilder().isStrong(true);
                break;
            }
            case READ_TIME: {
                long readTimestampMicros = ConverterHelper.timestampsToMicroseconds(request.getReadTime());
                InvalidConversionException.checkConversion(readTimestampMicros > 0L, "Only timestamps past epoch are supported.", new Object[0]);
                baseQuery.scopeBuilder().readTimestamp(readTimestampMicros);
            }
        }
        String pageToken = request.getPageToken();
        if (pageToken.isEmpty()) {
            return baseQuery.build();
        }
        QueryResumeToken queryResumeToken = this.toQueryResumeToken(pageToken);
        return this.queryToRepConverter.convertQueryResumeState(baseQuery.build(), queryFingerprint, queryResumeToken);
    }

    public ShardQueryRequest toPartitionQuery(InternalHeader.ApiVersion apiVersion, ProjectIdAppIdResolver resolver, PartitionQueryRequest request, @Nullable DatastoreCustomizableConfigPb.DatastoreCustomizableConfig configOverrides) throws DatastoreException {
        InvalidConversionException.checkConversion(request.getPartitionCount() > 0L, "Partition count must be greater than zero.", new Object[0]);
        EntityRef parentRef = this.parseParent(apiVersion, resolver, request.getParent());
        QueryScope scope = QueryScope.builder().partition(parentRef.partitionRef()).build();
        Query query = this.queryToRepConverter.convertStructuredQuery(apiVersion, resolver, scope, parentRef.pathElements().isEmpty() ? null : parentRef, request.getStructuredQuery());
        String resumeToken = request.getResumeToken();
        Cursor resumeCursor = resumeToken.isEmpty() ? null : this.queryToRepConverter.convertQueryResumeTokenToCursor(this.toQueryResumeToken(resumeToken), scope.partition().databaseRef());
        return ShardQueryRequest.create(query, Math.toIntExact(request.getPartitionCount()), resumeCursor);
    }

    private Set<OnestoreEntity.Reference> toBatchLookupKeys(ProjectIdAppIdResolver resolver, BatchGetDocumentsRequest request) throws InvalidConversionException {
        HashSet<OnestoreEntity.Reference> keys = new HashSet<OnestoreEntity.Reference>();
        for (String name : request.getDocumentsList()) {
            EntityRef entityRef = this.resourceRefToRepConverter.convertEntityRefServiceRelative(resolver, name);
            keys.add(AppEngV3ResourceRefFromRepConverter.INSTANCE.convertEntityRef(entityRef));
        }
        return keys;
    }

    public Lookup toStreamingBatchGetLookup(InternalHeader.ApiVersion apiVersion, ProjectIdAppIdResolver resolver, BatchGetDocumentsRequest request) throws InvalidConversionException {
        Lookup.Builder lookup = Lookup.builder().allowDefer(true).keys(this.toBatchLookupKeys(resolver, request));
        if (request.hasMask()) {
            lookup.propertyMask(this.propertyPathToRepConverter.convertPropertyMask(apiVersion, request.getMask(), ValidationConstraint.LOOKUP.withContext(ValidationConstraint.Context.FIRESTORE)));
        }
        switch (request.getConsistencySelectorCase()) {
            case CONSISTENCYSELECTOR_NOT_SET: 
            case NEW_TRANSACTION: {
                break;
            }
            case TRANSACTION: {
                break;
            }
            case READ_TIME: {
                long readTimestampMicros = ConverterHelper.timestampsToMicroseconds(request.getReadTime());
                InvalidConversionException.checkConversion(readTimestampMicros > 0L, "Only timestamps past epoch are supported.", new Object[0]);
                lookup.readTimestamp(readTimestampMicros);
            }
        }
        return lookup.build();
    }

    public com.google.cloud.datastore.core.rep.TransactionOptions toTransactionOptions(TransactionOptions options, TransactionOptions.Mode defaultMode) throws InvalidConversionException {
        TransactionOptions.Builder builder = com.google.cloud.datastore.core.rep.TransactionOptions.builder();
        switch (options.getModeCase()) {
            case MODE_NOT_SET: {
                builder.mode(defaultMode);
                break;
            }
            case READ_ONLY: {
                builder.mode(TransactionOptions.Mode.READ_ONLY);
                TransactionOptions.ReadOnly readOnly = options.getReadOnly();
                switch (readOnly.getConsistencySelectorCase()) {
                    case CONSISTENCYSELECTOR_NOT_SET: {
                        break;
                    }
                    case READ_TIME: {
                        long readTimestampMicros = ConverterHelper.timestampsToMicroseconds(readOnly.getReadTime());
                        InvalidConversionException.checkConversion(readTimestampMicros > 0L, "Only timestamps past epoch are supported.", new Object[0]);
                        builder.snapshotVersion(readTimestampMicros);
                    }
                }
                break;
            }
            case READ_WRITE: {
                builder.mode(TransactionOptions.Mode.READ_WRITE);
                ByteString retryTxn = options.getReadWrite().getRetryTransaction();
                if (retryTxn.isEmpty()) break;
                builder.previousTransactionHandle(Transactions.getTransactionHandle(retryTxn));
            }
        }
        return builder.build();
    }
}

